function config() {
	NEW="$1"
	OLD="`dirname $NEW`/`basename $NEW .new`"

	# If there's no config file by that name, mv it over:
	if [ ! -r $OLD ]; then
		echo "--- Renaming $NEW to $OLD"
		mv $NEW $OLD
	elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then
		# toss the redundant copy
		echo "--- Deleting $NEW"
		rm $NEW
	else
		# Otherwise, we leave the .new copy for the admin to consider...
		echo "--- Leaving $NEW for you to replace $OLD"
	fi


}

if ! grep -q ntop /etc/group; then
  echo "Adding Ntop group"
  groupadd ntop &>/dev/null
fi

if ! grep -q ntop /etc/passwd; then
  echo "Adding Ntop user"
  useradd -g ntop -d /var/ntop -c "Network Top User" -s /bin/false ntop &>/dev/null
fi

echo "Setting correct permissions"
chown -R ntop:ntop /var/ntop
chown -R ntop:ntop /usr/share/ntop

for i in /etc/rc.d/rc.ntop.new /etc/ntop/*.new
do
	if [ -f $i ]
	then
		config $i
	fi
done
( cd usr/lib ; rm -rf libpdaPlugin.so )
( cd usr/lib ; ln -sf libpdaPlugin-3.3.8.so libpdaPlugin.so )
( cd usr/lib ; rm -rf libremotePlugin.so )
( cd usr/lib ; ln -sf libremotePlugin-3.3.8.so libremotePlugin.so )
( cd usr/lib ; rm -rf libntop.so )
( cd usr/lib ; ln -sf libntop-3.3.8.so libntop.so )
( cd usr/lib ; rm -rf libnetflowPlugin.so )
( cd usr/lib ; ln -sf libnetflowPlugin-3.3.8.so libnetflowPlugin.so )
( cd usr/lib ; rm -rf librrdPlugin.so )
( cd usr/lib ; ln -sf librrdPlugin-3.3.8.so librrdPlugin.so )
( cd usr/lib ; rm -rf libsflowPlugin.so )
( cd usr/lib ; ln -sf libsflowPlugin-3.3.8.so libsflowPlugin.so )
( cd usr/lib ; rm -rf liblastSeenPlugin.so )
( cd usr/lib ; ln -sf liblastSeenPlugin-3.3.8.so liblastSeenPlugin.so )
( cd usr/lib ; rm -rf libicmpPlugin.so )
( cd usr/lib ; ln -sf libicmpPlugin-3.3.8.so libicmpPlugin.so )
( cd usr/lib ; rm -rf libcpacketPlugin.so )
( cd usr/lib ; ln -sf libcpacketPlugin-3.3.8.so libcpacketPlugin.so )
( cd usr/lib ; rm -rf libntopreport.so )
( cd usr/lib ; ln -sf libntopreport-3.3.8.so libntopreport.so )
