<?xml version='1.0' encoding='ISO-8859-1' standalone='yes'?>
<tagfile>
  <compound kind="class">
    <name>C6_Main</name>
    <filename>classC6__Main.html</filename>
    <member kind="slot">
      <type>void</type>
      <name>updateServerStats</name>
      <anchor>i0</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>SendClose</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>mainMenuSelected</name>
      <anchor>l1</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>ForceClose</name>
      <anchor>l2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>iconizeWin</name>
      <anchor>l3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>buildChat</name>
      <anchor>l4</anchor>
      <arglist>(const QString &amp;nick)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>userMenuAction</name>
      <anchor>l5</anchor>
      <arglist>(const QString &amp;child, USER_MENU_ACTIONS choice, QString root=&quot;&quot;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>changeMyStatus</name>
      <anchor>l6</anchor>
      <arglist>(C6Users::C6USER_STATUS, QString message=QString::null)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>signalMenuChoice</name>
      <anchor>l7</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>newNickReconnect</name>
      <anchor>l8</anchor>
      <arglist>(int nick)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>showAbout</name>
      <anchor>l9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>C6_Main</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>const QString &amp;</type>
      <name>getIdentityName</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOwnerName</name>
      <anchor>a3</anchor>
      <arglist>(QString const &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setShowOnline</name>
      <anchor>a4</anchor>
      <arglist>(bool status)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getShowOnline</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addUser2Menu</name>
      <anchor>a6</anchor>
      <arglist>(QStringList &amp;user)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setUsersCount</name>
      <anchor>a7</anchor>
      <arglist>(unsigned int online, unsigned int offline)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCustomFont</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>refreshList</name>
      <anchor>a9</anchor>
      <arglist>(bool clear=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>updateStats</name>
      <anchor>a10</anchor>
      <arglist>(int counter)</arglist>
    </member>
    <member kind="function">
      <type>C6Users::C6USER_STATUS</type>
      <name>getOnlineStatus</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOnlineStatus</name>
      <anchor>a12</anchor>
      <arglist>(C6Users::C6USER_STATUS status)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOnlineStatus</name>
      <anchor>a13</anchor>
      <arglist>(int status)</arglist>
    </member>
    <member kind="function">
      <type>QPopupMenu *</type>
      <name>getMenuPtr</name>
      <anchor>a14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setListType</name>
      <anchor>a15</anchor>
      <arglist>(LIST_TYPE type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMessageODD</name>
      <anchor>a16</anchor>
      <arglist>(QString const &amp;message)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>getMessageODD</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>C6About</name>
    <filename>classC6About.html</filename>
    <member kind="signal">
      <type>void</type>
      <name>execUrl</name>
      <anchor>l0</anchor>
      <arglist>(QString &amp;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>C6About</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>C6AbstractPlugin</name>
    <filename>classC6AbstractPlugin.html</filename>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>initialize</name>
      <anchor>a2</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QApplication *</type>
      <name>createKApplication</name>
      <anchor>a3</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QString</type>
      <name>getName</name>
      <anchor>a4</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QString</type>
      <name>getDescription</name>
      <anchor>a5</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function">
      <type>QApplication *</type>
      <name>getKdeEntryPoint</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setKdeEntryPoint</name>
      <anchor>a7</anchor>
      <arglist>(QApplication *entryP)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isForKde</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setForKde</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDestroy</name>
      <anchor>a10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>canDestroy</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>C6Button</name>
    <filename>classC6Button.html</filename>
    <member kind="function">
      <type></type>
      <name>C6Button</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent, int x, int y, QString const &amp;off, QString const &amp;on, QString roll=QString::null, int conversion_flag=Qt::DiffuseDither)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSticky</name>
      <anchor>a2</anchor>
      <arglist>(bool isSticky=true)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>C6ChatFactory</name>
    <filename>classC6ChatFactory.html</filename>
    <member kind="function" static="yes">
      <type>static QWidget *</type>
      <name>getChat</name>
      <anchor>e0</anchor>
      <arglist>(ChatType type)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>C6ChatFontDialog</name>
    <filename>classC6ChatFontDialog.html</filename>
    <member kind="function">
      <type></type>
      <name>C6ChatFontDialog</name>
      <anchor>a0</anchor>
      <arglist>(int &amp;fontNo, int &amp;fontSizeNo)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPreview</name>
      <anchor>a2</anchor>
      <arglist>(QString const &amp;font, int size)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static char *</type>
      <name>getFontString</name>
      <anchor>e0</anchor>
      <arglist>(int no)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>C6ChatRoom</name>
    <filename>classC6ChatRoom.html</filename>
    <member kind="signal">
      <type>void</type>
      <name>sendToRoom</name>
      <anchor>l0</anchor>
      <arglist>(QString &amp;channel, QString &amp;str, int)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>exitFromRoom</name>
      <anchor>l1</anchor>
      <arglist>(QString &amp;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>menuUserAction</name>
      <anchor>l2</anchor>
      <arglist>(const QString &amp;roomName, const QString &amp;nick, USER_MENU_ACTIONS action)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>execUrl</name>
      <anchor>l3</anchor>
      <arglist>(QString &amp;url)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>append2Log</name>
      <anchor>l4</anchor>
      <arglist>(QString &amp;room_name, QString &amp;text)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>showProfile</name>
      <anchor>l5</anchor>
      <arglist>(QString &amp;name)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>signalRoomLog</name>
      <anchor>l6</anchor>
      <arglist>(QString &amp;name)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>switchToRoom</name>
      <anchor>l7</anchor>
      <arglist>(QString &amp;room)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>inviteSelected</name>
      <anchor>l8</anchor>
      <arglist>(const QString &amp;room, const QStringList &amp;nick, const QString &amp;message)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>showAbout</name>
      <anchor>l9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const QString &amp;</type>
      <name>getRoomName</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRoomName</name>
      <anchor>a3</anchor>
      <arglist>(QString const &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>updateUserList</name>
      <anchor>a4</anchor>
      <arglist>(QMap&lt; QString, int &gt; &amp;users)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>serviceMessage</name>
      <anchor>a5</anchor>
      <arglist>(QString mess)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>updateMyText</name>
      <anchor>a6</anchor>
      <arglist>(QString &amp;nick, QString &amp;text)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>updateOtherText</name>
      <anchor>a7</anchor>
      <arglist>(QString &amp;nick, QString &amp;text)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>updateTheList</name>
      <anchor>a8</anchor>
      <arglist>(QString const &amp;name, bool isExitFromRoom)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>updateColorFont</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>takeFocus</name>
      <anchor>a10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCustomFont</name>
      <anchor>a11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setKicked</name>
      <anchor>a12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMyNick</name>
      <anchor>a13</anchor>
      <arglist>(QString const &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRoomCaption</name>
      <anchor>a14</anchor>
      <arglist>(QString const &amp;roomName, QString const &amp;roomTopic, int roomAttribute)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>C6Conf</name>
    <filename>classC6Conf.html</filename>
    <member kind="signal">
      <type>void</type>
      <name>playWav</name>
      <anchor>l0</anchor>
      <arglist>(QString snd)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>apply</name>
      <anchor>l1</anchor>
      <arglist>(C6Conf &amp;conf)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>C6Conf</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0)</arglist>
    </member>
    <member kind="function">
      <type>FontInfo const &amp;</type>
      <name>getFontInfo</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setConfigurationMode</name>
      <anchor>a3</anchor>
      <arglist>(C6XCAPClient::CONFIG_MODE mode)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOfflineMode</name>
      <anchor>a4</anchor>
      <arglist>(C6XCAPClient::OFFLINE_MODE mode)</arglist>
    </member>
    <member kind="function">
      <type>C6XCAPClient::CONFIG_MODE</type>
      <name>getConfigurationMode</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>C6XCAPClient::OFFLINE_MODE</type>
      <name>getOfflineMode</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <class kind="class">C6Conf::FontInfo</class>
  </compound>
  <compound kind="class">
    <name>C6Global</name>
    <filename>classC6Global.html</filename>
    <member kind="function">
      <type>const C6ListHash &amp;</type>
      <name>getNetfriendList</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QStringList &amp;</type>
      <name>getSpecialFriendList</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QStringList &amp;</type>
      <name>getAutoRoomList</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QStringList &amp;</type>
      <name>getProfile</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QStringList &amp;</type>
      <name>getPlugins</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QString</type>
      <name>getSkinPath</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QString</type>
      <name>getSharePath</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QString</type>
      <name>getPluginPath</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QString</type>
      <name>getDefaultSoundPath</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const bool</type>
      <name>getTabActivated</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const int</type>
      <name>getBaseFontSize</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const int</type>
      <name>getCaptionFontSize</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QString &amp;</type>
      <name>getCommonPath</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>getRoomListPtr</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRoomListPtr</name>
      <anchor>a16</anchor>
      <arglist>(void *set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>saveNetfriendList</name>
      <anchor>a17</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCommonPath</name>
      <anchor>a18</anchor>
      <arglist>(QString const &amp;path)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTabActivated</name>
      <anchor>a19</anchor>
      <arglist>(bool value)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getProfileEntryIndex</name>
      <anchor>a20</anchor>
      <arglist>(QStringList const &amp;list, QString const &amp;Entry)</arglist>
    </member>
    <member kind="function">
      <type>const QString &amp;</type>
      <name>getC6Directory</name>
      <anchor>a21</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isInSpecialList</name>
      <anchor>a22</anchor>
      <arglist>(QString const &amp;nick)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>initialize</name>
      <anchor>a23</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>C6AbstractPlugin *</type>
      <name>buildPlugin</name>
      <anchor>a24</anchor>
      <arglist>(QString const &amp;pluginName, bool startKapp=true)</arglist>
    </member>
    <member kind="function">
      <type>QApplication *</type>
      <name>initPlugin</name>
      <anchor>a25</anchor>
      <arglist>(C6AbstractPlugin *plugin)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>loadPlugin</name>
      <anchor>a26</anchor>
      <arglist>(QString const &amp;pluginName)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unloadPlugin</name>
      <anchor>a27</anchor>
      <arglist>(const QString fname)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>loadPluginList</name>
      <anchor>a28</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QApplication *</type>
      <name>getKappInstance</name>
      <anchor>a29</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>getLoadedPlugin</name>
      <anchor>a30</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>C6AbstractPlugin *</type>
      <name>getPluginInstance</name>
      <anchor>a31</anchor>
      <arglist>(QString const &amp;fname)</arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>getLoadedPluginName</name>
      <anchor>a32</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addUser</name>
      <anchor>a33</anchor>
      <arglist>(QString const &amp;group, QString const &amp;nick)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addUser</name>
      <anchor>a34</anchor>
      <arglist>(QString const &amp;group, QString const &amp;user, QString const &amp;nick)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeUser</name>
      <anchor>a35</anchor>
      <arglist>(QString const &amp;nick)</arglist>
    </member>
    <member kind="function">
      <type>const QStringList</type>
      <name>getGroupUsers</name>
      <anchor>a36</anchor>
      <arglist>(QString const &amp;group)</arglist>
    </member>
    <member kind="function">
      <type>const QStringList</type>
      <name>getBlackListUsers</name>
      <anchor>a37</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAllUsersOffline</name>
      <anchor>a38</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>C6Users *</type>
      <name>getC6UserPtr</name>
      <anchor>a39</anchor>
      <arglist>(const QString &amp;nick)</arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>getAllUsers</name>
      <anchor>a40</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>groupIsPresent</name>
      <anchor>a41</anchor>
      <arglist>(QString const &amp;group)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addGroup</name>
      <anchor>a42</anchor>
      <arglist>(QString const &amp;group)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>removeGroup</name>
      <anchor>a43</anchor>
      <arglist>(QString const &amp;group)</arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>getAllGroups</name>
      <anchor>a44</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const QString</type>
      <name>getUserGroupName</name>
      <anchor>a45</anchor>
      <arglist>(QString const &amp;user)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isBlackListed</name>
      <anchor>a46</anchor>
      <arglist>(QString const &amp;nick)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>renameGroup</name>
      <anchor>a47</anchor>
      <arglist>(const QString &amp;oldname, const QString &amp;newname)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBehaviourIfMacOSX</name>
      <anchor>a48</anchor>
      <arglist>(QWidget *widget)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>loadSpecialList</name>
      <anchor>a49</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>calibrateSystemFontSize</name>
      <anchor>a50</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFirstBoot</name>
      <anchor>a51</anchor>
      <arglist>(bool set)</arglist>
    </member>
    <member kind="function">
      <type>const QStringList &amp;</type>
      <name>getStyleList</name>
      <anchor>a52</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setWidgetStyle</name>
      <anchor>a53</anchor>
      <arglist>(QString const &amp;style)</arglist>
    </member>
    <member kind="function">
      <type>C6Users::C6UsersList &amp;</type>
      <name>getC6UsersFromGroup</name>
      <anchor>a54</anchor>
      <arglist>(QString const &amp;group)</arglist>
    </member>
    <member kind="function">
      <type>const QString</type>
      <name>getBlackListGroupName</name>
      <anchor>a55</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clearUsersList</name>
      <anchor>a56</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>loadNetfriendListFromFile</name>
      <anchor>a57</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isTheBlackList</name>
      <anchor>a58</anchor>
      <arglist>(QString const &amp;group)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>mergeLocalListToServerSide</name>
      <anchor>a59</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addToWhiteList</name>
      <anchor>a60</anchor>
      <arglist>(QString const &amp;user, QString const &amp;nick)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addToWhiteList</name>
      <anchor>a61</anchor>
      <arglist>(QString const &amp;nick)</arglist>
    </member>
    <member kind="function">
      <type>const QStringList</type>
      <name>getWhiteListUsers</name>
      <anchor>a62</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFromWhiteList</name>
      <anchor>a63</anchor>
      <arglist>(QString const &amp;nick)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isWhiteListed</name>
      <anchor>a64</anchor>
      <arglist>(QString const &amp;nick)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>getWhiteListGroupName</name>
      <anchor>a65</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>saveCurrentIdentity</name>
      <anchor>a66</anchor>
      <arglist>(QString const &amp;loginId, QString const &amp;pw, QString const &amp;messageODD)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>getCurrentIdentityPassword</name>
      <anchor>a67</anchor>
      <arglist>(QString const &amp;loginId)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>getCurrentMessageODDay</name>
      <anchor>a68</anchor>
      <arglist>(QString const &amp;loginId, QString const &amp;nick)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>saveCurrentMessageODDay</name>
      <anchor>a69</anchor>
      <arglist>(QString const &amp;loginId, QString const &amp;message)</arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>C6Singleton&lt;C6Global&gt;</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>C6HttpConnection</name>
    <filename>classC6HttpConnection.html</filename>
    <member kind="signal">
      <type>void</type>
      <name>bufferFull</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>closed</name>
      <anchor>l1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>C6HttpConnection</name>
      <anchor>a0</anchor>
      <arglist>(QString const &amp;urlstr, QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>QByteArray</type>
      <name>getBuffer</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>request</name>
      <anchor>a4</anchor>
      <arglist>(QString const &amp;request)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>request</name>
      <anchor>a5</anchor>
      <arglist>(QHttpRequestHeader const &amp;request)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>request</name>
      <anchor>a6</anchor>
      <arglist>(QHttpRequestHeader const &amp;request, const QByteArray &amp;data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>C6InviteDialog</name>
    <filename>classC6InviteDialog.html</filename>
    <member kind="signal">
      <type>void</type>
      <name>sendSelected</name>
      <anchor>l0</anchor>
      <arglist>(const QStringList &amp;, const QString &amp;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>showAbout</name>
      <anchor>l1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>C6InviteDialog</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>C6Logger</name>
    <filename>classC6Logger.html</filename>
    <member kind="function">
      <type>void</type>
      <name>debugPrint</name>
      <anchor>a2</anchor>
      <arglist>(const char *who, const char *msg,...)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>logChatOnFile</name>
      <anchor>a3</anchor>
      <arglist>(QString const &amp;nick, QString const &amp;from, QString const &amp;message)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>logRoomOnFile</name>
      <anchor>a4</anchor>
      <arglist>(QString &amp;room, QString &amp;message)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>logSystemMessage</name>
      <anchor>a5</anchor>
      <arglist>(QString const &amp;message)</arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>C6Singleton&lt;C6Logger&gt;</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>C6Login</name>
    <filename>classC6Login.html</filename>
    <member kind="signal">
      <type>void</type>
      <name>showAbout</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>forceClose</name>
      <anchor>l1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>startConnect</name>
      <anchor>l2</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>exitClicked</name>
      <anchor>l3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>openConfig</name>
      <anchor>l4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>C6Login</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>getLogin</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>getPassword</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCustomFont</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>C6LogView</name>
    <filename>classC6LogView.html</filename>
    <member kind="signal">
      <type>void</type>
      <name>showAbout</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>C6LogView</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent, QString path)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>show</name>
      <anchor>a2</anchor>
      <arglist>(int choice, QString const &amp;nick=QString::null)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>C6NickList</name>
    <filename>classC6NickList.html</filename>
    <member kind="function">
      <type></type>
      <name>C6NickList</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addNick</name>
      <anchor>a2</anchor>
      <arglist>(QString const &amp;nick)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDefaultIdentity</name>
      <anchor>a3</anchor>
      <arglist>(int i)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>C6PixmapCache</name>
    <filename>classC6PixmapCache.html</filename>
    <member kind="function">
      <type>QPixmap const &amp;</type>
      <name>getPixmap</name>
      <anchor>a1</anchor>
      <arglist>(QString const &amp;filename, int conversion_flag=Qt::DiffuseDither)</arglist>
    </member>
    <member kind="friend" protection="private">
      <type>friend class</type>
      <name>C6Singleton&lt;C6PixmapCache&gt;</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <class kind="class">C6PixmapCache::CacheItem</class>
  </compound>
  <compound kind="class">
    <name>C6Profile</name>
    <filename>classC6Profile.html</filename>
    <member kind="signal">
      <type>void</type>
      <name>showAbout</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>C6Profile</name>
      <anchor>a0</anchor>
      <arglist>(bool isRoom, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>updateUserProfile</name>
      <anchor>a2</anchor>
      <arglist>(unsigned char *data, int packL=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>updateRoomProfile</name>
      <anchor>a3</anchor>
      <arglist>(unsigned char *data, int packL=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCustomFont</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>C6ProxySocket</name>
    <filename>classC6ProxySocket.html</filename>
    <member kind="signal">
      <type>void</type>
      <name>proxyConnected</name>
      <anchor>l0</anchor>
      <arglist>(const QString &amp;ip=QString::null, int port=-1)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>proxyError</name>
      <anchor>l1</anchor>
      <arglist>(int error)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>C6ProxySocket</name>
      <anchor>a0</anchor>
      <arglist>(QObject *parent=0, bool isSock4=false, bool hasPw=false, const char *login=0, const char *pw=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDestConnection</name>
      <anchor>a1</anchor>
      <arglist>(QString const &amp;ip, QString const &amp;port, COMMANDS command=CONNECT)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>connectToHost</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;host, Q_UINT16 port)</arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const int</type>
      <name>SOCKS_VERSION_V5</name>
      <anchor>s0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const int</type>
      <name>SOCKS_VERSION_V4</name>
      <anchor>s1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>C6Report</name>
    <filename>classC6Report.html</filename>
    <member kind="signal">
      <type>void</type>
      <name>execUrl</name>
      <anchor>l0</anchor>
      <arglist>(QString &amp;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>showAbout</name>
      <anchor>l1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>C6Report</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>notifyReport</name>
      <anchor>a2</anchor>
      <arglist>(QString const &amp;nick, QString const &amp;rep)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>C6RoomList</name>
    <filename>classC6RoomList.html</filename>
    <member kind="signal">
      <type>void</type>
      <name>enterRoom</name>
      <anchor>l0</anchor>
      <arglist>(const QString &amp;room_name)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>updateRoomList</name>
      <anchor>l1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>reqRoomProfile</name>
      <anchor>l2</anchor>
      <arglist>(QString &amp;room)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>createRoom</name>
      <anchor>l3</anchor>
      <arglist>(const QString &amp;roomName, const QString &amp;caption, bool isPublic, int index, const QString &amp;password)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>searchRoom</name>
      <anchor>l4</anchor>
      <arglist>(unsigned char *prop)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>showProfile</name>
      <anchor>l5</anchor>
      <arglist>(QString &amp;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>showAbout</name>
      <anchor>l6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>C6RoomList</name>
      <anchor>a0</anchor>
      <arglist>(std::vector&lt; C6Proto::Category &gt; const &amp;category, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setWaitResult</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNoResult</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCustomFont</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>loadCategoryList</name>
      <anchor>a5</anchor>
      <arglist>(std::vector&lt; C6Proto::Category &gt; const &amp;categoryVector)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>updateResults</name>
      <anchor>a6</anchor>
      <arglist>(std::vector&lt; C6Proto::RoomSearchResult &gt; &amp;result)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>C6Settings</name>
    <filename>classC6Settings.html</filename>
    <member kind="function">
      <type>void</type>
      <name>loadSettings</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>saveSettings</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QString const &amp;</type>
      <name>getServerName</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString const &amp;</type>
      <name>getServerPort</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString const &amp;</type>
      <name>getProxyName</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString const &amp;</type>
      <name>getProxyPort</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString const &amp;</type>
      <name>getBlackListMessage</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString const &amp;</type>
      <name>getBusyMessage</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString const &amp;</type>
      <name>getNetFriendsMessage</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString const &amp;</type>
      <name>getAwayMessage</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString const &amp;</type>
      <name>getBrowser</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString const &amp;</type>
      <name>getProfileLink</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString const &amp;</type>
      <name>getFontStyle</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString const &amp;</type>
      <name>getForegndColor</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString const &amp;</type>
      <name>getForeMessageColor</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString const &amp;</type>
      <name>getForeNetFriendColor</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString const &amp;</type>
      <name>getInMessageWav</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString const &amp;</type>
      <name>getOutMessageWav</name>
      <anchor>a19</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString const &amp;</type>
      <name>getOnlineMessageWav</name>
      <anchor>a20</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString const &amp;</type>
      <name>getOfflineMessageWav</name>
      <anchor>a21</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString const &amp;</type>
      <name>getSpecialFriendWav</name>
      <anchor>a22</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString const &amp;</type>
      <name>getSoundPlayer</name>
      <anchor>a23</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString const &amp;</type>
      <name>getFileReceivePath</name>
      <anchor>a24</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString const &amp;</type>
      <name>getStartPort</name>
      <anchor>a25</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString const &amp;</type>
      <name>getLastIdentity</name>
      <anchor>a26</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString const &amp;</type>
      <name>getLastLogin</name>
      <anchor>a27</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString const &amp;</type>
      <name>getCurrentIdentity</name>
      <anchor>a28</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString const &amp;</type>
      <name>getGlobalFontFamily</name>
      <anchor>a29</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString const &amp;</type>
      <name>getProxyUserId</name>
      <anchor>a30</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString const &amp;</type>
      <name>getProxyUserPsw</name>
      <anchor>a31</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString const &amp;</type>
      <name>getContactFontFamily</name>
      <anchor>a32</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString const &amp;</type>
      <name>getContactUserForeColor</name>
      <anchor>a33</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString const &amp;</type>
      <name>getContactGroupForeColor</name>
      <anchor>a34</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString const &amp;</type>
      <name>getWidgetStyle</name>
      <anchor>a35</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getStatus</name>
      <anchor>a36</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getFontSize</name>
      <anchor>a37</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getFontWeight</name>
      <anchor>a38</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getGlobalFontSize</name>
      <anchor>a39</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getGlobalFontWeight</name>
      <anchor>a40</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLoginTimeout</name>
      <anchor>a41</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getContactFontSize</name>
      <anchor>a42</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getContactFontWeight</name>
      <anchor>a43</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getAutoMessage</name>
      <anchor>a44</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getLog</name>
      <anchor>a45</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getAutoConnect</name>
      <anchor>a46</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getReconnect</name>
      <anchor>a47</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getAutoRaise</name>
      <anchor>a48</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getAutoPopUp</name>
      <anchor>a49</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getSysLog</name>
      <anchor>a50</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getRoomLog</name>
      <anchor>a51</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getShowOnline</name>
      <anchor>a52</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getSoundSwitch</name>
      <anchor>a53</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getBeepSwitch</name>
      <anchor>a54</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getInMessageSwitch</name>
      <anchor>a55</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getOutMessageSwitch</name>
      <anchor>a56</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getOnlineMessageSwitch</name>
      <anchor>a57</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getOfflineMessageSwitch</name>
      <anchor>a58</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getSpecialFriendSwitch</name>
      <anchor>a59</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getSpecialNotifySwitch</name>
      <anchor>a60</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getSortAscending</name>
      <anchor>a61</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getIpVisible</name>
      <anchor>a62</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getDockIcon</name>
      <anchor>a63</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getTimeStampSwitch</name>
      <anchor>a64</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getAutoAccept</name>
      <anchor>a65</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getRoomTimeStamp</name>
      <anchor>a66</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getAutoRoomEnter</name>
      <anchor>a67</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getAutoRoomMinimize</name>
      <anchor>a68</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getProtoLog</name>
      <anchor>a69</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getSelectGlobalFont</name>
      <anchor>a70</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getTabbedChat</name>
      <anchor>a71</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getProxySwitch</name>
      <anchor>a72</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getAuthProxySwitch</name>
      <anchor>a73</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getProxySocksVersion</name>
      <anchor>a74</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getAutoAway</name>
      <anchor>a75</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getMinutesAway</name>
      <anchor>a76</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getBackAutoAway</name>
      <anchor>a77</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getContactFontSwitch</name>
      <anchor>a78</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getSoundOnce</name>
      <anchor>a79</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getStyleSwitch</name>
      <anchor>a80</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>getUrlList</name>
      <anchor>a81</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>getPictureUrl</name>
      <anchor>a82</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setServerName</name>
      <anchor>a83</anchor>
      <arglist>(QString set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setServerPort</name>
      <anchor>a84</anchor>
      <arglist>(QString set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProxyName</name>
      <anchor>a85</anchor>
      <arglist>(QString set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProxyPort</name>
      <anchor>a86</anchor>
      <arglist>(QString set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBlackListMessage</name>
      <anchor>a87</anchor>
      <arglist>(QString set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBusyMessage</name>
      <anchor>a88</anchor>
      <arglist>(QString set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNetFriendsMessage</name>
      <anchor>a89</anchor>
      <arglist>(QString set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAwayMessage</name>
      <anchor>a90</anchor>
      <arglist>(QString set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBrowser</name>
      <anchor>a91</anchor>
      <arglist>(QString set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProfileLink</name>
      <anchor>a92</anchor>
      <arglist>(QString set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFontStyle</name>
      <anchor>a93</anchor>
      <arglist>(QString set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setForegndColor</name>
      <anchor>a94</anchor>
      <arglist>(QString set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setForeMessageColor</name>
      <anchor>a95</anchor>
      <arglist>(QString set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setForeNetFriendColor</name>
      <anchor>a96</anchor>
      <arglist>(QString set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setInMessageWav</name>
      <anchor>a97</anchor>
      <arglist>(QString set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOutMessageWav</name>
      <anchor>a98</anchor>
      <arglist>(QString set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOnlineMessageWav</name>
      <anchor>a99</anchor>
      <arglist>(QString set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOfflineMessageWav</name>
      <anchor>a100</anchor>
      <arglist>(QString set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSpecialFriendWav</name>
      <anchor>a101</anchor>
      <arglist>(QString set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSoundPlayer</name>
      <anchor>a102</anchor>
      <arglist>(QString set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFileReceivePath</name>
      <anchor>a103</anchor>
      <arglist>(QString set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStartPort</name>
      <anchor>a104</anchor>
      <arglist>(QString set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLastLogin</name>
      <anchor>a105</anchor>
      <arglist>(QString set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCurrentIdentity</name>
      <anchor>a106</anchor>
      <arglist>(QString set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setGlobalFontFamily</name>
      <anchor>a107</anchor>
      <arglist>(QString set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStatus</name>
      <anchor>a108</anchor>
      <arglist>(int set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFontSize</name>
      <anchor>a109</anchor>
      <arglist>(int set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFontWeight</name>
      <anchor>a110</anchor>
      <arglist>(int set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLoginTimeout</name>
      <anchor>a111</anchor>
      <arglist>(int set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAutoMessage</name>
      <anchor>a112</anchor>
      <arglist>(bool set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLog</name>
      <anchor>a113</anchor>
      <arglist>(bool set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAutoConnect</name>
      <anchor>a114</anchor>
      <arglist>(bool set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setReconnect</name>
      <anchor>a115</anchor>
      <arglist>(bool set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAutoRaise</name>
      <anchor>a116</anchor>
      <arglist>(bool set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAutoPopUp</name>
      <anchor>a117</anchor>
      <arglist>(bool set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSysLog</name>
      <anchor>a118</anchor>
      <arglist>(bool set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRoomLog</name>
      <anchor>a119</anchor>
      <arglist>(bool set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setShowOnline</name>
      <anchor>a120</anchor>
      <arglist>(bool set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSoundSwitch</name>
      <anchor>a121</anchor>
      <arglist>(bool set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBeepSwitch</name>
      <anchor>a122</anchor>
      <arglist>(bool set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setInMessageSwitch</name>
      <anchor>a123</anchor>
      <arglist>(bool set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOutMessageSwitch</name>
      <anchor>a124</anchor>
      <arglist>(bool set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOnlineMessageSwitch</name>
      <anchor>a125</anchor>
      <arglist>(bool set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOfflineMessageSwitch</name>
      <anchor>a126</anchor>
      <arglist>(bool set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSpecialFriendSwitch</name>
      <anchor>a127</anchor>
      <arglist>(bool set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSpecialNotifySwitch</name>
      <anchor>a128</anchor>
      <arglist>(bool set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSortAscending</name>
      <anchor>a129</anchor>
      <arglist>(bool set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setIpVisible</name>
      <anchor>a130</anchor>
      <arglist>(bool set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDockIcon</name>
      <anchor>a131</anchor>
      <arglist>(bool set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTimeStampSwitch</name>
      <anchor>a132</anchor>
      <arglist>(bool set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAutoAccept</name>
      <anchor>a133</anchor>
      <arglist>(bool set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRoomTimeStamp</name>
      <anchor>a134</anchor>
      <arglist>(bool set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAutoRoomEnter</name>
      <anchor>a135</anchor>
      <arglist>(bool set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAutoRoomMinimize</name>
      <anchor>a136</anchor>
      <arglist>(bool set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProtoLog</name>
      <anchor>a137</anchor>
      <arglist>(bool set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSelectGlobalFont</name>
      <anchor>a138</anchor>
      <arglist>(bool set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setGlobalFontSize</name>
      <anchor>a139</anchor>
      <arglist>(int set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setGlobalFontWeight</name>
      <anchor>a140</anchor>
      <arglist>(int set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTabbedChat</name>
      <anchor>a141</anchor>
      <arglist>(bool set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProxySwitch</name>
      <anchor>a142</anchor>
      <arglist>(bool set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAuthProxySwitch</name>
      <anchor>a143</anchor>
      <arglist>(bool set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProxyUserId</name>
      <anchor>a144</anchor>
      <arglist>(QString set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProxyUserPsw</name>
      <anchor>a145</anchor>
      <arglist>(QString set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>saveLoginIdentity</name>
      <anchor>a146</anchor>
      <arglist>(QString const &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setContactFontFamily</name>
      <anchor>a147</anchor>
      <arglist>(QString set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setContactUserForeColor</name>
      <anchor>a148</anchor>
      <arglist>(QString set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setContactGroupForeColor</name>
      <anchor>a149</anchor>
      <arglist>(QString set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setContactFontSize</name>
      <anchor>a150</anchor>
      <arglist>(int set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setContactFontWeight</name>
      <anchor>a151</anchor>
      <arglist>(int set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProxySocksVersion</name>
      <anchor>a152</anchor>
      <arglist>(int set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAutoAway</name>
      <anchor>a153</anchor>
      <arglist>(bool set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMinutesAway</name>
      <anchor>a154</anchor>
      <arglist>(int set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBackAutoAway</name>
      <anchor>a155</anchor>
      <arglist>(int set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setContactFontSwitch</name>
      <anchor>a156</anchor>
      <arglist>(bool set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSoundOnce</name>
      <anchor>a157</anchor>
      <arglist>(bool set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setUrlList</name>
      <anchor>a158</anchor>
      <arglist>(QString set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPictureUrl</name>
      <anchor>a159</anchor>
      <arglist>(QString set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFirstBoot</name>
      <anchor>a160</anchor>
      <arglist>(bool set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStyleSwitch</name>
      <anchor>a161</anchor>
      <arglist>(bool set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setWidgetStyle</name>
      <anchor>a162</anchor>
      <arglist>(QString set)</arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>C6Singleton&lt;C6Settings&gt;</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>C6Smiley</name>
    <filename>classC6Smiley.html</filename>
    <member kind="function">
      <type></type>
      <name>C6Smiley</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0, bool modal=true)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static QString</type>
      <name>getSmileyText</name>
      <anchor>e0</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>loadSmiley</name>
      <anchor>e1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const int</type>
      <name>MAXFACCINE</name>
      <anchor>s0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>C6TabQWidget</name>
    <filename>classC6TabQWidget.html</filename>
    <member kind="signal">
      <type>void</type>
      <name>closeTabWidget</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>C6TabQWidget</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>closeEvent</name>
      <anchor>a2</anchor>
      <arglist>(QCloseEvent *e)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>C6TextEdit</name>
    <filename>classC6TextEdit.html</filename>
    <member kind="signal">
      <type>void</type>
      <name>execUrl</name>
      <anchor>l0</anchor>
      <arglist>(QString &amp;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>C6TextEdit</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent, int x, int y, int width, int height)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>serviceMessage</name>
      <anchor>a2</anchor>
      <arglist>(QString mes, bool time=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>showMyText</name>
      <anchor>a3</anchor>
      <arglist>(QString const &amp;nick, QString const &amp;text, bool time)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>showOtherText</name>
      <anchor>a4</anchor>
      <arglist>(QString const &amp;nick, QString const &amp;text, bool time)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>processRichText</name>
      <anchor>a5</anchor>
      <arglist>(QString text)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>C6TrayIcon</name>
    <filename>classC6TrayIcon.html</filename>
    <member kind="signal">
      <type>void</type>
      <name>incomingClicked</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>incomingDoubleClicked</name>
      <anchor>l1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>C6TrayIcon</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>flashTrayIconStart</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>flashTrayIconStop</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isFlashing</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>trayTimerDone</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTrayIcon</name>
      <anchor>a6</anchor>
      <arglist>(QPixmap *icon)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>mouseDoubleClickEvent</name>
      <anchor>b0</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>mousePressEvent</name>
      <anchor>b1</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>C6Users</name>
    <filename>classC6Users.html</filename>
    <member kind="typedef">
      <type>std::vector&lt; C6Users &gt;</type>
      <name>C6UsersVector</name>
      <anchor>w0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>QPtrList&lt; C6Users &gt;</type>
      <name>C6UsersList</name>
      <anchor>w1</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>C6Users</name>
      <anchor>a0</anchor>
      <arglist>(QString const &amp;user, QString const &amp;nick, C6USER_STATUS stat=U_OFFLINE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>C6Users</name>
      <anchor>a1</anchor>
      <arglist>(QString const &amp;user, QString const &amp;nick, QString const &amp;message, C6USER_STATUS stat=U_OFFLINE)</arglist>
    </member>
    <member kind="function">
      <type>C6Users</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(C6Users &amp;right)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMessaged</name>
      <anchor>a4</anchor>
      <arglist>(bool set)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isMessaged</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QString &amp;</type>
      <name>getNick</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>C6USER_STATUS</type>
      <name>getStatus</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStatus</name>
      <anchor>a8</anchor>
      <arglist>(C6USER_STATUS stat)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNick</name>
      <anchor>a9</anchor>
      <arglist>(QString const &amp;nick)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setUser</name>
      <anchor>a10</anchor>
      <arglist>(QString &amp;user)</arglist>
    </member>
    <member kind="function">
      <type>QString const &amp;</type>
      <name>getUser</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isOnline</name>
      <anchor>a12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDailyMessage</name>
      <anchor>a13</anchor>
      <arglist>(QString const &amp;message)</arglist>
    </member>
    <member kind="function">
      <type>const QString &amp;</type>
      <name>getDailyMessage</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>isStatusOnline</name>
      <anchor>e0</anchor>
      <arglist>(C6USER_STATUS status)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>C6Utils</name>
    <filename>classC6Utils.html</filename>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>dumpPacket</name>
      <anchor>e0</anchor>
      <arglist>(const char *origin, unsigned char *data, int len)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>C6XCAPClient</name>
    <filename>classC6XCAPClient.html</filename>
    <member kind="signal">
      <type>void</type>
      <name>buddyListReady</name>
      <anchor>l0</anchor>
      <arglist>(QByteArray &amp;data)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>buddyAuthReady</name>
      <anchor>l1</anchor>
      <arglist>(QByteArray &amp;data)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>buddyConfigReady</name>
      <anchor>l2</anchor>
      <arglist>(QByteArray &amp;data)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>xcapResponseOK</name>
      <anchor>l3</anchor>
      <arglist>(C6XCAPClient::XCAP_STATE status)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setUserPassword</name>
      <anchor>a2</anchor>
      <arglist>(QString const &amp;user, QString const &amp;password)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>requestBuddyList</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addBuddy</name>
      <anchor>a4</anchor>
      <arglist>(QString const &amp;group, QString const &amp;nick)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addBuddyToBlackList</name>
      <anchor>a5</anchor>
      <arglist>(QString const &amp;nick)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeBuddy</name>
      <anchor>a6</anchor>
      <arglist>(QString const &amp;group, QString const &amp;nick)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeBuddyFromBlackList</name>
      <anchor>a7</anchor>
      <arglist>(QString const &amp;nick)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setUserPassword</name>
      <anchor>a8</anchor>
      <arglist>(QString const nick)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setXCAPState</name>
      <anchor>a9</anchor>
      <arglist>(XCAP_STATE state)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>getEntryString</name>
      <anchor>a10</anchor>
      <arglist>(QString const &amp;user)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>getListString</name>
      <anchor>a11</anchor>
      <arglist>(QString const &amp;group, QString const &amp;entry)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addBuddyList</name>
      <anchor>a12</anchor>
      <arglist>(QString const &amp;group, QStringList const &amp;nick)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addGroup</name>
      <anchor>a13</anchor>
      <arglist>(QString const &amp;group)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeGroup</name>
      <anchor>a14</anchor>
      <arglist>(QString const &amp;group)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>renameGroup</name>
      <anchor>a15</anchor>
      <arglist>(QString const &amp;oldGroup, QString const &amp;newGroup)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setConfiguration</name>
      <anchor>a16</anchor>
      <arglist>(CONFIG_MODE mode)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOfflineMessage</name>
      <anchor>a17</anchor>
      <arglist>(OFFLINE_MODE mode)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>getConfigurationMode</name>
      <anchor>a18</anchor>
      <arglist>(CONFIG_MODE mode)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>getOfflineMode</name>
      <anchor>a19</anchor>
      <arglist>(OFFLINE_MODE mode)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getConfigurationModeValue</name>
      <anchor>a20</anchor>
      <arglist>(QString mode)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getOfflineModeValue</name>
      <anchor>a21</anchor>
      <arglist>(QString mode)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>initBuddyList</name>
      <anchor>a22</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>initAuthorization</name>
      <anchor>a23</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>initConfiguration</name>
      <anchor>a24</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBuddyLists</name>
      <anchor>a25</anchor>
      <arglist>(XCAPListType list, QStringList const &amp;blacklist, QStringList const &amp;whitelist, CONFIG_MODE mode)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addBuddyToWhiteList</name>
      <anchor>a26</anchor>
      <arglist>(QString const &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeBuddyFromWhiteList</name>
      <anchor>a27</anchor>
      <arglist>(QString const &amp;nick)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>C6XferProto</name>
    <filename>classC6XferProto.html</filename>
    <member kind="signal">
      <type>void</type>
      <name>xferAborted</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>xferProgress</name>
      <anchor>l1</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>receiveProgress</name>
      <anchor>l2</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>xferError</name>
      <anchor>l3</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>xferClosed</name>
      <anchor>l4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>signalFileSpec</name>
      <anchor>l5</anchor>
      <arglist>(QString &amp;, long int)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>signalGateway</name>
      <anchor>l6</anchor>
      <arglist>(const QString &amp;ip, int port)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>C6XferProto</name>
      <anchor>a0</anchor>
      <arglist>(QHostAddress l_ip, int l_port, QString l_file, QString l_nick)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>C6XferProto</name>
      <anchor>a1</anchor>
      <arglist>(int socket)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>C6XferProto</name>
      <anchor>a2</anchor>
      <arglist>(QString const &amp;ip, int l_port, QString const &amp;user)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fire</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>sendAck</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reset</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>sendEndOfTransfer</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ChatView</name>
    <filename>classChatView.html</filename>
    <member kind="signal">
      <type>void</type>
      <name>AddThisNick</name>
      <anchor>l0</anchor>
      <arglist>(QString)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>AddNickFromChat</name>
      <anchor>l1</anchor>
      <arglist>(QString &amp;, QString &amp;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>SaveConversation</name>
      <anchor>l2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>Append2Log</name>
      <anchor>l3</anchor>
      <arglist>(QString &amp;, QString &amp;, QString &amp;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>ShowProfile</name>
      <anchor>l4</anchor>
      <arglist>(QString)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>SignalMenuCommand</name>
      <anchor>l5</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>ShowUserLog</name>
      <anchor>l6</anchor>
      <arglist>(QString)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>xferOn</name>
      <anchor>l7</anchor>
      <arglist>(void *obj)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>messageSent</name>
      <anchor>l8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>sendFile</name>
      <anchor>l9</anchor>
      <arglist>(QString, QString, int)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>chatIsActive</name>
      <anchor>l10</anchor>
      <arglist>(ChatView *)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>removeChatFromList</name>
      <anchor>l11</anchor>
      <arglist>(const QString &amp;nick)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>sendChatMessage</name>
      <anchor>l12</anchor>
      <arglist>(QString &amp;nick, bool isOnline, QString &amp;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>execUrl</name>
      <anchor>l13</anchor>
      <arglist>(QString &amp;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>showAbout</name>
      <anchor>l14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>signalGateway</name>
      <anchor>l15</anchor>
      <arglist>(const QString &amp;ip, int port, const QString &amp;nickToGrant)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>acceptReception</name>
      <anchor>l16</anchor>
      <arglist>(bool accept, const QString &amp;from)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>acceptAuthorization</name>
      <anchor>l17</anchor>
      <arglist>(bool accept, const QString &amp;from)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>updateOtherText</name>
      <anchor>a2</anchor>
      <arglist>(QString &amp;nick, QString &amp;text, C6Proto::C6MessageStyle *inStyle=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ResetChat</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>updateColorFont</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMyNick</name>
      <anchor>a5</anchor>
      <arglist>(QString const &amp;nick)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>startTransfer</name>
      <anchor>a6</anchor>
      <arglist>(QHostAddress ip, int port, QString const &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isReceiveOn</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getServerPort</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setReceive</name>
      <anchor>a9</anchor>
      <arglist>(bool state)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>activateFileServer</name>
      <anchor>a10</anchor>
      <arglist>(QString const &amp;ip=QString::null, int port=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>serviceMessage</name>
      <anchor>a11</anchor>
      <arglist>(QString mess)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>takeFocus</name>
      <anchor>a12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>show</name>
      <anchor>a13</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCustomFont</name>
      <anchor>a14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getFocus</name>
      <anchor>a15</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>getOtherNick</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>canRaise</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isOnline</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setUserStatus</name>
      <anchor>a19</anchor>
      <arglist>(bool status)</arglist>
    </member>
    <member kind="function">
      <type>QColor &amp;</type>
      <name>getCurrentWritingColor</name>
      <anchor>a20</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMessaged</name>
      <anchor>a21</anchor>
      <arglist>(bool set)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isMessaged</name>
      <anchor>a22</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFriendNick</name>
      <anchor>a23</anchor>
      <arglist>(QString const &amp;nick)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFileTransferReceivePort</name>
      <anchor>a24</anchor>
      <arglist>(int port)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOtherClientInfo</name>
      <anchor>a25</anchor>
      <arglist>(unsigned char *data, int len)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isBoldToggled</name>
      <anchor>a26</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isItalicToggled</name>
      <anchor>a27</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isUnderlineToggled</name>
      <anchor>a28</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getCurrentFontNo</name>
      <anchor>a29</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getCurrentFontSizePt</name>
      <anchor>a30</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ProgressIndicator</name>
    <filename>classProgressIndicator.html</filename>
    <member kind="slot">
      <type>void</type>
      <name>setProgress</name>
      <anchor>i0</anchor>
      <arglist>(int value)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>forceClose</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ProgressIndicator</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>closeEvent</name>
      <anchor>a2</anchor>
      <arglist>(QCloseEvent *e)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SOManager</name>
    <filename>classSOManager.html</filename>
    <member kind="function">
      <type>void</type>
      <name>addLibrary</name>
      <anchor>a2</anchor>
      <arglist>(QString const &amp;fname)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeLibrary</name>
      <anchor>a3</anchor>
      <arglist>(QString const &amp;fname)</arglist>
    </member>
    <member kind="function">
      <type>QLibrary *</type>
      <name>getHandle</name>
      <anchor>a4</anchor>
      <arglist>(QString const &amp;fname)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getLibrarySymbol</name>
      <anchor>a5</anchor>
      <arglist>(void **, QString const &amp;, QString const &amp;symbolName)</arglist>
    </member>
  </compound>
  <compound kind="dir">
    <name>openc6/plugins/kdegui/</name>
    <path>/home/alfarano/openc6/plugins/kdegui/</path>
    <filename>dir_000002.html</filename>
    <dir>openc6/plugins/kdegui/src/</dir>
    <file>config.h</file>
  </compound>
  <compound kind="dir">
    <name>openc6/</name>
    <path>/home/alfarano/openc6/</path>
    <filename>dir_000000.html</filename>
    <dir>openc6/plugins/</dir>
    <dir>openc6/src/</dir>
    <file>config.h</file>
  </compound>
  <compound kind="dir">
    <name>openc6/plugins/</name>
    <path>/home/alfarano/openc6/plugins/</path>
    <filename>dir_000001.html</filename>
    <dir>openc6/plugins/kdegui/</dir>
  </compound>
  <compound kind="dir">
    <name>openc6/src/</name>
    <path>/home/alfarano/openc6/src/</path>
    <filename>dir_000004.html</filename>
    <file>aboutDlg.cpp</file>
    <file>aboutDlg.h</file>
    <file>aboutDlg.moc</file>
    <file>base64.c</file>
    <file>base64.h</file>
    <file>blowfish.c</file>
    <file>blowfish.h</file>
    <file>c6.cpp</file>
    <file>c6.h</file>
    <file>c6.moc.cpp</file>
    <file>c6_main.cpp</file>
    <file>c6_main.h</file>
    <file>c6_main.moc.cpp</file>
    <file>c6about.cpp</file>
    <file>c6about.h</file>
    <file>c6about.moc.cpp</file>
    <file>c6abstractplugin.cpp</file>
    <file>c6abstractplugin.h</file>
    <file>c6abstractplugin.moc</file>
    <file>c6button.cpp</file>
    <file>c6button.h</file>
    <file>c6button.moc.cpp</file>
    <file>c6chatfactory.cpp</file>
    <file>c6chatfactory.h</file>
    <file>c6chatfontdialog.cpp</file>
    <file>c6chatfontdialog.h</file>
    <file>c6chatfontdialog.moc</file>
    <file>c6chatroom.cpp</file>
    <file>c6chatroom.h</file>
    <file>c6chatroom.moc</file>
    <file>c6conf.cpp</file>
    <file>c6conf.h</file>
    <file>c6conf.moc.cpp</file>
    <file>c6global.cpp</file>
    <file>c6global.h</file>
    <file>c6httpconnection.cpp</file>
    <file>c6httpconnection.h</file>
    <file>c6httpconnection.moc</file>
    <file>c6invitedialog.cpp</file>
    <file>c6invitedialog.h</file>
    <file>c6invitedialog.moc</file>
    <file>c6logger.cpp</file>
    <file>c6logger.h</file>
    <file>c6login.cpp</file>
    <file>c6login.h</file>
    <file>c6login.moc.cpp</file>
    <file>c6logview.cpp</file>
    <file>c6logview.h</file>
    <file>c6logview.moc.cpp</file>
    <file>c6nicklist.cpp</file>
    <file>c6nicklist.h</file>
    <file>c6nicklist.moc.cpp</file>
    <file>c6pixmapcache.cpp</file>
    <file>c6pixmapcache.h</file>
    <file>c6pluginmanager.cpp</file>
    <file>c6pluginmanager.h</file>
    <file>c6profile.cpp</file>
    <file>c6profile.h</file>
    <file>c6profile.moc.cpp</file>
    <file>c6proto.cpp</file>
    <file>c6proto.h</file>
    <file>c6proto.moc.cpp</file>
    <file>c6proxysocket.cpp</file>
    <file>c6proxysocket.h</file>
    <file>c6proxysocket.moc</file>
    <file>c6report.cpp</file>
    <file>c6report.h</file>
    <file>c6report.moc.cpp</file>
    <file>c6roomlist.cpp</file>
    <file>c6roomlist.h</file>
    <file>c6roomlist.moc</file>
    <file>c6search.cpp</file>
    <file>c6search.h</file>
    <file>c6search.moc.cpp</file>
    <file>c6settings.cpp</file>
    <file>c6settings.h</file>
    <file>c6singleton.h</file>
    <file>c6smiley.cpp</file>
    <file>c6smiley.h</file>
    <file>c6smiley.moc.cpp</file>
    <file>c6tabwidget.cpp</file>
    <file>c6tabwidget.h</file>
    <file>c6tabwidget.moc</file>
    <file>c6textedit.cpp</file>
    <file>c6textedit.h</file>
    <file>c6textedit.moc</file>
    <file>c6trayicon.cpp</file>
    <file>c6trayicon.h</file>
    <file>c6users.cpp</file>
    <file>c6users.h</file>
    <file>c6usersmanager.cpp</file>
    <file>c6usersmanager.h</file>
    <file>c6utils.cpp</file>
    <file>c6utils.h</file>
    <file>c6xcapclient.cpp</file>
    <file>c6xcapclient.h</file>
    <file>c6xcapclient.moc.cpp</file>
    <file>chat.cpp</file>
    <file>chat.h</file>
    <file>chat.moc</file>
    <file>chatroom.cpp</file>
    <file>chatroom.h</file>
    <file>chatroom.moc</file>
    <file>chatview.cpp</file>
    <file>chatview.h</file>
    <file>chatview.moc.cpp</file>
    <file>configure.cpp</file>
    <file>configure.h</file>
    <file>configure.moc</file>
    <file>configure.ui.h</file>
    <file>connectDlg.cpp</file>
    <file>connectDlg.h</file>
    <file>connectDlg.moc</file>
    <file>decoder.cpp</file>
    <file>font.cpp</file>
    <file>font.h</file>
    <file>font.moc</file>
    <file>invite.cpp</file>
    <file>invite.h</file>
    <file>invite.moc</file>
    <file>login_dlg.cpp</file>
    <file>login_dlg.h</file>
    <file>login_dlg.moc</file>
    <file>logview.cpp</file>
    <file>logview.h</file>
    <file>logview.moc</file>
    <file>macroetc.h</file>
    <file>main.cpp</file>
    <file>mainDlg.cpp</file>
    <file>mainDlg.h</file>
    <file>mainDlg.moc</file>
    <file>md5.c</file>
    <file>md5.h</file>
    <file>nickform.cpp</file>
    <file>nickform.h</file>
    <file>nickform.moc</file>
    <file>profile.cpp</file>
    <file>profile.h</file>
    <file>profile.moc</file>
    <file>progressindicator.cpp</file>
    <file>progressindicator.h</file>
    <file>progressindicator.moc.cpp</file>
    <file>protosupport.cpp</file>
    <file>protosupport.h</file>
    <file>report.cpp</file>
    <file>report.h</file>
    <file>report.moc</file>
    <file>rooms.cpp</file>
    <file>rooms.h</file>
    <file>rooms.moc</file>
    <file>search.cpp</file>
    <file>search.h</file>
    <file>search.moc</file>
  </compound>
  <compound kind="dir">
    <name>openc6/plugins/kdegui/src/</name>
    <path>/home/alfarano/openc6/plugins/kdegui/src/</path>
    <filename>dir_000003.html</filename>
    <file>c6trayicon.cpp</file>
    <file>c6trayicon.h</file>
    <file>c6trayicon.moc</file>
    <file>kdegui.cpp</file>
    <file>kdegui.h</file>
    <file>kdegui.moc</file>
  </compound>
</tagfile>
