/***************************************************************************
                          c6trayicon.cpp  -  description
                             -------------------
    begin                : Thu Jan 29 2004
    copyright            : (C) 2004 by Giorgio A.
    email                : openc6@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "c6trayicon.h"
#include "../../../src/c6global.h"
#include "../../../src/c6pixmapcache.h"
#include "../../../src/c6_main.h"
#include <kpopupmenu.h>
#include <qpixmap.h>
#include <qtooltip.h>
#include <qsignal.h>

C6TrayIcon::C6TrayIcon(QWidget *parent, const char *name) : KSystemTray(parent,name)
        ,_trayOrdinary(0)
        ,_trayFlash(0)
        ,trayIconStatus(false)
        ,flashing(false)
{
    C6PixmapCache &pixmap = C6PixmapCache::getInstance();
    C6Global &global = C6Global::getInstance();
    QString path = global.getSkinPath();

    _trayFlash =  const_cast<QPixmap*>(&pixmap.getPixmap(path+"unreadmessage.png"));
    _trayOrdinary =  const_cast<QPixmap*>(&pixmap.getPixmap(path+"Contact_green.png"));
    setPixmap(*_trayOrdinary);   
    
    KPopupMenu *menu = contextMenu();
    menu->changeTitle(menu->idAt(0),pixmap.getPixmap(path+"icon16x16.png"),"OpenC6");
    
    C6_Main* mainDialog = dynamic_cast<C6_Main*>(parent);
    if (mainDialog != 0)
    {
	menu->insertItem("Menu",mainDialog->getMenuPtr());
    }

    QString text ="Ad icona lampeggiante un click del pulsante destro mostra un popup con tutti i messaggi in arrivo \n";
    text+="Ad icona lampeggiante un doppio click del pulsante sinistro mostra l'ultimo messaggio ricevuto";
    QToolTip::add
        (this,text);
}

C6TrayIcon::~C6TrayIcon()
{}

void C6TrayIcon::flashTrayIconStart()
{
    trayIconStatus = false;
    flashing = true;
}

void C6TrayIcon::flashTrayIconStop()
{
    setPixmap(*_trayOrdinary);
    trayIconStatus = false;
    flashing = false;
}

void C6TrayIcon::trayTimerDone()
{
    trayIconStatus = !trayIconStatus;

    if (trayIconStatus)
    {
        setPixmap(*_trayFlash);
    }
    else
    {
        setPixmap(*_trayOrdinary);
    }
}

void C6TrayIcon::mouseDoubleClickEvent(QMouseEvent *e)
{
    if ((e->button() == QMouseEvent::LeftButton) && flashing)
    {
        e->accept();
        emit incomingDoubleClicked();
    }
}
void C6TrayIcon::mousePressEvent(QMouseEvent *e)
{
    if (e->button() == QMouseEvent::RightButton)
    {
        if (flashing)
        {
            e->accept();
            emit incomingClicked();
        }
        else
        {
            KSystemTray::mousePressEvent(e);
        }
    }
    else
        if (!flashing)
        {
            KSystemTray::mousePressEvent(e);
        }
}

bool C6TrayIcon::isFlashing()
{
    return(flashing);
}

void C6TrayIcon::setTrayIcon(QPixmap *icon)
{
    _trayOrdinary = icon;
    setPixmap(*_trayOrdinary);      
}      

#include "c6trayicon.moc"
