/***************************************************************************
                          c6trayicon.h  -  description
                             -------------------
    begin                : Thu Jan 29 2004
    copyright            : (C) 2004 by Giorgio A.
    email                : openc6@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef C6TRAYICON_H
#define C6TRAYICON_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwidget.h>
#include <ksystemtray.h>
#include "../../../src/c6users.h"

class QPopupMenu;
class QPixmap;
class QWidget;

/**
  *@author Giorgio A.
  */

class C6TrayIcon : public KSystemTray
{
    Q_OBJECT
public:
    
    
    C6TrayIcon(QWidget *parent=0, const char *name=0);
    ~C6TrayIcon();

    void flashTrayIconStart();
    void flashTrayIconStop();
    bool isFlashing();
    void trayTimerDone();
    void setTrayIcon(QPixmap *icon);      
private:
    QPixmap* _trayOrdinary;
    QPixmap* _trayFlash;
      
    bool trayIconStatus;
    bool flashing;
    
protected:
    virtual void mouseDoubleClickEvent(QMouseEvent *e);
    virtual void mousePressEvent(QMouseEvent *e);
signals:
    void incomingClicked();
    void incomingDoubleClicked();
};


#endif
