/***************************************************************************
 *   Copyright (C) 2005 by Giorgio Alfarano   *
 *   openc6@hotmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _KDEGUI_H_
#define _KDEGUI_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

class C6TrayIcon;
class KPopupMenu;
class QTimer;
class C6Msg;
class ChatView;
class QPixmap;

#include <qptrlist.h>

#include "../../../src/c6abstractplugin.h"
#include "../../../src/c6users.h"
#define TRAY_ICONS_MAX 4
 
class KdeGuiPlugin : public C6AbstractPlugin
{
    Q_OBJECT
public:
    
    enum IconState
    {
        AVAILABLE = 0,
        AWAY,
        BUSY,
        NETFRIEND                
    };                
       
    /**
     * Default Constructor
     */
    KdeGuiPlugin();

    /**
     * Default Destructor
     */

    virtual ~KdeGuiPlugin();
    virtual void initialize();
    virtual QApplication* createKApplication();
    virtual QString getName();   
    virtual QString getDescription();      
private:
    C6TrayIcon* _trayIcon;
    KPopupMenu* _trayList;
    QTimer* _trayIconTimer;
    QPtrList<C6Msg> _incomingMessageList;
    
    QPixmap *_trayOrdinary[TRAY_ICONS_MAX];    
    C6Users::C6USER_STATUS _currentStatus;
    
    void trayIconFlashStop();
    void trayIconFlashStart();

private slots:
    void trayIconClicked();
    void trayIconDoubleClicked();
    void trayListClicked(int id);
    void trayTimerDone();
    void trayQuitSelected();   
    void showSysTray();
    void hideSysTray();   
    void enqueueIncomingMessage(QString time,QString& nick,void* pchat); 
    void removeMessageFromList(ChatView *);
    void setIconStatus(C6Users::C6USER_STATUS status);   
};

class KdeGuiFactory : public C6PlugInFactory
{
public:
    KdeGuiFactory(): _instance(0)
    {}

    ~KdeGuiFactory()
    {}

    virtual KdeGuiPlugin* getPluginInstance()
    {
        if (_instance == 0)
        {
            _instance = new KdeGuiPlugin();  
        }           
        
        return _instance;
    }
    
    virtual void destroyPlugin()
    {
        delete _instance;
    }    
    
    private:
        KdeGuiPlugin* _instance;
};


#endif // _KDEGUI_H_
