/***************************************************************************
                          c6_main.h  -  description
                             -------------------
    begin                : Sat Feb 15 2003
    copyright            : (C) 2003 by Giorgio A.
    email                : openc6@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef C6_MAIN_H
#define C6_MAIN_H

#include "mainDlg.h"
#include "macroetc.h"
#include "c6users.h"
#define MAXSTATUS 4

class QString;
class QWidget;
class C6Button;
class QPopupMenu;
class QListViewItem;
class C6ContactListItem;
class C6ContactListTip;
class C6PhotoRetriever;
class QMenuBar;

/**
  *@author Giorgio A.
  */

class C6_Main : public MainDlg
{
    Q_OBJECT
public:

    enum LIST_TYPE
    {
        NETFRIEND_LIST,
        WHITE_LIST,
        BLACK_LIST
    };

    C6_Main(QWidget *parent=0, const char *name=0);
    ~C6_Main();
    const QString& getIdentityName();
    void setOwnerName(QString const &);
    void setShowOnline(bool status);
    bool getShowOnline();
    void addUser2Menu(QStringList &user);
    void setUsersCount(unsigned int online,unsigned int offline);
    void setCustomFont();
    /** Refresh the friend list to update the online status  */
    void refreshList(bool clear = false);
    void updateStats(int counter);
    C6Users::C6USER_STATUS getOnlineStatus() const;
    void setOnlineStatus(C6Users::C6USER_STATUS status);
    void setOnlineStatus(int status);
    QPopupMenu* getMenuPtr();
    void setListType(LIST_TYPE type);
    void setMessageODD(QString const& message);
    QString getMessageODD() const;

public slots:
    void updateServerStats(const QString &);

private: // Private methods
    void closeEvent(QCloseEvent *e);
    bool event(QEvent * e);
    C6ContactListItem* addListItem(QListViewItem *root,C6Users *tmp,QPixmap *icon);
    void  cleanOrphanedGroup();
    QListViewItem*  findGroupItem(const QString & group);
    int messageBox(QString const & text);
    
    int _onlineStatus;
    QString identityName;
    bool showOnline;
    QPopupMenu* _groupMenu;
    QPopupMenu* _userMenu;
    QPopupMenu* _mainMenu;
    QPopupMenu* nickMenu;
    QPopupMenu* _subUserMenu;
    QPopupMenu* _subList;
    QPopupMenu* _subListFromMenu;   
    QMenuBar* _menuBar;    
    QPixmap* statusPixmap[MAXSTATUS];
    QPixmap* _freeIcon;
    QPixmap* _busyIcon;
    QPixmap* _awayIcon;
    QPixmap* _netfriendIcon;
    QPixmap* _messagedIcon;
    QPixmap* _specialIcon;
    QPixmap* _offlineIcon;
    QPixmap* _groupIcon;
    C6ContactListTip *_tip;
    LIST_TYPE _listType;
    QString _messageODD;
    C6PhotoRetriever* _photoRetriever;

    
signals: // Signals
    void SendClose();
    void mainMenuSelected(int);
    void ForceClose();
    void iconizeWin();
    void buildChat(const QString & nick);
    void userMenuAction(const QString & child,USER_MENU_ACTIONS choice,QString root="");
    void changeMyStatus(C6Users::C6USER_STATUS,const QString& message = QString::null);
    void signalMenuChoice(int);
    void newNickReconnect(int nick);
    void showAbout();

private slots:
    void openChat(QListViewItem * item);
    void showMenus(QListViewItem *,const QPoint &,int);
    void chooseFromMenu(int);
    void chooseFromPopupMenu(int);   
    void nickSelected(int nick);
    void closeMain();
    void menuClicked();
    void changeStatus(int status);
    void aboutClicked();
    void showListCheck();
    void showListCheckFromMenu();
    void messageODDReturnPressed();
    void setListCheck(int id);
    void setListCheckAndRefresh(int id);   
    void messageODDLostFocus();
    void setPhoto(QByteArray& data,const QString& filename);
private:
    void fillListCheck(QPopupMenu *menu);   
    void buildMenus();
    virtual void mouseMoveEvent(QMouseEvent * e);   
};

#endif
