/***************************************************************************
                          c6about.cpp  -  description
                             -------------------
    begin                : Mon May 5 2003
    copyright            : (C) 2003 by Giorgio A.
    email                : openc6@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "c6about.h"
#include <qwidget.h>
#include <qcolor.h>
#include <qtextedit.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qpalette.h>
#include <qcolor.h>
#include "c6button.h"
#include "c6textedit.h"
#include "c6settings.h"
#include "c6global.h"

#if defined(Q_OS_MACX) || defined(Q_OS_DARWIN)
#define EDITION "MAC Edition"
#else 
#define EDITION "Unix Edition"
#endif

C6About::C6About(QWidget *parent, const char *name ) : AboutDlg(parent,name)
{
    C6Global &global = C6Global::getInstance();
    QString path = global.getSkinPath();

    aboutPlaceHolder->hide();
    Say = new C6TextEdit(this,0,0,0,0);
    Say->setMinimumSize(QSize(570, 290));
    Say->setFrameShape( QTextEdit::Box);
    Say->setFrameShadow(QTextEdit::Plain);
    Say->setLineWidth( 1 );
    Say->setPaletteBackgroundColor("#ffffff");
    QPalette pal;
    QColorGroup cg;
    cg.setColor( QColorGroup::Foreground, QColor( 3, 118, 231) );
    cg.setColor( QColorGroup::Button, QColor( 221, 223, 228) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, QColor( 238, 239, 241) );
    cg.setColor( QColorGroup::Dark, QColor( 110, 111, 114) );
    cg.setColor( QColorGroup::Mid, QColor( 147, 149, 152) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, white );
    cg.setColor( QColorGroup::ButtonText, black );
    cg.setColor( QColorGroup::Base, white );
    cg.setColor( QColorGroup::Background, white );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setColor( QColorGroup::Highlight, QColor( 103, 141, 178) );
    cg.setColor( QColorGroup::HighlightedText, white );
    cg.setColor( QColorGroup::Link, QColor( 0, 0, 238) );
    cg.setColor( QColorGroup::LinkVisited, QColor( 82, 24, 139) );
    pal.setActive( cg );
    cg.setColor( QColorGroup::Foreground, QColor( 3, 118, 231) );
    cg.setColor( QColorGroup::Button, QColor( 221, 223, 228) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, QColor( 254, 254, 255) );
    cg.setColor( QColorGroup::Dark, QColor( 110, 111, 114) );
    cg.setColor( QColorGroup::Mid, QColor( 147, 149, 152) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, white );
    cg.setColor( QColorGroup::ButtonText, black );
    cg.setColor( QColorGroup::Base, white );
    cg.setColor( QColorGroup::Background, white );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setColor( QColorGroup::Highlight, QColor( 103, 141, 178) );
    cg.setColor( QColorGroup::HighlightedText, white );
    cg.setColor( QColorGroup::Link, QColor( 0, 0, 238) );
    cg.setColor( QColorGroup::LinkVisited, QColor( 82, 24, 139) );
    pal.setInactive( cg );
    cg.setColor( QColorGroup::Foreground, QColor( 128, 128, 128) );
    cg.setColor( QColorGroup::Button, QColor( 221, 223, 228) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, QColor( 254, 254, 255) );
    cg.setColor( QColorGroup::Dark, QColor( 110, 111, 114) );
    cg.setColor( QColorGroup::Mid, QColor( 147, 149, 152) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, white );
    cg.setColor( QColorGroup::ButtonText, QColor( 128, 128, 128) );
    cg.setColor( QColorGroup::Base, white );
    cg.setColor( QColorGroup::Background, white );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setColor( QColorGroup::Highlight, QColor( 103, 141, 178) );
    cg.setColor( QColorGroup::HighlightedText, white );
    cg.setColor( QColorGroup::Link, QColor( 0, 0, 238) );
    cg.setColor( QColorGroup::LinkVisited, QColor( 82, 24, 139) );
    pal.setDisabled( cg );
    Say->setPalette( pal );

    Say->setLinkUnderline (true);
    Say->setReadOnly(true);
    Say->setCursorPosition(0,0);
    layout117->insertWidget(1,Say );

    exitButtonPlaceHolder->hide();
    C6Button* exitButton = new C6Button(frame15,0,0,path+"chat_71.png",path+"chat_over_109.png");
    layout33->addWidget(exitButton);
    connect(exitButton,SIGNAL(clicked()),this,SLOT(close()));
    connect(Say,SIGNAL(execUrl(QString &)),this,SLOT(execUrlProc(QString &)));

    saywhatuwant();
}
C6About::~C6About()
{}

/*!
    \fn C6About::execUrlProc(QString )
 */
void C6About::execUrlProc(QString  & str)
{
    emit execUrl(str);
}

void C6About::saywhatuwant()
{
    QString txt;

    txt = "<caption>OpenC6</caption> ";
    txt += QString::fromUtf8("<text>è un client Open Source di Instant Messaging");
    txt +=" che consente l'utilizzo del protocollo <b>C6</b>.<br>";
    txt += QString::fromUtf8("È scritto in C++, sviluppato con KDevelop e librerie Qt.</text><p>");
    txt+="<caption>Versione corrente:</caption><br>";
    txt+="<text><b>"+QString(C6VERSION)+"</b> "+QString(EDITION)+"</text><p>";
    txt+="<caption>Homepage:</caption><br>";
    txt+= Say->processRichText("http://openc6.sourceforge.net");
    txt+="<p>";
    txt+="<caption>Sviluppatore principale:</caption><br>";
    txt+="<text><b>Giorgio Alfarano</b> aka Gi0rGeTt0</text><br>";
    txt+= Say->processRichText("openc6@hotmail.com") +"<p>";
    txt+="<caption>Grafica:</caption><br>";
    txt+="<text><b>Claudio Viola</b></caption><br>";
    txt+= Say->processRichText("claudioviola@gmail.com") + "<p>";
    txt+="<caption>Supporto e documentazione:</caption><br>";
    txt+="<text><b>BiGAlex</b></text><br>";
    txt+= Say->processRichText("b1galez@hotmail.com") + "<br>";
    txt+= Say->processRichText("http://openc6project.cjb.net") +"<p>";
    txt+="<caption>Problemi:</caption><br>";
    txt+="<text>Per bug, suggerimenti, malfunzionamenti:</text><br>";
    txt+= Say->processRichText("openc6@hotmail.com") + "<p>";

    txt+="<caption>Ringraziamenti:</caption><br>";
    txt+="<text><b>Mariana</b> che, con infinita pazienza, <br>dolcemente mi osserva mentre lavoro</text><br><br>";   
    txt+"<text>Tutta la crew @ <b>openc6project</b><br><br></text>";
    txt+="<text>Sun + Sparc bug fixing:<br>";
    txt+="<b>Antonello<b><br></text>";
    txt+= Say->processRichText("etn@libero.it") + "<br><br>";
    txt+="<text>Power PC bug fixing<br>";
    txt+="<b>Lorenzo<b><br></text>";
    txt+= Say->processRichText("lost666@virgilio.it") +"<br><br>";
    txt+="<text>Protocollo per scambio file:<br>";
    txt+="<b>Andrea</b> aka vega79<br></text>";
    txt+= Say->processRichText("andrea@slack.z00.it") + "<br><br>";
    Say->append(txt);
}

/*!
    \fn C6About::setCustomFont()
 */
void C6About::setCustomFont()
{
    C6Global &global=C6Global::getInstance();
    QFont lfont(global.getBaseFont());
    int tmp = lfont.pointSize()-1;
    if (tmp > 2)
    {
        lfont.setPointSize(tmp);
        setFont(lfont);
    }
}
