//
// C++ Interface: c6abstractplugin
//
// Description:
//
//
// Author: Giorgio A. <openc6@hotmail.com>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef C6ABSTRACTPLUGIN_H
#define C6ABSTRACTPLUGIN_H

#include <qobject.h>

class QApplication;

#ifdef __cplusplus
extern "C"
{
#endif

    /**
    @author Giorgio A.
    */

    class C6AbstractPlugin : public QObject
    {
            Q_OBJECT
    public:
        C6AbstractPlugin();

        virtual ~C6AbstractPlugin();
        virtual void initialize() = 0;
        virtual QApplication* createKApplication() = 0;    
        virtual QString getName() = 0;   
        virtual QString getDescription() = 0;          
        
        QApplication* getKdeEntryPoint() const 
        {
            return (_kdeEntryPoint);         
        }                
        
        void setKdeEntryPoint(QApplication* entryP) 
        {
            _kdeEntryPoint = entryP;         
        }          
        
        bool isForKde() const 
        {
            return(_isForKde);
        }                
        
        void setForKde()
        {
            _isForKde = true;
        }        
        
        void setDestroy()
        {
            _canDestroy = true;     
        }                
        
        bool canDestroy() const
        {
            return(_canDestroy);
        }                
        
        private:      
            QApplication *_kdeEntryPoint;    
            bool _isForKde;    
            bool _canDestroy;
    };

    class C6PlugInFactory
    {
    public:
        C6PlugInFactory();
        virtual ~C6PlugInFactory();

        virtual  C6AbstractPlugin* getPluginInstance() = 0;
        virtual  void destroyPlugin() = 0;      
    };

    extern "C" void* defaultFactoryFunction(void);

#ifdef __cplusplus
}
#endif
#endif
