/***************************************************************************
                          c6button.cpp  -  description
                             -------------------
    begin                : Sat May 17 2003
    copyright            : (C) 2003 by Giorgio A.
    email                : openc6@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "c6button.h"
#include <qpainter.h>
#include <qcolor.h>
#include <qwidget.h>
#include <qpixmap.h>
#include "c6pixmapcache.h"

C6Button::C6Button(QWidget *parent,int x,int y,QString const &off,QString const & on,
                   QString roll,int conversion_flag) : QButton(parent)
{
    _rollover = false;
    _normalState = const_cast<QPixmap*>(&C6PixmapCache::getInstance().getPixmap(off,conversion_flag));
    _pressedState = const_cast<QPixmap*>(&C6PixmapCache::getInstance().getPixmap(on,conversion_flag));
    setGeometry(QRect( x, y, _normalState->width(), _normalState->height()));
    QSize size(_normalState->width(),_normalState->height());
    setPixmap(*_normalState);
    setMinimumSize(size);
    setMaximumSize(size);
    setBackgroundOrigin(QWidget::ParentOrigin);

    connect(this,SIGNAL(pressed()),this,SLOT(setPressedState()));
    connect(this,SIGNAL(released()),this,SLOT(setNormalState()));

    if (roll != QString::null)
    {
        _rollover = true;
        _rollState = const_cast<QPixmap*>(&C6PixmapCache::getInstance().getPixmap(roll,conversion_flag));
    }
}

C6Button::~C6Button()
{}

void C6Button:: drawButton ( QPainter * p)
{
    int x = geometry().x()-frameGeometry().x();
    int y = geometry().y()-frameGeometry().y();

    p->drawPixmap(x,y,*pixmap());
}

void C6Button::setPressedState()
{
    setPixmap(*_pressedState);
}

void C6Button::setNormalState()
{
    setPixmap(*_normalState);
}

void C6Button::enterEvent(QEvent *event)
{
    if ((_rollover == true) && (isOn() == false))
    {
        setPixmap(*_rollState);
    }
}

void C6Button::leaveEvent (QEvent *event)
{
    if ((_rollover == true) && (isOn() == false))
    {
        setPixmap(*_normalState);
    }
}

void C6Button::setSticky(bool isSticky)
{
    setToggleButton(isSticky);
    setToggleType(Toggle);   
    disconnect(this,SLOT(setNormalState()));    
    disconnect(this,SLOT(setPressedState()));    
    connect(this,SIGNAL(toggled(bool)),this,SLOT(setToggledState(bool)));
}
      
void C6Button::setToggledState(bool isOn)
{
    if (isOn == true)
    {
        setPixmap(*_pressedState);      
    }
    else
    {
        setPixmap(*_normalState);      
    }            
}      
