/***************************************************************************
                          c6button.h  -  description
                             -------------------
    begin                : Sat May 17 2003
    copyright            : (C) 2003 by Giorgio A.
    email                : openc6@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef C6BUTTON_H
#define C6BUTTON_H

#include <qbutton.h>

class QWidget;
class QPainter;
class QPixmap;

/**extended pixmap button with rollover capability
  *@author Giorgio A.
  */

class C6Button : public QButton
  {
    Q_OBJECT
  public:
   
    C6Button(QWidget *parent,int x,int y,QString const &off,QString const & on,
             QString roll = QString::null,int conversion_flag = Qt::DiffuseDither);
    ~C6Button();

    void setSticky(bool isSticky = true);      
    
  private:

    QPixmap* _normalState;
    QPixmap* _pressedState;
    QPixmap* _rollState;
    bool _rollover;
    
    virtual void drawButton (QPainter *);
    virtual void enterEvent (QEvent *event);
    virtual void leaveEvent (QEvent *event);

  private slots: // Private slots
    void setPressedState();
    void setNormalState();
    void setToggledState(bool isOn);   
  };

#endif
