//
// C++ Implementation: c6chatfontdialog
//
// Description: 
//
//
// Author: Giorgio A. <openc6@hotmail.com>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "c6chatfontdialog.h"
#include <qfont.h>
#include <qlistbox.h>
#include <qlineedit.h>
#include <qtextedit.h>
#include <qdialog.h>
#include <qpushbutton.h>
#include <qstringlist.h>
#include "c6settings.h"

const int DEFAULT_FONT_SIZE = 10;
const int MIN_FONT_SIZE = 8;
const int MAX_FONT_SIZE = 32;     
const int MAX_FONT_NO = 10;

C6ChatFontDialog::C6ChatFontDialog(int &fontNo,int &fontSizePt)
 : Font(0,0)
 ,_pFontNo(&fontNo)
 ,_pFontSize(&fontSizePt)          
{
    const QStringList& fonts = C6Settings::getInstance().getVisualChatFontStyle();    
    fontList->insertStringList(fonts);
    
    for (int i = MIN_FONT_SIZE; i <= MAX_FONT_SIZE; i++)
    {
        fontSize->insertItem(QString::number(i));      
    }          
    
    if (fontNo == -1)
    {
        fontNo = 0;     
    }          
    
    fontList->setSelected(fontNo,TRUE);
    fontSize->setSelected(fontSizePt-8,TRUE);  
    selectedFont->setText(fonts[0]);
    selectedSize->setText(fontSize->text(0));          
    connect(fontList,SIGNAL(highlighted(int)),SLOT(fontSelectionChanged(int)));    
    connect(fontSize,SIGNAL(selectionChanged(QListBoxItem *)),SLOT(fontSizeSelectionChanged(QListBoxItem *)));    
   
    fontPreview->append("OpenC6");     
    setPreview(fontList->currentText(),fontSizePt);   
    connect(okButton,SIGNAL(clicked()),SLOT(okButtonPressed()));
    connect(cancelButton,SIGNAL(clicked()),SLOT(cancelButtonPressed()));
}


C6ChatFontDialog::~C6ChatFontDialog()
{
}


#include "c6chatfontdialog.moc"

/*!
    \fn C6ChatFontDialog::fontSelectionChanged(QListBoxItem *item)
 */
void C6ChatFontDialog::fontSelectionChanged(int selected)
{
    if (selected >= 0)
    {         
        const QStringList& fonts = C6Settings::getInstance().getVisualChatFontStyle();          
        selectedFont->setText(fonts[selected]);
        setPreview(fonts[selected],fontSize->selectedItem()->text().toInt());
    }      
}        


/*!
    \fn C6ChatFontDialog::fontSizeSelectionChanged(QListBoxItem *)
 */
void C6ChatFontDialog::fontSizeSelectionChanged(QListBoxItem *item)
{
    if (item != 0)
    {         
        selectedSize->setText(item->text());
        setPreview(selectedFont->text(),item->text().toInt());   
    }      
}


/*!
    \fn C6ChatFontDialog::setPreview(QFont const &font,int size)
 */
void C6ChatFontDialog::setPreview(QString const &font,int size)
{
    QFont tmp(font,size);
    
    fontPreview->setFont(tmp);        
}


/*!
    \fn C6ChatFontDialog::okButtonPressed()
 */
void C6ChatFontDialog::okButtonPressed()
{
    *_pFontNo = fontList->currentItem();
    *_pFontSize = fontSize->currentText().toInt();        
    done(QDialog::Accepted);
}


/*!
    \fn C6ChatFontDialog::cancelButtonPressed()
 */
void C6ChatFontDialog::cancelButtonPressed()
{
    done(QDialog::Rejected);
}
