//
// C++ Interface: c6chatroom
//
// Description:
//
//
// Author: Giorgio A. <openc6@hotmail.com>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef C6CHATROOM_H
#define C6CHATROOM_H

#include <chatroom.h>
#include <qstringlist.h>
#include "macroetc.h"

class C6GlobalConfig;
class QString;
class QWidget;
class QStringList;
class C6Button;
class QListBoxItem;
class QPoint;
class C6TextEdit;
class QPopupMenu;

/**
@author Giorgio A.
*/
class C6ChatRoom : public ChatRoom
  {
    Q_OBJECT
  public:
    C6ChatRoom();

    ~C6ChatRoom();
    const QString & getRoomName() const;
    void setRoomName(QString const & roomName,QString const & roomTopic);   
    void updateUserList(QMap<QString,int>& users);
    void serviceMessage(QString mess);
    void updateMyText(QString &nick,QString &text);
    void updateOtherText(QString &nick,QString &text);
    void updateTheList(QString const& name,bool isExitFromRoom);
    void updateColorFont();
    void takeFocus();
    void setCustomFont();
    void setKicked();
    void setMyNick(QString const &);
    void setRoomCaption(QString const & roomName,int roomAttribute);
    
  private:
    C6TextEdit *channel;
    QString _roomName;
    QString _myNick;
    QString _roomTopic;    
    QPopupMenu *userListMenu;
    QPopupMenu *userListMenuChild;
    int curIndex;
    void closeEvent (QCloseEvent * e);
    bool _isKicked;    

  signals:
    void sendToRoom(QString &channel,QString &str,int);
    void exitFromRoom(QString &);
    void menuUserAction(const QString & roomName,const QString & nick,USER_MENU_ACTIONS action);
    void execUrl(QString & url);
    void append2Log(QString & room_name,QString & text);
    void signalRoomLog(QString & name);
    void switchToRoom(QString & room);
    void inviteSelected(const QString &room,const QStringList &nick,const QString &message);   
    void showAbout();    
    
  private slots:
    void IsReturnPressed();
    void getLastCursorPos(int para,int index);
    void exitClicked();
    void showMenus(QListBoxItem *item,const QPoint & pos);
    void doubleClicked(QListBoxItem * item);
    void execUrlProc(QString & url);
    void emoticonsClicked();
    void sendText();
    void kickClicked();
    void showLog();
    void channelListClicked();
    void aboutClicked();
    void inviteNetfriend();
    void sendSelected(const QStringList &nick,const QString &message);
    
  };

#endif
