/***************************************************************************
                          c6conf.h  -  description
                             -------------------
    begin                : Tue Apr 15 2003
    copyright            : (C) 2003 by Giorgio A.
    email                : openc6@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef C6CONF_H
#define C6CONF_H

class C6GlobalConfig;
class QString;
class QWidget;
class C6Settings;
class QLineEdit;

#include <configure.h>
#include "macroetc.h"
#include "c6xcapclient.h"
#include "config.h"

/**
  *@author Giorgio A.
  */

class C6Conf : public configure
  {
    Q_OBJECT
  public:
    
    class FontInfo
      {
      public:
        int size;
        int weight;
        QString family;
      };

    C6Conf(QWidget *parent=0);
    ~C6Conf();

    FontInfo const & getFontInfo();
    
    void setConfigurationMode(C6XCAPClient::CONFIG_MODE mode);
    void setOfflineMode(C6XCAPClient::OFFLINE_MODE mode);       
    C6XCAPClient::CONFIG_MODE getConfigurationMode();
    C6XCAPClient::OFFLINE_MODE getOfflineMode();            
    
  private:
    void SelFontUp_clicked();
    void ForeColorUp_clicked();
    void Default_clicked();
    void beepSwitch_clicked();
    void fileOpen4_clicked();
    void fileOpen3_clicked();
    void fileOpen2_clicked();
    void fileOpen1_clicked();
    QString fileOpen();
    void soundSwitch_clicked();
    void removeSpecial_clicked();
    void playDemo5_clicked();
    void addSpecial_clicked();
    void fileOpen5_clicked();
    void playDemo2_clicked();
    void playDemo1_clicked();
    void playDemo4_clicked();
    void playDemo3_clicked();
    void contactSelFont_clicked();    
    void updateChatPreview(QString const & myself,QString const & netfriend);
    void fileDir_clicked();
    void postVariableSet();
    void Apply_clicked(); 
    void Ok_clicked();
    void closeEvent(QCloseEvent *e);
    void proxySwitch_toggled(bool status);
    void groupNameForeColor_clicked();
    void contactForeColor_clicked();   
    void globalFontButton_clicked();
    void selectFontButton_clicked();
    void updateFontText(QLineEdit *line,QString const &family,int weight,int size);
    void saveCurrentSettings();
    void loadSpecialList();
    void loadAutoRoomList();
    void loadPluginListAvailable();
    void savePluginList();
    void getLoadedPlugin();
    void saveAutoRoomList();
    void defaultFontButton_clicked();   
    void setStyleCombo(QString const &style);   
    void Cancel_clicked();
    void loadVisualFontStyle();
    void checkFontAvailability(QStringList const& list);
    
    FontInfo globalFont;
    FontInfo contactFont;   
    QString ForegndColor;
    QString ForeMessageColorUp;
    QString ForeNetFriendColorUp;
    QString FontStyle;
    int FontSize;
    int FontWeight;   
    QString contactGroupColor;
    QString contactUserColor;    
    
  private slots: // Private slots
    void saveSpecialList();
    void ForeMessageUp_clicked();
    void ForeNetFriendUp_clicked();
    void toggleMessageEdit(bool);
    void toggleAutoRoomList(bool enabled);   
    void insertPlugin();
    void contactFontToggled(bool);   
    void removePlugin();
    void defaultContactClicked();
    void mapFontSelectionClicked();
    void defaultListButtonClicked();
       
  signals: // Signals
    void playWav(QString snd);
    void apply(C6Conf& conf);
};

#endif
