//
// C++ Interface: c6contactlistitem
//
// Description:
//
//
// Author: Giorgio Alfarano <openc6@hotmail.com>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef C6CONTACTLISTITEM_H
#define C6CONTACTLISTITEM_H

#include <qlistview.h>
#include <qstring.h>
#include <qtooltip.h>
#include <qcolor.h>
class QPainter;


/**
    @author Giorgio Alfarano <openc6@hotmail.com>
*/

#define USER_COLOR_BACK QColor(230,244,240)

class C6ContactListItem : public QListViewItem
{
public :
    static const int DEFAULT_PHOTO_WIDTH = 32;
    C6ContactListItem(QListViewItem *root,QString const &nick, QString const& message);
    C6ContactListItem(QListView* parent,QListViewItem* root,bool isGroup);

    bool isGroup() const;
    const QString& getNick() const;

private:

    virtual int compare( QListViewItem *i, int col,bool ascending ) const;
    virtual void setup();
    virtual void paintCell(QPainter * p, const QColorGroup & cg,
                           int column, int width, int align);
    virtual void paintBranches(QPainter * p, const QColorGroup & cg, int w, int y, int h );
    virtual void paintFocus ( QPainter * p, const QColorGroup & cg, const QRect & r );

private :
    QListViewItem* _listViewItem;
    bool _isGroup;
    QString _nick;
    QString _message;
};

class C6ContactListTip : public QToolTip
{
public:
    C6ContactListTip(QListView* parent);

protected:
    virtual void maybeTip(const QPoint & pos);

private :
    QListView* _parent;
};

#endif