//
// C++ Interface: c6global
//
// Description:
//
//
// Author: Giorgio A. <openc6@hotmail.com>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef C6GLOBAL_H
#define C6GLOBAL_H

#include "c6singleton.h"
#include <qptrlist.h>
#include "c6users.h"
#include <qstringlist.h>
#include <qstring.h>
#include <qfont.h>
#include "c6abstractplugin.h"
#include "c6pluginmanager.h"
#include "c6usersmanager.h"
#include <qmap.h>

#define SKINPATH "/skin-gui/default/"
#define SHAREPATH "/share/OpenC6"
#define PLUGINPATH "/lib/"
#define SOUNDPATH "/sounds/default/"

/**
@author Giorgio A.
*/
class C6Global : public C6Singleton<C6Global>
{
public:
    friend class C6Singleton<C6Global>;
          
    C6Global();
    ~C6Global();

    const C6ListHash& getNetfriendList() const;
       
    const QStringList & getSpecialFriendList() const
    {
        return specialFriendList;
    }
    const QStringList & getAutoRoomList() const
    {
        return autoRoomList;
    }
   
    const QStringList & getProfile() const
    {
        return profilerc;
    }
        
    const QStringList & getPlugins() const
    {
        return _loadedPlugin;
    }        
    
    const QString getSkinPath() const
    {
        return commonPath+SHAREPATH+SKINPATH;
    }
    
    const QString getSharePath() const
    {
        return commonPath+SHAREPATH;
    }
    
    const QString getPluginPath() const
    {
        return commonPath+SHAREPATH+PLUGINPATH;
    }   
    
    const QString getDefaultSoundPath() const
    {
        return commonPath+SHAREPATH+SOUNDPATH;
    }      
    
    const bool getTabActivated() const
    {
        return _isTabActivated;
    }    
    
    const QFont getBaseFont() const 
    {
        return _baseFont;
    }         
    
    void setBaseFont(QFont const& font)
    {
        _baseFont = font;  
    }            
    
    const int getCaptionFontSize() const 
    {
        return _baseFont.pointSize();
    }           
    
    const QString & getCommonPath() const 
    {
        return commonPath;
    }    
    
    void *getRoomListPtr() const 
    { 
        return roomListPtr; 
    }  
     
    void setRoomListPtr(void *set) 
    { 
        roomListPtr = set; 
    }  
     
    
    void saveNetfriendList();
      
    void setCommonPath(QString const & path)
    {
        commonPath = path;
    }
    
    void setTabActivated(bool value) 
    {
        _isTabActivated = value;
    }       
    
    int getProfileEntryIndex(QStringList const & list,QString const & Entry);
    const QString& getC6Directory();
    bool isInSpecialList(QString const &nick);
    void initialize();
    C6AbstractPlugin* buildPlugin(QString const & pluginName,bool startKapp = true);        
    QApplication* initPlugin(C6AbstractPlugin* plugin);
    void loadPlugin(QString const & pluginName);   
    void unloadPlugin(const QString fname);         
    void loadPluginList();
    QApplication* getKappInstance();    
    QStringList getLoadedPlugin();
    C6AbstractPlugin* getPluginInstance(QString const & fname);
    QStringList getLoadedPluginName();            
    void addUser(QString const & group,QString const & nick);    
    void addUser(QString const & group,QString const & user,QString const & nick);        
    void removeUser(QString const & nick);   
    const QStringList getGroupUsers(QString const &group);   
    const QStringList getBlackListUsers();      
    void setAllUsersOffline();
    C6Users* getC6UserPtr(const QString &nick);
    QStringList getAllUsers();      
    bool groupIsPresent(QString const &group);       
    void addGroup(QString const &group);   
    bool removeGroup(QString const &group);   
    QStringList getAllGroups();
    const QString getUserGroupName(QString const &user);   
    bool isBlackListed(QString const & nick);
    bool renameGroup(const QString &oldname,const QString &newname);   
    void setBehaviourIfMacOSX(QWidget *widget);   
    void loadSpecialList();
    void calibrateSystemFontSize();        
    void setFirstBoot(bool set);
    const QStringList & getStyleList();
    void setWidgetStyle(QString const &style);
    C6Users::C6UsersList& getC6UsersFromGroup(QString const &group);   
    const QString getBlackListGroupName();
    void clearUsersList();
    bool loadNetfriendListFromFile();   
    bool isTheBlackList(QString const &group);        
    bool mergeLocalListToServerSide();
    void addToWhiteList(QString const &user,QString const &nick);
    void addToWhiteList(QString const &nick);   
    const QStringList getWhiteListUsers();
    void removeFromWhiteList(QString const & nick);
    bool isWhiteListed(QString const &nick);
    QString getWhiteListGroupName();
    void loadAutoRoomList();       
    void saveCurrentIdentity(QString const &loginId, QString const &pw,QString const &messageODD);    
    QString getCurrentIdentityPassword(QString const &loginId);
    QString getCurrentMessageODDay(QString const &loginId,QString const &nick);     
    void saveCurrentMessageODDay(QString const &loginId,QString const &message);
    bool localNetfriendListExists();
    bool isFirstAccountLoginAttempt(QString const &loginId);
    void setFirstAccountLoginAttempt(QString const &loginId);   
    
private:
    QStringList specialFriendList;
    QStringList autoRoomList;
    QStringList _loadedPlugin;      
    QStringList _styleList;
    QStringList _visualFontFamilyList;        
    QString _homeDirPath;
    QStringList profilerc;
    QString commonPath;
    QString c6dir;
    C6PluginManager* _pluginManager;   
    C6UsersManager* _usersManager;   
    C6ListHash *_netfriendList;   
    void *roomListPtr;
    bool _isTabActivated;
    QFont _baseFont;
    void globalInit();
    void loadProfileRC();
    void defineConstants();
    void createDirectories();
    void initStyleSheetItems();   
    void setInitWidgetStyle();
    void loadListFromStream(C6UsersManager &userlist,QTextStream * stream = 0);       
    bool loadNetfriendList(C6UsersManager &userlist);  
    QString loadAccountDetailsFromKey(QString const& id,QString const& key,QString const& value);   
    void saveAccountDetailsWithKey(QString const& id,QString const& section,QString const& key,QString const& value);   
   
};
#endif
