//
// C++ Implementation: c6httpconnection
//
// Description:
//
//
// Author: Giorgio A. <openc6@hotmail.com>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "c6httpconnection.h"
#include <qhttp.h>
#include <qurl.h>
#include <qbuffer.h>

C6HttpConnection::C6HttpConnection(QString const &urlstr,QObject *parent, const char *name)
        : QObject(parent, name)
        ,_url(new QUrl(urlstr))
{
    int port = 80;

    if (_url->port() != -1)
    {
        port = _url->port();
    }       
    
    _http = new QHttp(_url->host(),port,this);
    
    connect(_http,SIGNAL(done(bool)),this,SLOT(httpRequestDone(bool)));
    connect(_http,SIGNAL(stateChanged(int)),SLOT(httpStateChanged(int)));   
}

void C6HttpConnection::get()
{
    _http->get(_url->encodedPathAndQuery());   
}      

void C6HttpConnection::request(QString const & request)
{
    QHttpRequestHeader header(request); 
    _http->request(header);    
}    

void C6HttpConnection::request(QHttpRequestHeader const &request)
{
    _http->request(request);    
}  

void C6HttpConnection::request(QHttpRequestHeader const &request,const QByteArray & data)
{
    _http->request(request,data);    
}  

C6HttpConnection::~C6HttpConnection()
{
    delete _http;
    delete _url; 
}

void C6HttpConnection::httpRequestDone(bool error)
{
    if (error)
    {
        qWarning("Http error");
    }
    else
    {
        _buffer.assign(_http->readAll());
        emit bufferFull(_url->fileName(),this);
    }
}

void C6HttpConnection::httpStateChanged(int state)
{
    if (state == QHttp::Unconnected)
    {
        emit closed();      
    }         
}

      
#include "c6httpconnection.moc"
