//
// C++ Interface: c6httpconnection
//
// Description:
//
//
// Author: Giorgio A. <openc6@hotmail.com>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef C6HTTPCONNECTION_H
#define C6HTTPCONNECTION_H

#include <qobject.h>
#include <qcstring.h>
#include <qhttp.h>

class QUrl;

/**
@author Giorgio A.
*/
class C6HttpConnection : public QObject
{
    Q_OBJECT
public:
    C6HttpConnection(QString const &urlstr,QObject *parent = 0, const char *name = 0);
    ~C6HttpConnection();

    QByteArray getBuffer()
    {
        return _buffer;
    }
    void get();   
    void request(QString const &request);
    void request(QHttpRequestHeader const &request);   
    void request(QHttpRequestHeader const &request,const QByteArray & data);
    
private:
    QByteArray _buffer;            
    QHttp *_http;
    QUrl *_url;
    
private slots:
    void httpRequestDone(bool error);
    void httpStateChanged(int state);   
signals:
    void bufferFull(const QString& filename,C6HttpConnection* self);
    void closed();
};

#endif
