//
// C++ Implementation: c6invitedialog
//
// Description:
//
//
// Author: Giorgio A. <openc6@hotmail.com>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "c6invitedialog.h"
#include <qlistview.h>
#include <qheader.h>
#include <qfont.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qtextedit.h>
#include "c6global.h"
#include "c6button.h"
#include "c6users.h"
#include "c6about.h"
#include <qtooltip.h>

C6InviteDialog::C6InviteDialog(QWidget *parent)
        : Invite(parent)
{
    C6Global &global = C6Global::getInstance();
    QString path = global.getSkinPath();

    netfriendList->header()->hide();

    exitButtonPlaceHolder->hide();
    C6Button *exitButton = new C6Button(frame15,0,0,path+"chat_71.png",path+"chat_over_109.png");
    layout33->addWidget(exitButton);
    connect(exitButton,SIGNAL(clicked()),this,SLOT(closeInvite()));


    sendButtonPlaceHolder->hide();
    C6Button *sendButton = new C6Button(this,0,0,path+"invite_invia.png",path+"invite_invia_over.png");
    layout9->insertWidget(1,sendButton);
    connect(sendButton,SIGNAL(clicked()),this,SLOT(sendInvite()));

    QWidget *upParent = reinterpret_cast<QWidget*>(aboutButtonPlaceHolder->parent());
    C6Button* aboutButton = new C6Button(upParent,0,0,path+"chat_68.png",
                                         path+"chat_over_68.png",
                                         path+"chat_over_68.png");
    QToolTip::add
        (aboutButton,"Informazioni su OpenC6");
    aboutButtonPlaceHolder->hide();
    layout34->addWidget(aboutButton);
    connect(aboutButton,SIGNAL(clicked()),this,SLOT(aboutClicked()));

    global.setBehaviourIfMacOSX(messageEdit);
    fillUserList();
    setCustomFont();   
}


C6InviteDialog::~C6InviteDialog()
{}

/*!
    \fn C6InviteDialog::setCustomFont()
 */
void C6InviteDialog::setCustomFont()
{
    C6Global &global=C6Global::getInstance();
    QFont lfont(global.getBaseFont());

    int tmp = lfont.pointSize()-1;

    if (tmp > 2)
    {
        lfont.setPointSize(tmp);
        lfont.setBold(true);
        identityCaption->setFont(lfont);
        netfriendCaption->setFont(lfont);
        lfont.setBold(false);
        setFont(lfont);
    }
}


#include "c6invitedialog.moc"


/*!
    \fn C6InviteDialog::closeInvite()
 */
void C6InviteDialog::closeInvite()
{
    done(-1);
}


/*!
    \fn C6InviteDialog::sendInvite()
 */
void C6InviteDialog::sendInvite()
{
    QStringList nickToSend;
    QListViewItemIterator it(netfriendList);
    QCheckListItem *tmp = 0;

    for ( ; it.current(); ++it )
    {
        tmp = static_cast<QCheckListItem*>(*it);
        if (tmp->isOn() == true)
        {
            nickToSend.append(tmp->text());
        }
    }

    if (nickToSend.count() > 0)
    {
        QString message = messageEdit->text().stripWhiteSpace();
        emit sendSelected(nickToSend,message);
    }
    done(0);
}


/*!
    \fn C6InviteDialog::fillUserList()
 */
void C6InviteDialog::fillUserList()
{
    C6Global &global = C6Global::getInstance();
    QStringList groups = global.getAllGroups();
    QStringList blackListed = global.getBlackListUsers();
    bool found = false;
       
    for (unsigned int i=0; i < groups.count(); i++)
    {
        C6Users::C6UsersList &list = global.getC6UsersFromGroup(groups[i]);

        for (C6Users *tmp = list.first(); tmp; tmp = list.next())
        {
            if (tmp->isOnline() == true)
            {
                found = false;
                for (unsigned int j=0; j < blackListed.count(); j++)
                {
                    if(tmp->getNick().compare(blackListed[j]) == 0)
                    {
                        found = true;
                        break;
                    }
                }
                if (found == false)
                {
                    (void*) new QCheckListItem(netfriendList,tmp->getNick(),QCheckListItem::CheckBox);
                }
            }
        }
    }
}

void C6InviteDialog::aboutClicked()
{
    C6About aboutDialog(this);
    aboutDialog.exec();    
}

