/***************************************************************************
                          c6login.cpp  -  description
                             -------------------
    begin                : Fri Oct 10 2003
    copyright            : (C) 2003 by Giorgio A.
    email                : openc6hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "c6login.h"
#include "c6pixmapcache.h"
#include "c6settings.h"
#include "c6global.h"
#include <qlineedit.h>
#include <qcombobox.h>
#include <qwidget.h>
#include "c6button.h"
#include <qlayout.h>
#include <qlabel.h>
#include <qapplication.h>
#include <qfont.h>
#include <qtooltip.h>
#include <qtextstream.h>
#include <qcstring.h>
#include <qprocess.h>
#include "c6httpconnection.h"

static C6HttpConnection *httpData = 0;

C6Login::C6Login(QWidget *parent, const char *name) : Login_Dlg(parent,name)
        ,_registerButton(0)      
{
    getRegisterLink();    
    
    C6Global &global = C6Global::getInstance();
    QString path = global.getSkinPath();
    C6PixmapCache &pixmap = C6PixmapCache::getInstance();

    setIcon(pixmap.getPixmap(path+"icon16x16.png"));

    C6Button* connectButton = new C6Button(loginFrame,207,95,path+"accedi.png",
                                           path+"accedi_over.png");
    QToolTip::add
        (connectButton,"Avvia la connessione");

    _registerButton = new C6Button(loginFrame,26,165,
                                            path+"registrati.png",
                                            path+"registrati_over.png");
    connect(_registerButton,SIGNAL(clicked()),this,SLOT(gotoUrl()));   
    QToolTip::add
            (_registerButton,"Crea un account per la rete c6: attendere prego...");

    loginFrame->setBackgroundPixmap(pixmap.getPixmap(path+"login_12.png"));

    QWidget *upParent = reinterpret_cast<QWidget*>(configButtonPlaceHolder->parent());
    C6Button* configButton = new C6Button(upParent,0,0,path+"login_06.png",
                                          path+"login_over_06.png",
                                          path+"login_over_06.png");
    QToolTip::add
        (configButton,"Configurazione di OpenC6");
    configButtonPlaceHolder->hide();
    layout8->insertWidget(0, reinterpret_cast<QWidget*>(configButton));

    upParent = reinterpret_cast<QWidget*>(exitButtonPlaceHolder->parent());
    C6Button* exitButton = new C6Button(upParent,0,0,path+"login_21.png",
                                        path+"login_over_26.png");
    QToolTip::add
        (exitButton,"Esci da Openc6");
    exitButtonPlaceHolder->hide();
    layout4->insertWidget(1,exitButton);

    upParent = reinterpret_cast<QWidget*>(aboutButtonPlaceHolder->parent());
    C6Button* aboutButton = new C6Button(upParent,0,0,path+"login_19.png",
                                         path+"login_over_24.png",
                                         path+"login_over_24.png");
    QToolTip::add
        (aboutButton,"Informazioni su OpenC6");
    aboutButtonPlaceHolder->hide();
    layout6->insertWidget(0,aboutButton);

    connect(connectButton,SIGNAL(clicked()),SLOT(connectClicked()));
    connect(exitButton,SIGNAL(clicked()),SLOT(exitClose()));
    connect(configButton,SIGNAL(clicked()),SLOT(configClicked()));
    connect(aboutButton,SIGNAL(clicked()),SLOT(aboutClicked()));

    move((QApplication::desktop()->width()-width())/2,
         (QApplication::desktop()->height() - height())/2);
}

C6Login::~C6Login()
{
    delete httpData;
}

void C6Login::closeEvent(QCloseEvent *e)
{
    e->accept();
    emit forceClose();
}

void C6Login::connectClicked()
{
    bool found = false;
    bool ret = (Password->displayText().stripWhiteSpace() != "") &&
               (nickName->currentText().stripWhiteSpace() != "");
    int c = nickName->count();

    while (c && !found)
    {
        if (nickName->text(c-1) == nickName->currentText())
            found = true;

        c--;
    }

    if (!found)
    {
        nickName->insertItem(nickName->currentText());
        nickName->setCurrentItem(nickName->count()-1);
    }

    emit startConnect(ret);
}


/*!
    \fn C6Login::getLoginNick()
 */
QString C6Login::getLogin() const
{
    return(nickName->currentText());
}


/*!
    \fn C6Login::getLoginPassw()
 */
QString C6Login::getPassword() const
{
    return(Password->text());
}

void C6Login::exitClose()
{
    emit exitClicked();
}

void C6Login::configClicked()
{
    emit openConfig();
}

void C6Login::aboutClicked()
{
    emit showAbout();
}


/*!
    \fn C6Login::setCustomFont()
 */
void C6Login::setCustomFont()
{
    C6Global &global=C6Global::getInstance();
    QFont lfont(global.getBaseFont());
    int tmp = lfont.pointSize()-1;
    if (tmp > 2)
    {
        lfont.setPointSize(tmp);
        userLabel->setFont(lfont);
        passwordLabel->setFont(lfont);
        savePasswordLabel->setFont(lfont);
        nickName->setFont(lfont);
        Password->setFont(lfont);
    }
}

void C6Login::getRegisterLink()
{
    _registerUrl = C6Settings::getInstance().getUrlList();    
    httpData = new C6HttpConnection(_registerUrl);
    httpData->get();
    connect(httpData,SIGNAL(bufferFull(const QString&,C6HttpConnection*)),this,SLOT(urlListDone(const QString&,C6HttpConnection*)));
    connect(httpData,SIGNAL(closed()),this,SLOT(httpClosed()));
}

void C6Login::urlListDone(const QString& filename,C6HttpConnection*)
{
    QByteArray data = httpData->getBuffer();
    QTextStream ts(data,IO_ReadOnly );
    QString line;
    
    while (!ts.atEnd())
    {
        line = ts.readLine();

        if (line.contains("BUTTON_URL_104") == true)
        {
            int index =  line.find("http:");
            if (index != -1)
            {
                _registerUrl = line.mid(index,line.length());
                
                QToolTip::remove(_registerButton);    
                QToolTip::add
                        (_registerButton,"Crea un account per la rete c6");    
            }
            break;
        }
    }   
}

void C6Login::httpClosed()
{
}

void C6Login::gotoUrl()
{
    if( _registerUrl.length() > 0)
    {
        QProcess *exe = new QProcess(this);
        if (exe != 0)
        {
            exe->addArgument(C6Settings::getInstance().getBrowser());
            exe->addArgument(_registerUrl);
            exe->start();
            delete exe;
        }
    }
}
      