/***************************************************************************
                          c6login.h  -  description
                             -------------------
    begin                : Fri Oct 10 2003
    copyright            : (C) 2003 by Giorgio A.
    email                : openc6hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef C6LOGIN_H
#define C6LOGIN_H

class QWidget;
class C6Button;
class C6HttpConnection;

#include <login_dlg.h>
#include <qstring.h>

/**
  *@author Giorgio A.
  */

class C6Login : public Login_Dlg
{
    Q_OBJECT
public:
    C6Login(QWidget *parent=0, const char *name=0);
    ~C6Login();
    QString getLogin() const;
    QString getPassword() const;
    void setCustomFont();

signals: // Signals
    void showAbout();
    void forceClose();
    void startConnect(bool);
    void exitClicked();
    void openConfig();
private:
    QString  _registerUrl;
    C6Button*  _registerButton;
    void closeEvent(QCloseEvent *e);
    void getRegisterLink();

private slots: // Private slots
    void connectClicked();
    void exitClose();
    void configClicked();
    void aboutClicked();
    void urlListDone(const QString& filename,C6HttpConnection*);
    void httpClosed();
    void gotoUrl();
};

#endif
