/***************************************************************************
                          c6logview.cpp  -  description
                             -------------------
    begin                : Tue May 27 2003
    copyright            : (C) 2003 by Giorgio A.
    email                : openc6@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "c6logview.h"
#include "c6settings.h"
#include <qlistbox.h>
#include <qtextstream.h>
#include <qfile.h>
#include <qtextedit.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qlayout.h>
#include "c6button.h"
#include "c6global.h"
#include "c6textedit.h"
#include <qtooltip.h>

#define ROOMLOGSTR QString("Log della stanza ")
#define USERLOGSTR QString("Log della conversazione con ")
#define DATELOGSTR QString("Log del ")
#define SYSTEMLOGSTR QString("Log di sistema del ")

C6LogView::C6LogView(QWidget *parent, QString path) : logview(parent)
{
    C6Global &global = C6Global::getInstance();
    QString locPath = global.getSkinPath();

    _curPath = path;

    exitButtonPlaceHolder->hide();
    C6Button* exitButton = new C6Button(frame15,0,0,
                                        locPath+"chat_71.png",
                                        locPath+"chat_over_109.png");
    layout33_2->addWidget(exitButton);
    connect(exitButton,SIGNAL(clicked()),this,SLOT(closeLog()));

    findButtonPlaceHolder->hide();
    QWidget *upParent = reinterpret_cast<QWidget*>(findButtonPlaceHolder->parent());   
    C6Button* findButton = new C6Button(upParent,0,0,locPath+"log_search_08.png",
                                        locPath+"log_search_over_08.png");
    layout34->insertWidget(3,findButton);
    connect(findButton,SIGNAL(clicked()),this,SLOT(searchButton_clicked()));
    connect(FileList,SIGNAL(selectionChanged(QListBoxItem*)),this,
            SLOT(mouse_clicked(QListBoxItem*)));
  
    C6Button* aboutButton = new C6Button(frame15,0,0,locPath+"chat_68.png",
                                         locPath+"chat_over_68.png",
                                         locPath+"chat_over_68.png");
    QToolTip::add
            (aboutButton,"Informazioni su OpenC6");
   
    aboutButtonPlaceHolder->hide();   
    frame15Layout->addWidget(aboutButton,0,2);      
    connect(aboutButton,SIGNAL(clicked()),this,SLOT(aboutClicked()));   
    
    dateLog->setText("");    
    global.setBehaviourIfMacOSX(FileList);
    global.setBehaviourIfMacOSX(_logView);
    setCustomFont();    
}

C6LogView::~C6LogView()
{}
/** show log files available */
void C6LogView::showFiles()
{
    dir.setPath(_logPath);
    dir.setFilter(QDir::Files);

    FileList->insertStringList(dir.entryList());
    FileList->setCurrentItem(FileList->topItem());
    mouse_clicked(FileList->firstItem());
}

/** No descriptions */
void C6LogView::mouse_clicked(QListBoxItem *item)
{
    if (item != 0)
    {
        switch(kind)
        {
        case USERLOG:
        case SINGLEUSERLOG:
            setCaption(USERLOGSTR+item->text().section("-",-1,-1));
            dateLog->setText(DATELOGSTR+item->text().section("-",0,2));    
            break;
        case ROOMLOG:
        case SINGLEROOMLOG:
            setCaption(ROOMLOGSTR+item->text().section("-",-1,-1));
            dateLog->setText(DATELOGSTR+item->text().section("-",0,2));    
            break;
        default:
            setCaption(SYSTEMLOGSTR+item->text().section("-",-3,-1).section(".",0,0));
            dateLog->setText(DATELOGSTR+item->text().section("-",1,3));    
        }

        QFile file(_logPath+"/"+item->text());    

        if ( file.open( IO_ReadOnly ))
        {
            fstream = new QTextStream(&file);
            _logView->setText(fstream->read());
            file.close();
            delete fstream;
        }
    }
}

void C6LogView::show(int choice,QString const & nick)
{
    QString dirstr ="";
    QString filter ="*";
    QString nick_post = nick;

    nick_post.replace(QChar(' '),QChar('*'));
    kind = choice;

    dir.setNameFilter("*");

    switch(kind)
    {
    case USERLOG:
        dirstr = "/Log";
        filter ="*";
        break;
    case SINGLEUSERLOG:
        dirstr = "/Log";
        filter = "*"+nick_post+"*";
        setCaption(USERLOGSTR+nick);
        break;
    case ROOMLOG:
        dirstr = "/RoomLog";
        filter ="*";
        break;
    case SINGLEROOMLOG:
        dirstr = "/RoomLog";
        filter = "*"+nick_post+"*";
        setCaption(ROOMLOGSTR+nick);
        break;
    default:
        dirstr="/SysLog";
        filter ="*";
    }

    dir.setNameFilter(filter);
    _logPath = _curPath+dirstr;

    showFiles();
    logview::show();
}

void C6LogView::searchButton_clicked()
{
    int index=1,para=1;

    _logView->getCursorPosition(&para,&index);

    if (_logView->find(searchEdit->displayText().stripWhiteSpace(),false,false,true,&para,&index))
    {
        _logView->setCursorPosition(para,index+1);
    }
    else
    {
        para = 0;
        index = 0;
        
        if(_logView->find(searchEdit->displayText().stripWhiteSpace(),false,false,true,&para,&index))
        {         
            _logView->setCursorPosition(para,index+1);
        }         
    }
}


void C6LogView::closeLog()
{
    deleteLater();
}

void C6LogView::closeEvent(QCloseEvent *e)
{
    deleteLater();
}


/*!
    \fn C6LogView::setCustomFont()
 */
void C6LogView::setCustomFont()
{
    C6Global &global=C6Global::getInstance();     
    QFont lfont(global.getBaseFont());
    int size = lfont.pointSize()-1;

    if (size > 2)
    {
        lfont.setPointSize(size-1);
        lfont.setBold(true);    
        roomName->setFont(lfont);
        dateLog->setFont(lfont);
    }
}

void C6LogView::aboutClicked()
{
    emit showAbout();
}
    
