/***************************************************************************
                          c6logview.h  -  description
                             -------------------
    begin                : Tue May 27 2003
    copyright            : (C) 2003 by Giorgio A.
    email                : openc6@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef C6LOGVIEW_H
#define C6LOGVIEW_H


class QCloseEvent;
class C6Button;
class QTextStream;

#include <qwidget.h>
#include <logview.h>
#include <qdir.h>
#include <qstring.h>


/**
  *@author Giorgio A.
  */

class C6LogView : public logview
{
    Q_OBJECT
public:
    C6LogView(QWidget *parent, QString path);
    ~C6LogView();
    /** No descriptions */
    void show(int choice,QString const & nick = QString::null);

private: // Private methods
    /** show log files available */
    void showFiles();
    void closeEvent(QCloseEvent *e);
    void setCustomFont();

private:
    int kind;
    QString _logPath;
    QString _curPath;
    QDir dir;
    QTextStream *fstream;

private slots: // Private slots
    void mouse_clicked(QListBoxItem *);
    void searchButton_clicked();
    void closeLog();
    void aboutClicked();
signals:
    void showAbout();
};

#endif
