//
// C++ Implementation: c6nicklist
//
// Description:
//
//
// Author: Giorgio A. <openc6@hotmail.com>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "c6nicklist.h"
#include "c6settings.h"
#include <qiconview.h>
#include <qlayout.h>
#include <qlabel.h>
#include "c6button.h"
#include "c6global.h"
#include "c6pixmapcache.h"
#include "qtimer.h"

#define LAST_IDENTITY_STR "Identità corrente: "

C6NickList::C6NickList(QWidget *parent, const char *name) : nickForm(parent,name),
        _isClicked(false),
        _timer(0)
{
    C6Global &global = C6Global::getInstance();
    C6Settings &settings = C6Settings::getInstance();
    QString path = global.getSkinPath();

    _timeOut = settings.getLoginTimeout();

    identityCaption->setText(QString::fromUtf8("OpenC6 - Identità disponibili"));
    setCaption(QString::fromUtf8("Scegli la tua identità"));
    nickList->setSelectionMode(QIconView::Single);
    nickList->setSorting(FALSE);

    enterButtonPlaceHolder->hide();
    C6Button *goButton = new
                         C6Button(frame44,0,0,path+"choose.png",path+"choose_over.png");
    layout86->addWidget(goButton);

    connect(goButton,SIGNAL(clicked()),this,SLOT(go()));
    timeOutLabel->setText(QString::number(_timeOut)+" s");
    lastIdentity->setText(QString::fromUtf8(LAST_IDENTITY_STR));

    connect(nickList,SIGNAL(clicked(QIconViewItem*)),
            this,SLOT(itemPointed(QIconViewItem *)));
    connect(nickList,SIGNAL(pressed(QIconViewItem*)),
            this,SLOT(itemPointed(QIconViewItem *)));
    connect(nickList,SIGNAL(doubleClicked(QIconViewItem*)),
            this,SLOT(itemPointed(QIconViewItem *)));
    setCustomFont();   
}



C6NickList::~C6NickList()
{}


/*!
    \fn C6NickList::addNick(QString nick)
 */
void C6NickList::addNick(QString const & nick)
{
    C6PixmapCache &pix = C6PixmapCache::getInstance();
    C6Global &global = C6Global::getInstance();
    QString path = global.getSkinPath();

    (void)new QIconViewItem(nickList,nick,pix.getPixmap(path+"identita_penguin.png"));
}


/*!
    \fn C6NickList::go()
 */
void C6NickList::go()
{
    _isClicked = true;
    done(nickList->index(nickList->currentItem()));
    deleteLater();
}

void C6NickList::closeEvent ( QCloseEvent * e )
{
    _timer->stop();

    if (!_isClicked)
    {
        setResult(NORESULT);
    }

    e->accept();
    deleteLater();
}


/*!
    \fn C6NickList::setDefaultIdentity(int i)
 */
void C6NickList::setDefaultIdentity(int i)
{
    QIconViewItem *item = nickList->firstItem();

    for (i; i; i--)
    {
        item = item->nextItem();
    }

    if (item)
    {
        lastIdentity->setText(QString::fromUtf8(LAST_IDENTITY_STR)+item->text());
        nickList->setCurrentItem(item);
        nickList->ensureItemVisible(item);
    }
}

void C6NickList::show()
{
    _timer = new QTimer(this);
    Q_CHECK_PTR(_timer);

    connect(_timer, SIGNAL(timeout()), this,SLOT(timerDone()));
    _timer->start(1000);
    nickForm::show();
    nickList->ensureItemVisible(nickList->currentItem());
}


/*!
    \fn C6NickList::timeout()
 */
void C6NickList::timerDone()
{
    if (_timeOut)
    {
        _timeOut--;
    }
    else
    {
        _timer->stop();
        go();
    }

    timeOutLabel->setText(QString::number(_timeOut)+" s");
}


/*!
    \fn C6NickList::itemPointed(QIconViewItem* item)
 */
void C6NickList::itemPointed(QIconViewItem* item)
{
    if (item !=0)
    {
        lastIdentity->setText(QString::fromUtf8(LAST_IDENTITY_STR)+item->text());
        _timer->stop();
    }
}

/*!
    \fn C6NickList::setCustomFont()
 */
void C6NickList::setCustomFont()
{
    C6Global &global = C6Global::getInstance();
    QFont lfont(global.getBaseFont());   
    int size = lfont.pointSize()-1;

    if (size > 2)
    {
        lfont.setPointSize(size);
        setFont(lfont);
    }
}
