//
// C++ Interface: c6photoretriever
//
// Description:
//
//
// Author: Giorgio Alfarano <openc6@hotmail.com>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef C6PHOTORETRIEVER_H
#define C6PHOTORETRIEVER_H

#include <qobject.h>
#include <qthread.h>
#include <qevent.h>
#include <qstringlist.h>
#include <qcstring.h>

class C6HttpConnection;

/**
    @author Giorgio Alfarano <openc6@hotmail.com>
*/


class PhotoListEvent : public QEvent
{
public:
    PhotoListEvent(QStringList const& photoList);
    ~PhotoListEvent();
    const QStringList& getPhotoList() const;
private:
    QStringList* _photoList;
};

class C6PhotoRetriever : public QObject
{
 Q_OBJECT   
public:
    C6PhotoRetriever();

protected :
    virtual bool event (QEvent *e);
private:
    void requestPictureFromWeb(QString const& nick);
private slots:
    void requestPictureDone(const QString& filename,C6HttpConnection* httpConnection);
    void requestPictureClose();   
signals:
    void photoReady(QByteArray& data,const QString& filename);  
private:
};

#endif