//
// C++ Implementation: c6pixmapcache
//
// Description:
//
//
// Author: Giorgio A. <openc6@hotmail.com>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "c6pixmapcache.h"
#include <qstring.h>

C6PixmapCache::C6PixmapCache()
{
}

C6PixmapCache::~C6PixmapCache()
{
    for (CachePixmapMap::Iterator i = _cacheList.begin() ; i != _cacheList.end(); i++)
    {
        delete(i.data());
    }
}

QPixmap const & C6PixmapCache::getPixmap(QString const& filename,int conversion_flag)
{
    CachePixmapMap::Iterator i = _cacheList.find(filename);
    QPixmap* pix = 0; 
            
    if (i == _cacheList.end())    
    {
       pix = new QPixmap(filename,0,conversion_flag);

        if (pix->isNull() == true)
        {
            pix->resize(1,1);
            qWarning("fake image created because missing file: %s\n",filename.latin1());
        }

        _cacheList[filename] = pix;
    }
    else
    {
        pix = i.data();      
    }   

    return(*pix);
}
