//
// C++ Interface: c6pluginmanager
//
// Description: 
//
//
// Author: Giorgio A. <openc6@hotmail.com>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef C6PLUGINMANAGER_H
#define C6PLUGINMANAGER_H

#include <qmap.h>
#include <qstring.h>
#include "c6abstractplugin.h"

class QLibrary;

/**
@author Giorgio A.
*/
class SOManager
{
    public:
        SOManager();
        virtual ~SOManager();

        void addLibrary(QString const &fname);
        void removeLibrary(QString const &fname);      
        QLibrary* getHandle(QString const &fname);
        bool getLibrarySymbol(void**,QString const &,QString const &symbolName);    
        
    private:
        
        typedef QMap<QString,QLibrary*> HandleMap;        
        bool getSymbol(QLibrary* library,void **,const char *symbolName);
              
        HandleMap _soHandle;
};

class SOFactory 
{
    public:
        SOFactory();
        virtual ~SOFactory();
        
        typedef void * (*FactoryFunctionType)(void);
        typedef QMap<QString,FactoryFunctionType> FactoryFunction;
              
        void addLibrary(QString const &fname);    
        void removeLibrary(QString const &fname);      
        void* getFactory(QString const &fname);
        bool exists(QString const &fname);
        QStringList getFactoryName();      
    private:
        bool getLibrarySymbol(void** out,QString const &fname,const char *symbol = 0); 
        SOManager* _soManager;
        FactoryFunction _factoryFunction;      
};

class C6PluginManager 
{
    public:
        C6PluginManager(); 
        ~C6PluginManager();
      
        C6PlugInFactory* getFactory(QString const &fname);
        void destroy(QString const &fname);      
        QStringList getFactoryName();                
    private:
        SOFactory* _soFactory;    
};


#endif
