/***************************************************************************
                          c6proto.h  -  description
                             -------------------
    begin                : Wed Feb 19 2003
    copyright            : (C) 2003 by Giorgio A.
    email                : openc6@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef C6PROTO_H
#define C6PROTO_H

#include <qsocket.h>
#include <qserversocket.h>
#include <qmap.h>
#include "macroetc.h"
#include "c6xcapclient.h"
#include "c6users.h"

class QObject;
class C6HttpConnection;
class QTextStream;
class C6ProxySocket;
class QStringList;

#define BYTE_WRITE(ptr,value) do { *ptr = (value); ptr++;} while(0)
#define WORD_WRITE(ptr,value) do { *ptr = (unsigned char)((value & 0xff00) >> 8); ptr++; \
*ptr = (unsigned char)(value & 0x00ff) ; ptr++; } while (0)
#define STR_WRITE(ptr,ptr_str,len) do { memcpy((void*)(ptr),(void*)(ptr_str),(len)); (ptr)+=(len);} while(0)

/**
  *@author Giorgio A.
  */

// TODO
/*
class AggregateType 
{
    public:
        AggregateType(const unsigned char* data);
        int getFields();
};
*/

class C6XferProto : public QObject
{
    static const int DEFAULT_FILE_TRANSFER_PACK_LEN = 4096;
        
    Q_OBJECT
private:
    QHostAddress ip;
    int port;
    QString file;
    QString nick;
    long long OutCount;
    long long _chunckNumber;
    long long _averageLength;
    long int fsize;
    QCString DataIn;
    QCString inComing;
    QSocket* _pSocket;    
    int _totalLength;
    int _packetLength;
    bool _fragmentedPacket;
    bool _transmitMode;    
    
public:

    enum CLIENT_XFER_ID
    {
        XFER_PUSH = 0x3001,
        XFER_CHUNK = 0x3002,
        XFER_CLIENT_ACK = 0x3003,
        XFER_END = 0x3004,
        XFER_STOP = 0x3006            
    };

    C6XferProto(QHostAddress l_ip,int l_port,QString l_file,QString l_nick);
    C6XferProto(int socket);
    C6XferProto(QString const& ip,int l_port,QString const &user);   
    ~C6XferProto();
    void fire();
    void sendAck();
    void close();
    void reset(); 
    void sendEndOfTransfer();
               
private:
    void Select(unsigned char *com,int avail,int packL);
    void sendNextChunk();
    void abortXfer();
    void receivePushData(unsigned char *data);
    void getNextChunk(unsigned char *data);
    void endOfReceive();
    void wordRead(unsigned char* ptr,int *value);
    void byteRead(unsigned char* ptr,unsigned char *value);
    void byteRead(unsigned char* ptr,int *value);   
    
private slots:
    void socket_Connected();
    void socket_ReadyRead();
    void socket_Error(int);
    void socket_connectionClosed();     
    void proxyError(int);
    void proxyConnected();  
    void proxyConnected(const QString &ip,int port);
    
signals:
    void xferAborted();
    void xferProgress(int);
    void receiveProgress(int);
    void xferError(int);
    void xferClosed();
    void signalFileSpec(QString &,long int);
    void signalGateway(const QString &ip,int port);    
};

class C6XferServer : public QServerSocket
{
    Q_OBJECT
public:

    enum SERVER_XFER_ID
    {
        XFERID = 0x30,
        XFER_ACK = 0x03,
        XFER_RECEIVE_END = 0x04,
        XFER_BAD = 0x05,
        XFER_STOP = 0x06,
        XFER_RECEIVE = 0x01,
        XFER_CHUNK_RECEIVE = 0x02
    };

    C6XferServer(int port);
    ~C6XferServer();
    
    void stopReceive();
    void reset();   
   
private:
    C6XferProto *listenSocket;
    
    void newConnection(int socket);    
private slots:
    void receiveProgressSlot(int);
    void receiveFileSpec(QString &,long int);
    void xferAborted();
signals:
    void receiveProgress(int);
    void signalFileSpec(QString&,long int);
    void receiveAborted();
};

class C6Proto : public QObject
{
    Q_OBJECT
public:

    enum SERVER_COMMAND_ID       // no need to be public 
    {
        SERVERID = 0x20,
        INFOLOGIN = 0x01,
        REROUTE = 0x02,
        LOGIN_ERRPASS = 0x03,
        LOGIN_USERCONN = 0x04,
        CLIENT_EXIT_OK = 0x05,
        SND_USERS = 0x06,
        SEARCH_RESULT_EMAIL = 0x07,
        STATUS = 0x0A,
        LOGIN_NOUSER = 0x0E,
        IN_MESSAGE = 0x0f,
        WELCOME = 0x10,
        PING =  0x11,
        HELO = 0x12,
        PROFILE_REPLY = 0x14,
        SEARCH_RESULT_PROFILE = 0x16,
        SEND_REPLY = 0x17,
        IN_CRYP_MESSAGE = 0x18,
        SERVER_OFFLINE_MESSAGE = 0x1a,   
        CHANGE_STATUS = 0x1c,
        MSG_FROMROOM = 0x30,
        ROOM_NOTPRESENT = 0x31,
        ROOM_NICKLIST = 0x32,
        ENTER_ROOM = 0x33,
        EXIT_FROMROOM = 0x34,
        EXIT_ROOM_OK = 0x35,
        SEARCH_RESULTS = 0x36,
        GET_ROOM_PROFILE = 0x37,
        ROOM_FULL = 0x38,
        ROOM_CREATE_BUSY = 0x39,
        SERVER_FIND_BY_NICK = 0x3a,   
        ROOM_ERROR = 0x3b,
        ROOM_LIST = 0x3c,
        PRE_LOGON = 0x45,
        SERVER_ROOM_ENTERED = 0x46,
        SERVER_ROOMS_FOUND = 0x47,                 
        SERVER_KICK_ACK = 0x49,            
        SERVER_KICK_BAN_ERROR = 0x4a            
    };
   
    enum AGGREGATE_TYPES
    {            
        AGGREGATE_INT = 2,
        AGGREGATE_STRING = 5,
        AGGREGATE_BYTE = 1,
        AGGREGATE_SHORT = 3,
        AGGREGATE_TIME = 4,
        AGGREGATE_TEXT = 6,
        AGGREGATE_USER_DEFINED = 7
    };               

    enum SOCKET_ERROR
    {
        SUCCESS,
        INVALID_NAME,
        INVALID_LOGIN,
        USER_ALREADY_LOGGED,
        INVALID_USER,
        INVALID_PASSWORD,
        SERVER_ERROR,
        XFERFAIL,
        XFERERROR,
        XFERABORT,
        XFER_RECEIVE_ERROR,      
        NONEXISTING_ROOM,
        EXISTING_ROOM,
        ROOM_ISFULL,
        ROOM_HASERROR,
        PROXY_METHOD_ERROR,
        PROXY_BAD_ANSWER,
        PROXY_BAD_AUTH,
        KICK_BAN_ERROR            
    };

    enum STATE_MASK
    {
        OFF_LINE = 0,    
        IP_VISIBLE = 0x1,    
        NON_SEARCHABLE = 0x2, 
        FREE = 0x4,
        NETFRIEND = 0x8,
        BUSY = 0x10,
        AUDIO_VIDEO = 0x20,    
        FILE_TRANSFER = 0x40,
        FILE_SHARING =  0x80,           
        AWAY = 0x100
    };

    enum ROOM_TYPE
    {
        PUBLIC_C6 = 0x03,
        PUBLIC_NET = 0x05,
        PRIVATE_NET = 0x04,
        C6_FULL = 0x0f
    };   
    
    enum MESSAGE_TYPE
    {
        SILENTLY = 1,    
        ORDINARY_MSG,
        SCREAMED,
        SELF,
        SILENTLY_BLU,
        ORDINARY_GREEN,
        SCREAMED_RED,
        SILENTLY_BLU_SPOT,
        ORDINARY_GREEN_SPOT,   
        SCREAMED_RED_SPOT,
        ROOM_WELCOME,
        BRD,
        INVITE,    
        NEW_STYLE_MSG,
        BASE_INFO
    };             
    
    enum OPERATION_TYPE
    {
        ORDINARY_OP = 0,
        AWAY_OP,    
        BLACK_LIST_OP,
        FILE_TRANSFER_OP,
        AUDIO_VIDEO_OP,
        AGENT_OP,
        GAME_REQ_OP,
        GAME_ANS_OP,
        AUTH_BUDDY_OP,                                            
        FILE_SHARE_OP = 15,
        FILE_TRANSFER_AUDIO_VIDEO,
        XX_2,
        REQUEST_FILE = 21,
        REQUEST_FILE_ACCEPT = 22,
        REQUEST_FILE_DENY = 23                          
    };            
    
    enum FONT_STYLE
    {
      UNDEFINED = -1,      
      BOLD = 1,
      ITALICS = 2,          
      UNDERLINE = 4,
      COLOR = 8  
    };             
    
    enum FONT_TYPE
    {
        DEFAULT = -1
    };              
    
    enum SERVER_CAPABILITIES
    {
        SERVER_FILESHARING_ALLOWED = 1,
        SERVER_FILESHARINGSEARCH_ALLOWED = 2,
        SERVER_CLIENTISNAT = 4        
    };             
    
    enum ROOM_ENTER_MODE
    {
        ROOM_SUPER_USER = 1,
        ROOM_CHAT_LEADER = 2,      
        ROOM_SCREENER = 4,        
        ROOM_SPEAKER = 8,
        ROOM_STAFF = 16,   
        ROOM_GUEST = 32,
        ROOM_USER_LIST = 64,
        ROOM_MODERATOR = 128
    };             
    
    enum ROOM_MESSAGE_TYPE
    {
        MODERATED = 1,
        SCREENED = 3    
    };             
    
    enum ROOM_OPERATION_MODE
    {
        ROOM_KICK = 1,
        ROOM_BAN = 2,
        ROOM_IP_BAN = 4,
        ROOM_CLI_BAN = 8            
    };             
    
    enum DOMAIN_BAN
    {
         PRESENCE = 1,
         ROOM_NAME_BAN = 300       
    };             
    
    
    enum ROOM_ERROR_CODES
    {
        ROOMFULL_ERROR = 1,          
        ROOMERROR_PASSWDNOK = 2, 
        ROOMERROR_USERBANNED = 3,     
        ROOMERROR_NOAUTHIP = 4,
        ROOMERROR_NOAUTHNICK = 5, 
        ROOMERROR_NOAUTHGUEST = 6, 
        ROOMNOCREATEPUBLIC =  7, 
        ROOMNOCREATEPRIVATE =  8 
    };             
    
    enum ROOM_SEARCH_ATTRIBUTE
    {
        SEARCH_USER_ROOM = 1,
        SEARCH_SYSTEM_ROOM = 2,
        SEARCH_USER_SYSTEM = 3,
        SEARCH_NICK_ROOM = 4,
        SEARCH_PRIVATE = 8        
    };             
    
    enum USER_SEARCH_TYPE
    {
        PROFILE_SEARCH = 0,
        EMAIL_SEARCH,
        NICK_SEARCH         
    };   
             
    class RoomAttribute
    { 
       public: 
           RoomAttribute();
           int pack();    
           void unpack(int attribute); 
                 
           void setPublic(bool set); 
           void setSystem(bool set); 
           void setTemporary(bool set); 
           void setProfileLess(bool set);       
           void setReadOnly(bool set);  
           void setTOP(bool set);             
           void setModerated(bool set); 
           void setPasswordProtected(bool set); 
           void setClonable(bool set); 
           void setGuest(bool set);       
           void setGuestCanWrite(bool set);     
           void setNickRestriction(bool set); 
           void setIPRestriction(bool set);       
           void setLog(bool set);    
           void setExternalChat(bool set);  
           
           bool isPublic() const;
           bool isSystem() const;     
           bool isTemporary() const;     
           bool isProfileLess() const;    
           bool isReadOnly() const;  
           bool isTOP() const;        
           bool isModerated() const;   
           bool isPasswordProtected() const;   
           bool isClonable() const;  
           bool hasGuest() const;  
           bool guestCanWrite() const;
           bool hasNickRestriction() const; 
           bool hasIPRestriction() const; 
           bool hasLog() const;       
           bool hasExternalChat() const;  
           
        private:      
           // bitfield are not useful cause machine dependant      
           bool _isPublic;              
           bool _isSystem;
           bool _isTemporary;     
           bool _isProfileLess;
           bool _isReadOnly;
           bool _isTOP;
           bool _isModerated;
           bool _isPasswordProtected;
           bool _isClonable;                             
           bool _hasGuest;
           bool _guestCanWrite;     
           bool _hasNickRestriction;
           bool _hasIPRestriction;
           bool _hasLog;
           bool _hasExternalChat;
    };               
    
    class Category
    {
        public:   
            std::vector<int> subid;    
            QString description;   
    };
    
    class RoomSearchResult
    {
        public:
            QString roomName;
            int roomUsersCount;
            int roomAttribute;
            int profileFields;
            std::vector<char> subid;
            int userRole;                               
    };             
       
    class C6MessageStyle
    {
        public:
            C6MessageStyle();
            void setMessageType(MESSAGE_TYPE type);
            void setOperationType(OPERATION_TYPE type);
            MESSAGE_TYPE getMessageType() const;
            OPERATION_TYPE getOperationType() const;
            void setBold(bool isBold);
            bool isBold() const;
            void setItalics(bool isItalic);
            bool isItalic() const;
            void setUnderline(bool isUnderlined);
            bool isUnderline() const;
            int getFontStyle() const;
            void setRGB(int r,int g,int b);
            void getRGB(int &r,int &g,int &b);
            void setFontTypeNo(int fontType);
            void setFontStyle(int style);
            int getFontTypeNo() const;
            void setFontSizePt(int fontSize);
            int getFontSizePt() const;
                
        private:         
            MESSAGE_TYPE _styleid; 
            OPERATION_TYPE _oper; 
            int _fontType;
            int _redComponent;
            int _greenComponent;
            int _blueComponent;                    
            int _fontStyle;   
            int _fontSize;   
    };             
    
    typedef XCAPListType ListType;    
    typedef QMap<QString,int> RoomUserType;
    
    static const int SKIP_PACKET_HEADER  = 6;
    static const int PACKET_HEADER_LEN = 6;
    static const int PACKET_LEN_OFFSET = 4;  
    static const int OPENC6_CLIENT_TYPE = 0x02;    
    static const int OPENC6_CLIENT_VERSION = 0x33;    
    
    C6Proto(QObject *parent=0);
    ~C6Proto();

    void startConnection(QString const & nick,QString const & pwd);
    /** exit c6 server  */
    void ReqClientExit();
    /** remove a user from c6 server list  */
    void RemoveUser(QString nick);
    /** Send the actual packet */
    void sendMessage(QString const &nick ,bool isOnline,QString const &text,C6MessageStyle style);
    /** kill a socket connection */
    void closeSocket();
    void sendUserRequest(QStringList & nick_lst);
    void sendUserRequest(QString const & nick);
    void getIPAddress(QString const &nick);
    void exitFromRoom(QString const& room);
    /** Dump a packet  */
    static void DumpPacket(unsigned char *data,int len);
    void createRoom(QString const& roomName, QString const& topic,int roomAttribute,int index,int enterMode,QString const& password);
    void roomSearch(int roomAttribute,unsigned char *property,QString roomName = "");
    void setInitialStatus(C6Users::C6USER_STATUS status,bool isVisible = false);   
    void requestFileTransfer(QString const & nick,QString const &filename,int clientVersion);    
    void requestInfo(QString const & nick);   
    void loginAs(QString const & nick,QString const &password);    
  
  
    static const char* getStatusString(unsigned int status);
    static const char* getAggregateValueType();   
    static C6Users::C6USER_STATUS mapPS2US(int status);
    static int mapUS2PS(C6Users::C6USER_STATUS status);   
    bool isOldAccount();   
    void setOldAccountMode(bool set);
    void addBuddy(QString const &group,QString const &nick);  
    void addBuddyToBlackList(QString const &nick);       
    void addBuddyToWhiteList(QString const &nick);   
    void removeBuddy(QString const &group,QString const &nick);
    void removeBuddyFromBlackList(QString const &nick);   
    void removeBuddyFromWhiteList(QString const &nick);   
    void addGroup(QString const &group);  
    void removeGroup(QString const &group);
    void renameGroup(QString const &oldGroup,QString const &newGroup);        
    void getGateway(QString &ip,int &port);
    void grantIP(const QString &ip,int port,const QString &nickToGrant);     
    bool hasNAT() const;           
    void setAuthorizationMode(QString const & mode);
    void setOfflineMessageMode(QString const & mode);
    C6XCAPClient::CONFIG_MODE getConfigurationMode();
    C6XCAPClient::OFFLINE_MODE getOfflineMessageMode();
    void sendAndSetOfflineMessageMode(C6XCAPClient::OFFLINE_MODE mode);
    void sendAndSetConfigurationMode(C6XCAPClient::CONFIG_MODE mode);       
    void initBuddyList();   
    void initAuthorization();
    void initConfiguration();
    void retrieveStuffFromServer();      
    void setBuddyLists(ListType list,QStringList const& blacklist,QStringList const& whitelist);    
    void setMessageOfTheDay(QString const & message);
    void enterRoom(QString const& roomName,QString const& password = QString::null,QString const& oldRoom = QString::null,int enterMode = ROOM_SPEAKER);   
    void roomError(unsigned char *data,int packL);
    void kickUserFromRoom(QString const &room,QString const &nick,int duration);
    const std::vector<Category>& getRoomCategoryVector() const ;    
    void requestCategoryList();
    void searchByNick(QString const& nick);
    const QString& getProfileUrl() const;
    void getOfflineMessage();
    bool isConnected() const;       
    static int parseAggregate(unsigned char* ptr,const unsigned char* maxPtr,int &fieldLenght,QVariant &variant);
    
public slots: // Public slots
    void sendChatMessage(QString const & nick,bool status,QString &text,C6MessageStyle style);
    void requestProfile(const QString &nick);
    int activateFileReception(QString const& nick,int port);
   
    void sendMessageToRoom(QString &,QString &msg,int style );
    /** change client status  */
    void changeStatus(C6Users::C6USER_STATUS status,QString const &message = QString::null,bool reloadAuthList = false);
    
signals: // Signals
    void signalError(int err,const QString& error = QString::null);
    void fireConnection(QHostAddress ip,int port,QString filename,QString nick);
    /** send online signal  */
    void signalOnline();
    /** notify c6 that a user is online  */
    void notifyStatus(C6Users::C6UsersVector &,bool boot = false);
    /** dispatch message to destination chat  */
    void messageReceived(QString&,QString&,C6Proto::C6MessageStyle *msg =0);
    void progress(int);
    void ForceConnect(bool );
    /** signal offline status  */
    void SignalOffline(bool);
    /** write on system log */
    void SysLog(QString);
    void notifyInfoResult(const QString &nick,unsigned char *data,int packL,bool toGUI);
    void notifySearchList(QStringList*,std::vector<C6Users::C6USER_STATUS>);
    void prepareFileReception(QString &nick,QString &mess);
    void nowSelectUser(unsigned char *data);
    void updateRooms(QString &name,unsigned int people_no,unsigned char kind);
    void messageFromRoom(QString &room_name,QString &nickfrom,QString &msg);
    void eventFromRoom(QString &room_name,QString &nick,C6Proto::SERVER_COMMAND_ID action);
    void exitFromRoomOk();
    void searchResultReady(std::vector<C6Proto::RoomSearchResult>& result);
    void infoLogin(bool oldAccount);
    void extendedChangeStatus(const C6Users::C6Users &c6user);   
    void signalServerStats(const QString &);
    void parseBuddyList(QByteArray &data);       
    void parseBuddyAuth(QByteArray &data);
    void parseBuddyConfig(QByteArray &data);   
    void roomEnterInfo(const QString& roomName,const QString& roomTopic,int roomAttribute,int allowedUserRole,QMap<QString,int>& users);  
    void askForPassword(const QString& roomName);
    void notifyReportMessage(const QString& fromNick,const QString& text,const QString& time); 
private: // Private attributes
    
    typedef QMap<QString,QString> ButtonURLType;   
    
    enum CLIENT_COMMAND_ID
    {
        LOGIN = 0x1001,
        CLIENT_REQ_EXIT = 0x1002,
        REQ_USERS = 0x1003,
        DEL_USERS = 0x1004,
        SEARCHEMAIL = 0x1005,
        OL_MESSAGE = 0x1008,
        OF_MESSAGE = 0x1009,
        CHG_STATUS = 0x100A,
        PONG = 0x100B,
        REQ_PROFILE = 0x100C,
        SEARCHPROFILE = 0x100E,
        CLIENTID = 0x100f,
        GET_IPADRESS = 0x1010,
        GRANT_IP = 0x1011,
        GET_OF_MESSAGE = 0x1013,
        DEL_OF_MESSAGE = 0x1014,        
        EXTENDED_STATUS= 0x1016,       
        ROOM_MSG = 0x1020,
        REQUEST_ROOM = 0x1021,             // REPLACE BY CLIENT_ENTER_ROOM
        REQUEST_EXIT_ROOM = 0x1022,
        SEARCH_ROOM = 0x1023,
        QUERY_ROOM = 0x1024,
        REQUEST_CREATE_ROOM = 0x1025,     // REPLACED BY CLIENT_CREATE_ROOM
        REQUEST_ROOM_PROFILE = 0x1026,
        CLIENT_FIND_NICK = 0x1027,    
        LOGIN_AUTH = 0x1031,
        CLIENT_ENTER_ROOM = 0x1032,            
        CLIENT_CREATE_ROOM = 0x1034,    
        CLIENT_SEARCH_ROOM = 0x1033,    
        CLIENT_EXIT_ROOM = 0x1036,           
        CLIENT_KICK = 0x1037            
    };
    
   
    
    unsigned int OutCount;
    bool infoLoginFlag;
    bool _ipVisible; 
    QString _initialMessageODD;    
    QString firstLogin;
    QString firstPassword;
    QString sendFilePath;
    QString sendNick;
    QString _currentLoggedNick;
    QString _currentLoggedPassword;    
    unsigned char Ord_Key[8];
    unsigned char ServerKey[16];
    unsigned char md5Key[16];
    unsigned char *BannerDataP;
    int _socketStatusProgress;
    C6Users::C6USER_STATUS _initStatus;
    C6Users::C6USER_STATUS _previousStatus;
    QString _previousOwnMessage;    
    QSocket* _pSocket;
    QString _nickPictureUrl;
    QString _profileUrl;    
    bool _oldAccount; 
    bool _hasNAT;        
    C6XCAPClient* _xcapHandler;    
    C6ProxySocket *_gateway;   
    QStringList* _gatewayList;    
    ButtonURLType _buttonURL;   
    C6XCAPClient::CONFIG_MODE _configurationMode;
    C6XCAPClient::OFFLINE_MODE _offlineMode;         
    
private slots: // Private slots
    void socket_Connected();
    void socket_Error(int);
    void socket_ReadyRead();
    void socket_bytesWritten(int);
    void sendSearch(unsigned char *seq,C6Proto::USER_SEARCH_TYPE type);
    void socket_connectionClosed();
    void proxyConnected();
    void proxyError(int);
    void urlListDone(const QString& filename,C6HttpConnection*);
    void httpClosed();  
    void httpCategoryClosed();
    void httpCategoryDone(const QString& filename,C6HttpConnection*);               
    void buddyListSlot(QByteArray &data);       
    void buddyAuthSlot(QByteArray &data);   
    void buddyConfigSlot(QByteArray &data);      
    void xcapResponseOKSlot(C6XCAPClient::XCAP_STATE status);
     
private: // Private methods
    void commandActionHandler(unsigned char *com,int avail);
    void Helo(unsigned char *p,int packL=0);
    void rerouteServer(unsigned char* data,int packL=0);
    void welcome(unsigned char* data,int packL=0);
    /** notify online users  */
    void SendUsers(unsigned char *data,int packL=0);
    /** Check the user status  */
    void userStatus(unsigned char *data,int packL=0);
    /** handle an incoming chat message */
    void cryptedData(unsigned char *data,int packL=0);
    /** handle clean incoming chat message */
    void receiveMessage(unsigned char *data,int packL=0);
    /** answer pong to server pings */
    void Pong();
    /** extract profile link and register link */
    void infoLogin(unsigned char*,int packL=0);
    /** actually send data to socket  */
    void sendToSocket(CLIENT_COMMAND_ID command,unsigned char *buf,int len);
    /** end a connection and signal the client */
    void closeConnection();
    void analyzeSearchResult(unsigned char *data,int packL=0);
    void analyzeProfileResult(unsigned char *data,int packL=0);
    void sendReply(unsigned char *data,int packL=0);
    void selectUser(unsigned char *data,int packL=0);
    void receiveRooms(unsigned char *data,int packL=0);
    void receiveMsgFromRoom(unsigned char *data,int packL=0);
    void receiveEventFromRoom(unsigned char *data,C6Proto::SERVER_COMMAND_ID action,int packL=0);
    void getRoomSearchResult(unsigned char *data,int packL=0);
    void createSocket();
    void onlineStatusChange(unsigned char* data,int packL);
    void processInfoLogin(unsigned char* data,const unsigned char* maxPtr);
    void getUriFromHttp();
    void getCategoryFromHttp();   
    QString getButtonUrl(QString button);    
    void login(QString const &password);    
    void writeAggregate(std::vector<char> &data,int fieldNo,int &fieldCounter,QVariant &variant);
    void requestBuddyAuth();
    void requestBuddyList();      
    void requestBuddyClientConfig();   
    void processButtons();
    void setExtendedStatus(C6Users::C6USER_STATUS status,QString const & message = QString::null,bool reloadAuthList = false);  
    void roomEntered(unsigned char *data,int packL);   
    void receiveOfflineMessage(unsigned char *data,int packL);
    void removeOfflineMessage(int id);   
    void receiveKickBanError(unsigned char *data,int packL);   
};

#endif

