/***************************************************************************
                          c6report.cpp  -  description
                             -------------------
    begin                : Fri Nov 21 2003
    copyright            : (C) 2003 by Giorgio A.
    email                : openc6@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "c6report.h"
#include "c6settings.h"
#include "c6textedit.h"
#include "c6global.h"
#include "c6pixmapcache.h"
#include "c6button.h"
#include <qlayout.h>
#include <qlabel.h>
#include <qcolor.h>
#include <qdatetime.h>
#include <qtooltip.h>

C6Report::C6Report(QWidget *parent, const char *name ) : report(parent,name),
        _reportEdit(0)
{
    C6Global &global = C6Global::getInstance();
    QString path = global.getSkinPath();
    C6PixmapCache &pix=C6PixmapCache::getInstance();

    setIcon(pix.getPixmap(path+"icon16x16.png"));

    reportPlaceHolder->hide();
    _reportEdit = new C6TextEdit(this,0,0,0,0);
    _reportEdit->setMinimumSize(QSize(400,300));
    _reportEdit->setFrameShape(QTextEdit::Box);
    _reportEdit->setFrameShadow(QTextEdit::Plain);
    _reportEdit->setLineWidth(1);
    _reportEdit->setPaletteBackgroundColor(QColor(255,255,255));   

    layout46->insertWidget(1,_reportEdit);
    connect(_reportEdit,SIGNAL(execUrl(QString &)),this,SLOT(execUrlProc(QString &)));

    exitButtonPlaceHolder->hide();
    C6Button* exitButton = new C6Button(frame15,0,0,
                                        path+"chat_71.png",
                                        path+"chat_over_109.png");
    layout33->addWidget(exitButton);
    connect(exitButton,SIGNAL(clicked()),this,SLOT(close()));

    clearButtonPlaceHolder->hide();
    C6Button* clearButton = new C6Button(this,0,0,path+"report_clean_10.png",
                                         path+"report_clean_over_10.png");
    layout32->addWidget(clearButton);
    connect(clearButton,SIGNAL(clicked()),this,SLOT(clearReport()));
    
    QWidget *upParent = reinterpret_cast<QWidget*>(aboutButtonPlaceHolder->parent());   
    C6Button* aboutButton = new C6Button(upParent,0,0,path+"chat_68.png",
                                     path+"chat_over_68.png",
                                     path+"chat_over_68.png");
    QToolTip::add
            (aboutButton,"Informazioni su OpenC6");
    aboutButtonPlaceHolder->hide();
    layout34->addWidget(aboutButton);   
    connect(aboutButton,SIGNAL(clicked()),this,SLOT(aboutClicked()));      
    
    global.setBehaviourIfMacOSX(_reportEdit);   
    setCustomFont();      
}

C6Report::~C6Report()
{}

void C6Report::notify(QString const& nick,QString const& text,QString const& timeString)
{
    if (!isShown())
    {
        show();
        raise();
        setActiveWindow();
    }

    QString tmp;    
    
    if (timeString != QString::null) 
    {
        tmp = "<netfnick>["+timeString+"]&nbsp;</netfnick>";     
    }   
    else
    {         
        tmp ="<netfnick>["+QTime::currentTime(Qt::LocalTime).toString()+"]&nbsp;</netfnick>";
    }   
       
    tmp+=_reportEdit->processRichText(" nick://"+nick);

    QString reportStr = text;
    reportStr.replace("<","&lt;");
    reportStr.replace(">","&gt;");          
    tmp+="<netfmessage>&nbsp;-&nbsp;"+_reportEdit->processRichText(reportStr)+"</netfmessage>";

    _reportEdit->append(tmp);
}

void C6Report::clearReport()
{
    _reportEdit->clear();
}

/*!
    \fn C6Report::execUrlProc(QString )
 */
void C6Report::execUrlProc(QString  & str)
{
    QString url = "nick://"+str;
    emit execUrl(url);
}

void C6Report::aboutClicked()
{
    emit showAbout();
}

/*!
    \fn C6Report::setCustomFont()
 */
void C6Report::setCustomFont()
{
    C6Global &global=C6Global::getInstance();
    QFont lfont(global.getBaseFont());
    int tmp = lfont.pointSize()-1;
    if (tmp > 2)
    {
        lfont.setPointSize(tmp);
        setFont(lfont);
    }
}
    

