//
// C++ Interface: c6roomlist
//
// Description:
//
//
// Author: Giorgio A. <openc6@hotmail.com>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef C6ROOMLIST_H
#define C6ROOMLIST_H

#include <rooms.h>
#include "c6proto.h"

class QComboBox;
class QPopupMenu;

/**
@author Giorgio A.
*/

class C6RoomList : public rooms
{
Q_OBJECT
public:
    C6RoomList(std::vector<C6Proto::Category> const& category,QWidget *parent = 0, const char *name = 0);
    ~C6RoomList();
    void setWaitResult();
    void loadCategoryList(std::vector<C6Proto::Category> const& categoryVector);   
    void updateResults(std::vector<C6Proto::RoomSearchResult>& result);
    void setCustomFont();    
    
private slots:
    void menuSelect(QListViewItem *item, const QPoint & pos,int id);
    void curItemSelected(QListViewItem *item);
    void categoryItemSelected(QListViewItem *item);   
    void enterRoom();
    void createRoom();
    void searchRoom();
    void publicSwitchClicked();
    void privateSwitchClicked();
    void systemSwitchClicked();
    void userSwitchClicked();
    void profileRoom();
    void doubleClickList(QListViewItem * item);
    void aboutClicked();   
    void roomSelectionChanged(QListViewItem* item);
    void sendSelected(const QStringList &nick,const QString &message);
    void categoryDoubleClicked(QListViewItem *item,const QPoint &pos , int column);

signals:
    void enterRoom(const QString & room_name);
    void createRoom(const QString& roomName,const QString& caption,bool isPublic,int index,const QString& password);
    void searchFilteredRoom(int roomSearchAttribute,unsigned char *prop);
    void showProfile(QString &);
    void showAbout();   
    void inviteSelected(const QString &room,const QStringList &nick,const QString &message);   
    void reqRoomProfile(QString& roomName);  
private:
    void setRoomCategoryCombo(std::vector<C6Proto::Category> const& categoryVector);
    void setRoomCategoryList(std::vector<C6Proto::Category> const& categoryVector);
    void inviteInRoom(QString const& roomName);
    void setNoResult();
    
private:
    QPopupMenu* _roomListMenu;
    
    const std::vector<C6Proto::Category>& _category;   
};

#endif
