/***************************************************************************
                          c6search.h  -  description
                             -------------------
    begin                : Fri Nov 7 2003
    copyright            : (C) 2003 by Giorgio A.
    email                : openc6@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef C6SEARCH_H
#define C6SEARCH_H

class QWidget;
class C6Button;
class QPopupMenu;
class QListViewItemItem;
class QStringList;
class C6PhotoRetriever;

#include <search.h>
#include <qstring.h>
#include "c6proto.h"
#include "c6users.h"
#include "macroetc.h"

/**
  *@author Giorgio A.
  */


#define MAX_COMBO 5 

class C6Search : public search
  {
    Q_OBJECT
  public:
  
    C6Search(QWidget *parent=0, const char *name=0);
    ~C6Search();
    void setCustomFont();
    void showResults(QStringList*,std::vector<C6Users::C6USER_STATUS>);
    
  private: // Private attributes
    static const int SAVESLOT = 4;
    static const int MAXCOMBO = MAX_COMBO;     
    
    QComboBox* searchKey[MAXCOMBO];
    QLabel* searchText[MAXCOMBO];
    QPopupMenu* menu;
    QPopupMenu* subMenu;
    
    unsigned char searchSavedValue[SAVESLOT][MAXCOMBO];
    C6PhotoRetriever* _photoRetriever;
  private slots: // Private slots
    void selectProfile();
    void startSearch();
    void selectEmail();
    void selectNick();   
   
    void menuClicked(QListViewItem *, const QPoint &pos, int );
    void selectValue(int sel);
    void doubleClicked(QListViewItem* item,const QPoint &point, int);
    void aboutClicked();
    void setPhoto(QByteArray& data,const QString& filename);
    
  signals: // Signals
    void sendSearchValue(unsigned char *seq,C6Proto::USER_SEARCH_TYPE type);
    void searchMenuClicked(const QString &item,USER_MENU_ACTIONS action);
    void showAbout();
    void searchByNick(const QString& nick);           
        
  public slots: // Public slots
    void checkCountry(const QString &a);
    void saveClicked();

  private: // Private methods
    void loadDefaultSearch();
    void saveDefaultSearch();
    void setWaitResult();   
  };

#endif
