//
// C++ Implementation: c6settings
//
// Description:
//
//
// Author: Giorgio A. <openc6@hotmail.com>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "c6settings.h"
#include <qsettings.h>
#include <qdir.h>
#include <qfont.h>
#include <qstring.h>
#include "macroetc.h"

static QString BUSYSTR = QString::fromUtf8("è momentaneamente occupato.");
static QString NETFRIENDSTR = QString::fromUtf8("in questo momento è impegnato in altre conversazioni.");
static QString AWAYSTR = QString::fromUtf8("in questo momento non è davanti al PC. Puoi lasciare un messaggio.");

static const char* defaultFontStringList[] = {"Arial","Arial Black","Comic Sans MS","Courier New","Georgia",
    "Impact","Times New Roman","Trebuchet MS","Verdana","Webdings",0};

static const QString APP_KEY = "/C6/";
const int MAX_FONT = 10;   

C6Settings::C6Settings():
        _firstBoot(true)
{}


C6Settings::~C6Settings()
{}


/*!
    \fn C6Settings::loadSettings()
 */
void C6Settings::loadSettings()
{
    if (_firstBoot == true)
    {
        loadDefaultSettings();
        saveSettings();
        _firstBoot = false;
    }

    QSettings *settings = new QSettings();
    settings->insertSearchPath(QSettings::Unix,QDir::homeDirPath()+"/"+C6DIR);

    serverName = settings->readEntry( APP_KEY + "Server/Server","c6login.tin.it");
    serverPort = settings->readEntry( APP_KEY + "Server/Port","4800");
    proxyName = settings->readEntry( APP_KEY + "Server/Proxy","127.0.0.1");
    proxyPort = settings->readEntry( APP_KEY + "Server/ProxyPort","1080");
    proxyUserId = settings->readEntry( APP_KEY + "Server/ProxyUserId","");
    proxyUserPsw = settings->readEntry( APP_KEY + "Server/ProxyUserPsw","");
    status = settings->readNumEntry( APP_KEY + "Config/Status",0);     // default 0 is AVAILABLE
    blackListMessage = settings->readEntry( APP_KEY + "Msg/BlackMsg",BLKSTR);
    busyMessage  = settings->readEntry( APP_KEY + "Msg/BusyMsg",BUSYSTR);
    netFriendsMessage = settings->readEntry( APP_KEY +
                        "Msg/NetFriendsMsg",NETFRIENDSTR);
    awayMessage = settings->readEntry( APP_KEY + "Msg/AwayMsg",AWAYSTR);
    autoMessage = settings->readBoolEntry(APP_KEY+"Config/AutoMsg",true);
    log =  settings->readBoolEntry(APP_KEY+"Config/Log",false);
    autoConnect = settings->readBoolEntry(APP_KEY+"Config/AutoConnect",false);
    reconnect = settings->readBoolEntry(APP_KEY+"Config/Reconnect",false);
#if defined(Q_OS_MACX) || defined(Q_OS_DARWIN)
    browser = settings->readEntry( APP_KEY + "Config/Browser","open");
#else
    browser = settings->readEntry( APP_KEY + "Config/Browser","firefox");
#endif

    autoRaise = settings->readBoolEntry( APP_KEY + "Config/AutoRaise",true);
    autoPopUp = settings->readBoolEntry( APP_KEY + "Config/AutoPopUp",true);
    sysLog = settings->readBoolEntry( APP_KEY + "Config/SysLog",true);
    showOnline = settings->readBoolEntry( APP_KEY + "Config/ShowOnline",true);
    soundSwitch = settings->readBoolEntry( APP_KEY + "Audio/SoundSwitch",true);
    beepSwitch = settings->readBoolEntry( APP_KEY + "Audio/BeepSwitch",false);
    inMessageWav = settings->readEntry( APP_KEY + "Audio/InMessageWav", "");
    outMessageWav = settings->readEntry( APP_KEY + "Audio/OutMessageWav", "");
    onlineMessageWav = settings->readEntry( APP_KEY + "Audio/OnlineMessageWav", "");
    offlineMessageWav = settings->readEntry( APP_KEY + "Audio/OfflineMessageWav", "");
    specialFriendWav = settings->readEntry( APP_KEY + "Audio/SpecialFriendWav", "");
    inMessageSwitch = settings->readBoolEntry( APP_KEY + "Audio/InMessageSwitch",true);
    outMessageSwitch = settings->readBoolEntry( APP_KEY + "Audio/OutMessageSwitch",true);
    onlineMessageSwitch = settings->readBoolEntry( APP_KEY + "Audio/OnlineMessageSwitch",true);
    offlineMessageSwitch = settings->readBoolEntry( APP_KEY + "Audio/OfflineMessageSwitch",true);
    specialFriendSwitch = settings->readBoolEntry( APP_KEY + "Audio/SpecialFriendSwitch",true);
    specialNotifySwitch = settings->readBoolEntry( APP_KEY + "Config/SpecialNotifySwitch",false);
    ipVisible = settings->readBoolEntry( APP_KEY + "Config/ipVisible",false);
    soundPlayer = settings->readEntry( APP_KEY + "Audio/SoundPlayer","play");
#if defined(Q_OS_MACX) || defined(Q_OS_DARWIN)
    fontStyle = settings->readEntry( APP_KEY + "Font/FontStyle","Lucida Grande");
    fontSize = settings->readNumEntry( APP_KEY + "Font/FontSize",12);
#else
    fontStyle = settings->readEntry( APP_KEY + "Font/FontStyle","Sans");
    fontSize = settings->readNumEntry( APP_KEY + "Font/FontSize",10);
#endif

    fontWeight = settings->readNumEntry( APP_KEY + "Font/FontWeight",QFont::Normal);
    foregndColor = settings->readEntry( APP_KEY + "Font/ForeColor","#000060");
    foreMessageColor = settings->readEntry( APP_KEY + "Font/ForeMessageColorUp","#59A4FF");
    foreNetFriendColor = settings->readEntry( APP_KEY + "Font/ForeNetFriendColorUp","#FA3200");

    dockIcon = settings->readBoolEntry( APP_KEY + "Config/DockIcon",false);
    timeStampSwitch = settings->readBoolEntry( APP_KEY + "Config/TimeStamp",true);
    fileReceivePath = settings->readEntry(APP_KEY
                                          +"File/FileReceivePath",QDir::homeDirPath()+"/c6incoming");
    startPort = settings->readEntry(APP_KEY + "File/StartPort","1400");
    sortAscending = false;
    autoAccept = settings->readBoolEntry( APP_KEY + "File/AutoAccept",false);
    lastLogin = settings->readEntry(APP_KEY +"User/LastLogin","NONE");
    autoRoomEnter = settings->readBoolEntry( APP_KEY + "Room/AutoRoomEnter",false);
    roomTimeStamp = settings->readBoolEntry( APP_KEY + "Room/RoomTimeStamp",true);
    roomLog = settings->readBoolEntry( APP_KEY + "Room/RoomLog",false);
    autoRoomMinimize = settings->readBoolEntry( APP_KEY + "Room/AutoRoomMinimize",false);
    protoLog = settings->readBoolEntry( APP_KEY + "Config/ProtoLog",false);
    selectGlobalFont = settings->readBoolEntry( APP_KEY + "Config/SelectGlobalFont",false);
#if defined(Q_OS_MACX) || defined(Q_OS_DARWIN)

    globalFontFamily = settings->readEntry( APP_KEY + "Font/GlobalFontFamily","Lucida Grande");
    globalFontSize = settings->readNumEntry(APP_KEY + "Font/GlobalFontSize",12);
#else

    globalFontFamily = settings->readEntry( APP_KEY + "Font/GlobalFontFamily","Sans");
    globalFontSize = settings->readNumEntry(APP_KEY + "Font/GlobalFontSize",10);
#endif

    globalFontWeight = settings->readNumEntry(APP_KEY + "Font/GlobalFontWeight",QFont::Normal);
    tabbedChat = settings->readBoolEntry( APP_KEY + "Config/TabbedChat",false);
    proxySwitch = settings->readBoolEntry( APP_KEY + "Server/ProxySwitch",false);
    loginTimeout = settings->readNumEntry(APP_KEY+"Config/LoginTimeout",5);
#if defined(Q_OS_MACX) || defined(Q_OS_DARWIN)
    contactFontFamily = settings->readEntry( APP_KEY + "Font/ContactFontFamily","Lucida Grande");
    contactFontSize = settings->readNumEntry(APP_KEY + "Font/ContactFontSize",11);
#else
    contactFontFamily = settings->readEntry( APP_KEY + "Font/ContactFontFamily","Sans");
    contactFontSize = settings->readNumEntry(APP_KEY + "Font/ContactFontSize",9);
#endif

    contactFontWeight = settings->readNumEntry(APP_KEY + "Font/ContactFontWeight",QFont::Normal);
    contactGroupForeColor = settings->readEntry(APP_KEY +
                            "Font/ContactGroupColor","#5C5C5C");
    contactUserForeColor =  settings->readEntry(APP_KEY +
                            "Font/ContactUserColor","#0376E7");
    proxySocksVersion = settings->readNumEntry(APP_KEY + "Server/ProxyVersion",1);
    proxyAuthSwitch = settings->readBoolEntry( APP_KEY + "Server/ProxyAuth",false);
    autoAwaySwitch = settings->readBoolEntry( APP_KEY + "Config/AutoAway",false);
    minutesAway = settings->readNumEntry(APP_KEY + "Config/AutoAwayMinutes",10);
    backAwaySwitch =  settings->readBoolEntry( APP_KEY + "Config/BackAway",false);
    contactFontSwitch  = settings->readBoolEntry( APP_KEY + "Config/ContactFontSwitch",false);
    soundOnce =  settings->readBoolEntry( APP_KEY + "Config/SoundOnce",false);
    urlList = settings->readEntry(APP_KEY+"Config/UrlList","http://c6upgrade.tin.it:8080/c650/url.ini");
    pictureUrl = settings->readEntry(APP_KEY+"Config/PictureUrl","http://multimedia.community.virgilio.it/contenuti/");
    lastIdentity = settings->readEntry(APP_KEY +"User/LastIdentity","NONE");
    styleSwitch =  settings->readBoolEntry( APP_KEY + "Config/StyleSwitch",false);
    widgetStyle =  settings->readEntry(APP_KEY + "Config/WidgetStyle","");   
    
    visualChatFontStyle.clear();   
    for (int i=0; i < MAX_FONT; i++)
    {
        QString tmp = settings->readEntry(APP_KEY + "VisualFont/Font"+QString::number(i),""); 
        if (tmp.length() > 0)
        {                    
            visualChatFontStyle.append(settings->readEntry(APP_KEY + "VisualFont/Font"+QString::number(i),"")); 
        }
        else
        {
            setDefaultVisualChatFontStyle();
            break;        
        }                     
    }      
    
    delete settings;
}


/*!
    \fn C6Settings::saveSettings()
 */
void C6Settings::saveSettings()
{
    QSettings *settings = new QSettings();

    settings->insertSearchPath(QSettings::Unix,QDir::homeDirPath()+"/"+C6DIR);
       
    settings->writeEntry(APP_KEY+"Server/Server",serverName);
    settings->writeEntry(APP_KEY+"Server/Port",serverPort);
    settings->writeEntry(APP_KEY+"Server/Proxy",proxyName);
    settings->writeEntry(APP_KEY+"Server/ProxyPort",proxyPort);
    settings->writeEntry(APP_KEY+"Server/ProxyUserId",proxyUserId);
    settings->writeEntry(APP_KEY+"Server/ProxyUserPsw",proxyUserPsw);
    settings->writeEntry(APP_KEY+"Msg/BlackMsg",blackListMessage);
    settings->writeEntry(APP_KEY+"Msg/NetFriendsMsg",netFriendsMessage);
    settings->writeEntry(APP_KEY+"Msg/BusyMsg",busyMessage);
    settings->writeEntry(APP_KEY+"Msg/AwayMsg",awayMessage);
    settings->writeEntry(APP_KEY+"Config/Browser",browser);
    settings->writeEntry(APP_KEY+"File/FileReceivePath",fileReceivePath);
    settings->writeEntry(APP_KEY+"Config/AutoMsg",autoMessage);
    settings->writeEntry(APP_KEY+"Config/Log",log);
    settings->writeEntry(APP_KEY+"Config/AutoConnect",autoConnect);
    settings->writeEntry(APP_KEY+"Config/Reconnect",reconnect);
    settings->writeEntry(APP_KEY+"Config/AutoRaise",autoRaise);
    settings->writeEntry(APP_KEY+"Config/AutoPopUp",autoPopUp);
    settings->writeEntry(APP_KEY+"Config/SysLog",sysLog);
    settings->writeEntry(APP_KEY+"Config/ShowOnline",showOnline);
    settings->writeEntry(APP_KEY+"Config/Status",status);
    settings->writeEntry(APP_KEY+"Config/SpecialNotifySwitch",specialNotifySwitch);
    settings->writeEntry(APP_KEY+"Config/ipVisible",ipVisible);
    settings->writeEntry(APP_KEY+"Audio/SoundSwitch",soundSwitch);
    settings->writeEntry(APP_KEY+"Audio/BeepSwitch",beepSwitch);
    settings->writeEntry(APP_KEY+"Audio/SpecialFriendSwitch",specialFriendSwitch);
    settings->writeEntry(APP_KEY +"Audio/InMessageWav",inMessageWav);
    settings->writeEntry(APP_KEY +"Audio/OutMessageWav",outMessageWav);
    settings->writeEntry(APP_KEY +"Audio/OnlineMessageWav",onlineMessageWav);
    settings->writeEntry(APP_KEY +"Audio/OfflineMessageWav",offlineMessageWav);
    settings->writeEntry(APP_KEY +"Audio/SpecialFriendWav",specialFriendWav);
    settings->writeEntry(APP_KEY +"Audio/InMessageSwitch",inMessageSwitch);
    settings->writeEntry(APP_KEY +"Audio/OutMessageSwitch",outMessageSwitch);
    settings->writeEntry(APP_KEY +"Audio/OnlineMessageSwitch",onlineMessageSwitch);
    settings->writeEntry(APP_KEY +"Audio/OfflineMessageSwitch",offlineMessageSwitch);
    settings->writeEntry(APP_KEY +"Audio/SoundPlayer",soundPlayer);
    settings->writeEntry(APP_KEY+"Font/FontStyle",fontStyle);
    settings->writeEntry(APP_KEY+"Font/FontSize",fontSize);
    settings->writeEntry(APP_KEY+"Font/FontWeight",fontWeight);
    settings->writeEntry(APP_KEY+"Font/ForeColor",foregndColor);
    settings->writeEntry(APP_KEY+"Font/ForeMessageColorUp",foreMessageColor);
    settings->writeEntry(APP_KEY+"Font/ForeNetFriendColorUp",foreNetFriendColor);
    settings->writeEntry(APP_KEY+"Config/DockIcon",dockIcon);
    settings->writeEntry(APP_KEY+"Config/TimeStamp",timeStampSwitch);
    settings->writeEntry(APP_KEY+"File/StartPort",startPort);
    settings->writeEntry(APP_KEY+"File/AutoAccept",autoAccept);
    settings->writeEntry(APP_KEY+"Room/RoomTimeStamp",roomTimeStamp);
    settings->writeEntry(APP_KEY+"Room/AutoRoomEnter",autoRoomEnter);
    settings->writeEntry(APP_KEY+"Room/RoomLog",roomLog);
    settings->writeEntry(APP_KEY+"Config/ProtoLog",protoLog);
    settings->writeEntry(APP_KEY+"Config/SelectGlobalFont",selectGlobalFont);
    settings->writeEntry(APP_KEY + "Font/GlobalFontFamily",globalFontFamily);
    settings->writeEntry(APP_KEY + "Font/GlobalFontSize",globalFontSize);
    settings->writeEntry(APP_KEY + "Font/GlobalFontWeight",globalFontWeight);
    settings->writeEntry(APP_KEY + "Config/TabbedChat",tabbedChat);
    settings->writeEntry(APP_KEY + "Server/ProxySwitch",proxySwitch);
    settings->writeEntry(APP_KEY+ "Config/LoginTimeout",loginTimeout);
    settings->writeEntry(APP_KEY + "Font/ContactFontFamily",contactFontFamily);
    settings->writeEntry(APP_KEY + "Font/ContactFontSize",contactFontSize);
    settings->writeEntry(APP_KEY + "Font/ContactFontWeight",contactFontWeight);
    settings->writeEntry(APP_KEY + "Font/ContactGroupColor",contactGroupForeColor);
    settings->writeEntry(APP_KEY + "Font/ContactUserColor",contactUserForeColor);
    settings->writeEntry(APP_KEY + "Server/ProxyVersion",proxySocksVersion);
    settings->writeEntry(APP_KEY + "Server/ProxyAuth",proxyAuthSwitch);
    settings->writeEntry(APP_KEY + "Config/AutoAway", autoAwaySwitch);
    settings->writeEntry(APP_KEY + "Config/AutoAwayMinutes",minutesAway);
    settings->writeEntry(APP_KEY + "Config/BackAway",backAwaySwitch);
    settings->writeEntry( APP_KEY + "Config/ContactFontSwitch",contactFontSwitch);
    settings->writeEntry( APP_KEY + "Config/SoundOnce",soundOnce);
    settings->writeEntry(APP_KEY+ "Config/UrlList",urlList);
    settings->writeEntry(APP_KEY+ "Config/PictureUrl",pictureUrl);
    settings->writeEntry(APP_KEY+"User/LastLogin",lastLogin);
    settings->writeEntry(APP_KEY+"User/LastIdentity",lastIdentity);
    settings->writeEntry(APP_KEY + "Config/StyleSwitch", styleSwitch);   
    settings->writeEntry(APP_KEY + "Config/WidgetStyle",widgetStyle);         
    
    for (int i=0; i < MAX_FONT; i++)
    {
       settings->writeEntry(APP_KEY + "VisualFont/Font"+QString::number(i), visualChatFontStyle[i]); 
    }         
    
    delete settings;
   
}

/*!
    \fn C6Settings::saveLoginIdentity(QString const & login)
 */
void C6Settings::saveLoginIdentity(QString const & login)
{
    lastLogin = login;

    if (login.contains("@"))
    {
        lastIdentity =  currentIdentity;
    }

    saveSettings();
}

/*!
    \fn C6Settings::loadDefaultSettings()
 */
void C6Settings::loadDefaultSettings()
{
    serverName = "c6login.tin.it";
    serverPort = "4800";
    proxyName = "127.0.0.1";
    proxyPort = "1080";
    proxyUserId = "";
    proxyUserPsw = "";
    status = 0;     // default 0 is AVAILABLE
    blackListMessage = BLKSTR;
    busyMessage  = BUSYSTR;
    netFriendsMessage = NETFRIENDSTR;
    awayMessage = AWAYSTR;
    autoMessage = true;
    log =  false;
    autoConnect = false;
    reconnect = false;
#if defined(Q_OS_MACX) || defined(Q_OS_DARWIN)
    browser = "open";
#else
    browser = "firefox";
#endif

    autoRaise = true;
    autoPopUp = true;
    sysLog = true;
    showOnline = true;
    soundSwitch = true;
    beepSwitch = false;
    inMessageWav = "";
    outMessageWav =  "";
    onlineMessageWav = "";
    offlineMessageWav =  "";
    specialFriendWav =  "";
    inMessageSwitch = true;
    outMessageSwitch = true;
    onlineMessageSwitch = true;
    offlineMessageSwitch = true;
    specialFriendSwitch = true;
    specialNotifySwitch = false;
    ipVisible = false;
    soundPlayer = "play";
#if defined(Q_OS_MACX) || defined(Q_OS_DARWIN)
    fontStyle = "Lucida Grande";
    fontSize = 12;
#else

    fontStyle = "Sans";
    fontSize = 10;
#endif

    fontWeight = QFont::Normal;
    foregndColor = "#000060";
    foreMessageColor = "#59A4FF";
    foreNetFriendColor = "#FA3200";
    dockIcon = false;
    timeStampSwitch = true;
    fileReceivePath =QDir::homeDirPath()+"/c6incoming";
    startPort = "1400";
    sortAscending = false;
    autoAccept = false;
    autoRoomEnter = false;
    roomTimeStamp = true;
    roomLog = false;
    autoRoomMinimize = false;
    protoLog = false;
    selectGlobalFont = false;
#if defined(Q_OS_MACX) || defined(Q_OS_DARWIN)
    globalFontFamily = "Lucida Grande";
    globalFontSize = 12;
#else
    globalFontFamily ="Sans";
    globalFontSize = 10;
#endif

    globalFontWeight = QFont::Normal;
    tabbedChat = false;
    proxySwitch = false;
    loginTimeout = 5;
#if defined(Q_OS_MACX) || defined(Q_OS_DARWIN)
    contactFontFamily = "Lucida Grande";
    contactFontSize = 11;
#else
    contactFontFamily = "Sans";
    contactFontSize = 9;
#endif

    contactFontWeight = QFont::Normal;
    contactGroupForeColor = "#5C5C5C";
    contactUserForeColor =  "#0376E7";
    proxySocksVersion = 1;
    proxyAuthSwitch = false;
    autoAwaySwitch = false;
    minutesAway = 10;
    backAwaySwitch =  false;
    contactFontSwitch  = false;
    soundOnce =  false;
    urlList = "http://c6upgrade.tin.it:8080/c650/url.ini";
    pictureUrl ="http://multimedia.community.virgilio.it/contenuti/";
    lastIdentity = "NONE";
    lastLogin = "NONE";
    styleSwitch = false;    
    widgetStyle =""; 
    
    setDefaultVisualChatFontStyle();   
}


/*!
    \fn C6Settings::setFirstBoot(bool set)
 */
void C6Settings::setFirstBoot(bool set)
{
    _firstBoot = set;
}

void C6Settings::setVisualChatFontStyle(QStringList const& set) 
{  
    visualChatFontStyle.clear();   
    for (unsigned int i=0; i < set.size(); i++)   
    {      
        visualChatFontStyle.append(set[i]);
    }      
}    

const QStringList& C6Settings::getVisualChatFontStyle() const
{
    return(visualChatFontStyle);   
}            


/*!
    \fn C6Settings::setDefaultVisualChatFontStyle()
 */
void C6Settings::setDefaultVisualChatFontStyle()
{
    visualChatFontStyle.clear();       
    int i=0;    
    while (defaultFontStringList[i] != 0)
    {
        visualChatFontStyle.append(QString(defaultFontStringList[i]));         
        i++;    
    }         
}


/*!
    \fn C6Settings::getDefaultVisualChatFontStyle()
 */
QStringList C6Settings::getDefaultVisualChatFontStyle()
{
    QStringList tmp;   
    int i=0;    
    while (defaultFontStringList[i] != 0)
    {
        tmp.append(QString(defaultFontStringList[i]));         
        i++;    
    }      
    return(tmp);     
}
