//
// C++ Interface: c6settings
//
// Description:
//
//
// Author: Giorgio A. <openc6@hotmail.com>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef C6SETTINGS_H
#define C6SETTINGS_H

#include <c6singleton.h>
#include <qstring.h>
#include <qstringlist.h>

/**
@author Giorgio A.
*/
class C6Settings : public C6Singleton<C6Settings>
  {
  public:
    friend class C6Singleton<C6Settings>;
    C6Settings();

    ~C6Settings();
    void loadSettings();
    void saveSettings();
    
    QString const & getServerName() const { return serverName; }
    QString const & getServerPort() const { return serverPort; }
    QString const & getProxyName() const { return proxyName; }
    QString const & getProxyPort() const { return proxyPort; }
    QString const & getBlackListMessage() const { return blackListMessage; }
    QString const & getBusyMessage() const { return busyMessage; }
    QString const & getNetFriendsMessage() const { return netFriendsMessage; }
    QString const & getAwayMessage() const { return awayMessage; }
    QString const & getBrowser() const {  return browser; }
    QString const & getFontStyle() const { return fontStyle; }
    QString const & getForegndColor() const { return foregndColor; }
    QString const & getForeMessageColor() const { return foreMessageColor; }
    QString const & getForeNetFriendColor() const { return foreNetFriendColor; }
    QString const & getInMessageWav() const { return inMessageWav; }
    QString const & getOutMessageWav() const { return outMessageWav; }
    QString const & getOnlineMessageWav() const { return onlineMessageWav; }
    QString const & getOfflineMessageWav() const { return offlineMessageWav;}
    QString const & getSpecialFriendWav() const { return specialFriendWav; }
    QString const & getSoundPlayer() const { return soundPlayer; }
    QString const & getFileReceivePath() const { return fileReceivePath; }
    QString const & getStartPort() const { return startPort; } 
    QString const & getLastIdentity() const { return lastIdentity;}
    QString const & getLastLogin() const { return lastLogin; }
    QString const & getCurrentIdentity() const { return currentIdentity; }
    QString const & getGlobalFontFamily() const { return globalFontFamily; }
    QString const & getProxyUserId() const { return proxyUserId; }
    QString const & getProxyUserPsw() const { return proxyUserPsw; }
    QString const & getContactFontFamily() const { return contactFontFamily;}
    QString const & getContactUserForeColor() const { return contactUserForeColor;}
    QString const & getContactGroupForeColor() const { return contactGroupForeColor;}       
    QString const & getWidgetStyle() const { return widgetStyle;}        
    
    int getStatus() const { return status; }
    int getFontSize() const { return fontSize; }
    int getFontWeight() const { return fontWeight; }
    int getGlobalFontSize() const { return globalFontSize; }
    int getGlobalFontWeight() const { return globalFontWeight; } 
    int getLoginTimeout() const { return loginTimeout; }       
    int getContactFontSize() const { return contactFontSize;}
    int getContactFontWeight() const { return contactFontWeight;}    
    
    bool getAutoMessage() const { return autoMessage;}
    bool getLog() const { return log;}
    bool getAutoConnect() const { return autoConnect;}
    bool getReconnect() const { return reconnect;}
    bool getAutoRaise() const { return autoRaise;}
    bool getAutoPopUp() const { return autoPopUp;}
    bool getSysLog() const { return sysLog;}
    bool getRoomLog() const { return roomLog;}
    bool getShowOnline() const { return showOnline;}
    bool getSoundSwitch() const { return soundSwitch;}
    bool getBeepSwitch() const { return beepSwitch;}
    bool getInMessageSwitch() const { return inMessageSwitch;}
    bool getOutMessageSwitch() const { return outMessageSwitch;}
    bool getOnlineMessageSwitch() const { return onlineMessageSwitch;}
    bool getOfflineMessageSwitch() const { return offlineMessageSwitch;}
    bool getSpecialFriendSwitch() const { return specialFriendSwitch;}
    bool getSpecialNotifySwitch() const { return specialNotifySwitch;}
    bool getSortAscending() const { return sortAscending; }
    bool getIpVisible() const { return ipVisible;}
    bool getDockIcon() const { return dockIcon;}
    bool getTimeStampSwitch() const { return timeStampSwitch;}
    bool getAutoAccept() const { return autoAccept;}
    bool getRoomTimeStamp() const { return roomTimeStamp;}
    bool getAutoRoomEnter() const { return autoRoomEnter;}
    bool getAutoRoomMinimize() const { return autoRoomMinimize;}
    bool getProtoLog() const { return protoLog;}
  
    bool getSelectGlobalFont() const { return selectGlobalFont; }    
    bool getTabbedChat() const { return tabbedChat; }    
    bool getProxySwitch() const { return proxySwitch; }    
    bool getAuthProxySwitch() const { return proxyAuthSwitch; } 
    int getProxySocksVersion() const { return proxySocksVersion; } 
    bool getAutoAway() const { return autoAwaySwitch; }
    int getMinutesAway() const { return minutesAway; }   
    bool getBackAutoAway() const { return  backAwaySwitch; }     
    bool getContactFontSwitch() const { return   contactFontSwitch; }     
    bool getSoundOnce() const { return soundOnce ; }    
    bool getStyleSwitch() const { return styleSwitch;}    
       
    QString getUrlList() const { return urlList; }    
    QString getPictureUrl() const { return  pictureUrl;  }          
    const QStringList& getVisualChatFontStyle() const;      
    
    void setServerName(QString const& set) {serverName=set;}
    void setServerPort(QString const& set) {serverPort=set;}
    void setProxyName(QString const& set) {proxyName=set;}
    void setProxyPort(QString const& set) {proxyPort=set;}
    void setBlackListMessage(QString const& set) {blackListMessage=set;}
    void setBusyMessage(QString const& set) {busyMessage=set;}
    void setNetFriendsMessage(QString const& set) {netFriendsMessage=set;}
    void setAwayMessage(QString const& set) {awayMessage=set;}
    void setBrowser(QString const& set) {browser=set;}
    void setFontStyle(QString const& set) {fontStyle=set;}
    void setForegndColor(QString const& set) {foregndColor=set;}
    void setForeMessageColor(QString const& set) {foreMessageColor=set;}
    void setForeNetFriendColor(QString const& set) {foreNetFriendColor=set;}
    void setInMessageWav(QString const& set) {inMessageWav = set;}
    void setOutMessageWav(QString const& set) {outMessageWav=set;}
    void setOnlineMessageWav(QString const& set) {onlineMessageWav=set;}
    void setOfflineMessageWav(QString const& set) {offlineMessageWav=set;}
    void setSpecialFriendWav(QString const& set) {specialFriendWav=set;}
    void setSoundPlayer(QString const& set) {soundPlayer=set;}
    void setFileReceivePath(QString const& set) {fileReceivePath=set;}
    void setStartPort(QString const& set) {startPort=set;}
    void setLastLogin(QString const& set) {lastIdentity=set;}
    void setCurrentIdentity(QString const& set) {currentIdentity=set;}
    void setGlobalFontFamily(QString const& set) {globalFontFamily=set;}
    void setStatus(int set ){status=set;}
    void setFontSize(int set ){fontSize=set;}
    void setFontWeight(int set ){fontWeight=set;}
    void setLoginTimeout(int set ){ loginTimeout=set;}
    
    void setAutoMessage(bool set){ autoMessage=set; }
    void setLog(bool set){ log=set; }
    void setAutoConnect(bool set){ autoConnect=set; }
    void setReconnect(bool set){ reconnect=set; }
    void setAutoRaise(bool set){ autoRaise=set; }
    void setAutoPopUp(bool set){ autoPopUp=set; }
    void setSysLog(bool set){ sysLog=set; }
    void setRoomLog(bool set){ roomLog=set; }
    void setShowOnline(bool set){ showOnline=set; }
    void setSoundSwitch(bool set){ soundSwitch=set; }
    void setBeepSwitch(bool set){beepSwitch=set; }
    void setInMessageSwitch(bool set){ inMessageSwitch=set; }
    void setOutMessageSwitch(bool set){ outMessageSwitch=set; }
    void setOnlineMessageSwitch(bool set){ onlineMessageSwitch=set; }
    void setOfflineMessageSwitch(bool set){ offlineMessageSwitch=set; }
    void setSpecialFriendSwitch(bool set){ specialFriendSwitch=set; }
    void setSpecialNotifySwitch(bool set){ specialNotifySwitch=set; }
    void setSortAscending(bool set){ sortAscending=set; }
    void setIpVisible(bool set){ ipVisible=set; }
    void setDockIcon(bool set){ dockIcon=set; }
    void setTimeStampSwitch(bool set){ timeStampSwitch=set; }
    void setAutoAccept(bool set){ autoAccept=set; }
    void setRoomTimeStamp(bool set){roomTimeStamp=set; }
    void setAutoRoomEnter(bool set){ autoRoomEnter=set; }
    void setAutoRoomMinimize(bool set){ autoRoomMinimize=set; }
    void setProtoLog(bool set){ protoLog=set; }
    void setSelectGlobalFont(bool set) { selectGlobalFont=set; }    
    void setGlobalFontSize(int set ){ globalFontSize=set;}    
    void setGlobalFontWeight(int set ){ globalFontWeight=set; }
    void setTabbedChat(bool set) { tabbedChat=set; }   
    void setProxySwitch(bool set) { proxySwitch=set; }    
    void setAuthProxySwitch(bool set) { proxyAuthSwitch=set; }    
    void setProxyUserId(QString const& set) { proxyUserId=set; }
    void setProxyUserPsw(QString const& set) { proxyUserPsw=set; }
    void saveLoginIdentity(QString const &);
    void setContactFontFamily(QString const& set) { contactFontFamily=set;}
    void setContactUserForeColor(QString const& set)  { contactUserForeColor=set;}
    void setContactGroupForeColor(QString const& set)  { contactGroupForeColor=set;}   
    void setContactFontSize(int set)  { contactFontSize=set;}
    void setContactFontWeight(int set)  { contactFontWeight=set;}    
    void setProxySocksVersion(int set) { proxySocksVersion=set; }     
    void setAutoAway(bool set) { autoAwaySwitch=set; }    
    void setMinutesAway(int set) { minutesAway=set; }        
    void setBackAutoAway(int set) { backAwaySwitch=set; }
    void setContactFontSwitch(bool set) { contactFontSwitch=set; }     
    void setSoundOnce(bool set) { soundOnce =set; }    
    void setUrlList(QString const& set) { urlList =set; }     
    void setPictureUrl(QString const& set) {  pictureUrl=set; }      
    void setFirstBoot(bool set);
    void setStyleSwitch(bool set) { styleSwitch=set;}       
    void setWidgetStyle(QString const& set) { widgetStyle = set;} 
    void setVisualChatFontStyle(QStringList const& set);                
    QStringList getDefaultVisualChatFontStyle();
       
  private:
    QString serverName;
    QString serverPort;
    QString proxyName;
    QString proxyPort;
    QString blackListMessage;
    QString busyMessage;
    QString netFriendsMessage;
    QString awayMessage;
    QString browser;
    QString fontStyle;
    QString foregndColor;
    QString foreMessageColor;
    QString foreNetFriendColor;
    QString inMessageWav;
    QString outMessageWav;
    QString onlineMessageWav;
    QString offlineMessageWav;
    QString specialFriendWav;
    QString soundPlayer;
    QString fileReceivePath;
    QString startPort;
    QString lastIdentity;
    QString lastLogin;
    QString currentIdentity;
    QString globalFontFamily;
    QString proxyUserId;
    QString proxyUserPsw;
    QString contactFontFamily;
    QString contactUserForeColor;
    QString contactGroupForeColor;    
    QString urlList;    
    QString pictureUrl;    
    QString widgetStyle;    
    QStringList visualChatFontStyle;    
    
    int  proxySocksVersion;    
    int  status;
    int  fontSize;
    int  fontWeight;
    int  globalFontSize;
    int  globalFontWeight;
    int  loginTimeout;
    int  contactFontSize;
    int  contactFontWeight;    
    int  minutesAway;        
    
    bool autoMessage;
    bool log;
    bool autoConnect;
    bool reconnect;
    bool autoRaise;
    bool autoPopUp;
    bool sysLog;
    bool roomLog;
    bool showOnline;
    bool soundSwitch;
    bool beepSwitch;
    bool inMessageSwitch;
    bool outMessageSwitch;
    bool onlineMessageSwitch;
    bool offlineMessageSwitch;
    bool specialFriendSwitch;
    bool specialNotifySwitch;
    bool sortAscending;
    bool ipVisible;
    bool dockIcon;
    bool timeStampSwitch;
    bool autoAccept;
    bool roomTimeStamp;
    bool autoRoomEnter;
    bool autoRoomMinimize;
    bool protoLog;
    bool selectGlobalFont;
    bool tabbedChat;
    bool proxySwitch;
    bool proxyAuthSwitch;
    bool autoAwaySwitch;    
    bool backAwaySwitch;    
    bool contactFontSwitch;    
    bool soundOnce;    
    bool styleSwitch;        
    
    bool _firstBoot;    
    
    void loadDefaultSettings();   
    void setDefaultVisualChatFontStyle();
  };

#endif
