//
// C++ Interface: c6singleton
//
// Description:
//
//
// Author: Giorgio A. <openc6@hotmail.com>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef C6SINGLETON_H
#define C6SINGLETON_H


template <typename T> class C6Singleton
{
public:
    
    static T & getInstance()
    	{
        if (m_instance == 0) 
          {
            m_instance = new T;
          }
        
        return (*m_instance);
    };

    static void destroyInstance()
    {
        delete m_instance;
        m_instance = 0;
    };

protected:

    C6Singleton() 
    {
    };    

    virtual ~C6Singleton()
    {
    };

    C6Singleton(const C6Singleton& source)
    {
    };
		
private:
   
  
    static T* m_instance;
};

template <typename T> T* C6Singleton<T>::m_instance = 0;


#endif 
