/***************************************************************************
                          c6smiley.cpp  -  description
                             -------------------
    begin                : Tue Sep 16 2003
    copyright            : (C) 2003 by Giorgio A.
    email                : openc6hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#define MAXFACCINEDIALOG 12
#define MAXCOLUMNFACCINE 6
#define ICONBORDER 5
#define HBORDER 8
#define VBORDER 14

#include "c6smiley.h"
#include "c6settings.h"
#include <qpushbutton.h>
#include <qwidget.h>
#include <qpixmap.h>
#include <qtooltip.h>
#include <qbuttongroup.h>
#include <qmime.h>
#include "macroetc.h"
#include "c6global.h"
#include "c6pixmapcache.h"

class faccines
{
public:
    QString fname;
    QString text;
};

static const faccines smiley[C6Smiley::MAXFACCINE]=
    {
        {"msn_smiley.png",":-)"},{"msn_sad.png",":-("},
        {"msn_tongue.png",":-P"},{"msn_wink.png",";-)"},
        {"msn_ooooh.png",":-0"},{"msn_angry.png",":-@"},
        {"msn_cry.png",",-)"},{"msn_embarrassed.png",":-}"},
        {"msn_kiss.png",":-*"},{"msn_neutral.png",":-|"},
        {"msn_laugh.png",":-D"},{"msn_weird.png",":-?"},
        {"msn_smiley.png",":)"},{"msn_sad.png",":("},
        {"msn_tongue.png",":P"},{"msn_wink.png",";)"},
        {"msn_laugh.png",":D"},{"msn_kiss.png",":*"}
    };

C6Smiley::C6Smiley(QWidget *parent, const char *name,bool modal) : QDialog(parent,name,modal)
{
    C6Global &global = C6Global::getInstance();
    QString path = global.getSkinPath();

    setPaletteForegroundColor( QColor( 0, 0, 0 ) );
    setBackgroundOrigin( QDialog::WidgetOrigin );
    setFocusPolicy( QDialog::ClickFocus );
    setCaption("Smiley");

    QButtonGroup* smileyGroup = new QButtonGroup(this);
    smileyGroup->setFlat(true);

    C6PixmapCache &pix = C6PixmapCache::getInstance();
        
    for (int i=0; i < MAXFACCINEDIALOG; i++)
    {
        QPixmap const &tmp = pix.getPixmap(path+"/smiley/"+smiley[i].fname);
        QPushButton* but = new QPushButton(tmp,"",this);
#if defined(Q_OS_MACX) || defined(Q_OS_DARWIN) 
        but->setFlat(true);
#endif
        but->setGeometry((i % 6)*(tmp.width()+ICONBORDER)+HBORDER/2,(i/6)*(tmp.height()+ICONBORDER)+VBORDER/2+2,
                          tmp.width()+ICONBORDER,tmp.height()+ICONBORDER);
        smileyGroup->insert(but,i);
        QToolTip::add(but,smiley[i].text);
        connect(smileyGroup,SIGNAL(clicked(int)),this,SLOT(whichSmiley(int)));
    }

    QPixmap const &tmp = pix.getPixmap(path+"/smiley/"+smiley[0].fname);    
    int hsize = MAXCOLUMNFACCINE*(tmp.width()+ICONBORDER)+HBORDER;
    int vsize = (MAXFACCINEDIALOG / MAXCOLUMNFACCINE)*(tmp.height()+ICONBORDER)+VBORDER;

    smileyGroup->resize(QSize(hsize,vsize));
    setMinimumSize( QSize( hsize, vsize) );
    setMaximumSize( QSize( hsize, vsize) );

    clicked = false;
}
C6Smiley::~C6Smiley()
{
}
/** No descriptions */
void C6Smiley::whichSmiley(int id)
{
    clicked = true;
    done(id);
}
/** No descriptions */
void C6Smiley::closeEvent ( QCloseEvent * e )
{
    if (!clicked)
        setResult(NORESULT);

    e->accept();
}
/** No descriptions */
QString C6Smiley::getSmileyText(int id)
{
    return(smiley[id].text);
}

void C6Smiley::loadSmiley()
{
    C6Global &global = C6Global::getInstance();
    QString path = global.getSkinPath();
    Q_ASSERT(path != "");
    
    C6PixmapCache &pix = C6PixmapCache::getInstance();    
    
    for (int i=0;i < MAXFACCINE; i++)
    {
        QPixmap const &tmp = pix.getPixmap(path+"/smiley/"+smiley[i].fname);
        QMimeSourceFactory::defaultFactory()->setPixmap(smiley[i].text,tmp);
    }
}
void C6Smiley::leaveEvent ( QEvent * e)
{
    done(NORESULT);
}
