//
// C++ Implementation: c6tabwidget
//
// Description:
//
//
// Author: Giorgio A. <openc6@hotmail.com>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "c6tabwidget.h"
#include "c6pixmapcache.h"
#include "c6global.h"
#include <qpopupmenu.h>
#include <qcursor.h>
#include <qpixmap.h>
#include <qiconset.h>

static const QPixmap & getProperIcon(C6Users::C6USER_STATUS status)
{
    QPixmap *pixmap = 0;
    C6PixmapCache &pix = C6PixmapCache::getInstance();
    QString path = C6Global::getInstance().getSkinPath();

    switch(status)
    {
    case C6Users::U_AVAILABLE:
        pixmap = const_cast<QPixmap*>(&pix.getPixmap(path+"Contact_green_mini.png"));
        break;
    case C6Users::U_AWAY:
        pixmap =  const_cast<QPixmap*>(&pix.getPixmap(path+"Contact_away_mini.png"));
        break;
    case C6Users::U_BUSY:
        pixmap =  const_cast<QPixmap*>(&pix.getPixmap(path+"Contact_busters_mini.png"));
        break;
    case C6Users::U_NETFRIENDONLY:
        pixmap =  const_cast<QPixmap*>(&pix.getPixmap(path+"Contact_block_mini.png"));
        break;
    case C6Users::U_OFFLINE:
        pixmap =  const_cast<QPixmap*>(&pix.getPixmap(path+"Contact_off_mini.png"));
        break;
    case C6Users::U_NOTPRESENT:
        pixmap =  const_cast<QPixmap*>(&pix.getPixmap(path+"Contact_off_mini.png"));
        break;
    default:
        break;
    }

    return(const_cast<QPixmap&>(*pixmap));
}

TabBar::TabBar( QWidget * parent, const char * name) : QTabBar(parent,name)
{}

void TabBar::contextMenuEvent (QContextMenuEvent *e)
{
    C6PixmapCache &pix = C6PixmapCache::getInstance();
    C6Global &global = C6Global::getInstance();
    QString path = global.getSkinPath();

    QPopupMenu* contextMenu = new QPopupMenu( this );
    Q_CHECK_PTR(contextMenu );

    contextMenu->insertItem(pix.getPixmap(path+"chat_termina_over.png"),"Chiudi",
                            this,SLOT(closeTab()));
    contextMenu->exec( QCursor::pos() );
    delete contextMenu;
}

void TabBar::closeTab()
{
    emit signalCloseTab(indexOf(currentTab()));
}

C6TabWidget::C6TabWidget ( QWidget * parent, const char * name, WFlags f) :
        QTabWidget(parent,name,f)
{
    _tabBar = new TabBar(parent);

    setTabBar(_tabBar);
    setTabShape(QTabWidget::Rounded);
    connect(_tabBar,SIGNAL(signalCloseTab(int)),this,SLOT(slotCloseTab(int)));
    connect(_tabBar,SIGNAL(selected(int)),this,SLOT(slotSelected(int)));
}

C6TabQWidget::C6TabQWidget(QWidget *parent, const char *name)
        : QWidget(parent, name)
{
    C6PixmapCache &pix = C6PixmapCache::getInstance();
    C6Global &global = C6Global::getInstance();
    QString path = global.getSkinPath();

    setIcon(pix.getPixmap(path+"icon16x16.png"));
    setPaletteBackgroundColor(QColor("white"));
}

C6TabQWidget::~C6TabQWidget()
{}

void C6TabQWidget::closeEvent(QCloseEvent *e)
{
    emit closeTabWidget();
    e->accept();
}

void C6TabWidget::slotCloseTab(int tabno)
{
    emit signalCloseTab(tabno);
}

void C6TabWidget::slotSelected(int tabno)
{
    emit signalSelected(tabno);
}

void C6TabWidget::addTabAndSetCurrent(QWidget const& widget,C6Users::C6USER_STATUS status,QString const &nick,bool setCurrent)
{
    addTab(const_cast<QWidget*>(&widget),nick);
    updateTabIcon(widget,status);

    if (setCurrent == true)
    {
        setCurrentPage(count()-1);
    }
}

void C6TabWidget::updateTabIcon(QWidget const& widget,C6Users::C6USER_STATUS status)
{
#if defined(Q_OS_MACX)
#if (QT_VERSION <= 0x030304)
    return;
#endif   
#endif
    QPixmap const &pix = getProperIcon(status);
    setTabIconSet(const_cast<QWidget*>(&widget),QIconSet(pix));
}

void C6TabWidget::changeTabName(QWidget const *widget,QString const & newName)
{
    changeTab(const_cast<QWidget*>(widget),newName);
}

#include "c6tabwidget.moc"
