//
// C++ Interface: c6tabwidget
//
// Description:
//
//
// Author: Giorgio A. <openc6@hotmail.com>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef C6TABWIDGET_H
#define C6TABWIDGET_H

#include <qwidget.h>
#include <qtabwidget.h>
#include <qtabbar.h>
#include <qiconset.h>
#include "c6users.h"

class QCloseEvent;
class QPopupMenu;

/**
@author Giorgio A.
*/
class C6TabQWidget : public QWidget
{
    Q_OBJECT
public:
    C6TabQWidget(QWidget *parent = 0, const char *name = 0);

    ~C6TabQWidget();
    void closeEvent(QCloseEvent *e);
signals:
    void closeTabWidget();
};

class TabBar : public QTabBar
{
    Q_OBJECT
    public:
        TabBar ( QWidget * parent = 0, const char * name = 0 );

    private:
        virtual void contextMenuEvent (QContextMenuEvent *e);
       
    private slots:
        void closeTab();
        
    signals:
        void signalCloseTab(int tabno);
};

class C6TabWidget : public QTabWidget
{
    Q_OBJECT
    public:
        C6TabWidget ( QWidget * parent = 0, const char * name = 0, WFlags f = 0 );
        void addTabAndSetCurrent(QWidget const &widget,C6Users::C6USER_STATUS status,QString const &nick,bool setCurrent = false);
        void updateTabIcon(QWidget const& widget,C6Users::C6USER_STATUS status);
        void changeTabName(QWidget const * widget,QString const & newName);    
    private:
        TabBar* _tabBar;
        QIconSet _iconSet;
    private slots:
        void slotCloseTab(int tabno);
        void slotSelected(int tabno);
    signals:
        void signalCloseTab(int tabno);
        void signalSelected(int tabno);    
};

#endif
