//
// C++ Interface: c6textedit
//
// Description:
//
//
// Author: Giorgio A. <openc6@hotmail.com>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef C6TEXTEDIT_H
#define C6TEXTEDIT_H

class QString;

#include <qtextedit.h>
#include <qfont.h>
#include <qcursor.h>
#include <qdatetime.h>
#include "macroetc.h"
#include "c6smiley.h"

/**
@author Giorgio A.
*/
class C6TextEdit : public QTextEdit
{
    Q_OBJECT
public:
    C6TextEdit(QWidget *parent, int x,int y,int width,int height);
    ~C6TextEdit();
    void serviceMessage(QString mes,bool time = true);
    void showMyText(QString const &nick,QString const &text, bool time);
    void showOtherText(QString const & nick,QString const &text, bool time);
    QString processRichText(QString text);
    
private:
    void contentsMouseMoveEvent(QMouseEvent * e);
    void contentsMouseDoubleClickEvent(QMouseEvent * e);
    QString processEmail(QString const &text);
    
signals:
    void execUrl(QString &);
};

#endif
