/***************************************************************************
                          c6trayicon.cpp  -  description
                             -------------------
    begin                : Thu Jan 29 2004
    copyright            : (C) 2004 by Giorgio A.
    email                : openc6@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "c6trayicon.h"

#ifdef USE_KDE
#include "c6global.h"
#include "c6pixmapcache.h"
#include <kpopupmenu.h>
#include <qtimer.h>
#include <qpixmap.h>
#include <qtooltip.h>
#include <qsignal.h>


C6TrayIcon::C6TrayIcon(QPopupMenu *a,QWidget *parent, const char *name) : KSystemTray(parent,name)
{
    C6PixmapCache &pixmap = C6PixmapCache::getInstance();
    C6Global &global = C6Global::getInstance();
    QString path = global.getSkinPath();

    _trayNormal = const_cast<QPixmap*>(&pixmap.getPixmap(path+"systray.png"));
    _trayFlash =  const_cast<QPixmap*>(&pixmap.getPixmap(path+"mail_generic.png"));

    setPixmap(*_trayNormal);
    KPopupMenu *menu = contextMenu();
    menu->changeTitle(menu->idAt(0),pixmap.getPixmap(path+"icon16x16.png"),"OpenC6");
    menu->insertItem("Menu",a);
    flashing = false;

    QString text ="Ad icona lampeggiante un click del pulsante destro mostra un popup con tutti i messaggi in arrivo \n";
    text+="Ad icona lampeggiante un doppio click del pulsante sinistro mostra l'ultimo messaggio ricevuto";
    QToolTip::add(this,text);

    msgIncomingClicked = new QSignal(this);
    msgIncomingDoubleClicked = new QSignal(this);
}

C6TrayIcon::~C6TrayIcon()
{
    delete _trayNormal;
    delete _trayFlash;
}

void C6TrayIcon::flashTrayIconStart()
{
    trayIconStatus = false;
    flashing = true;
}

void C6TrayIcon::flashTrayIconStop()
{
    setPixmap(*_trayNormal);
    trayIconStatus = false;
    flashing = false;
}

void C6TrayIcon::trayTimerDone()
{
    trayIconStatus = !trayIconStatus;

    if (trayIconStatus)
    {      
        setPixmap(*_trayFlash);
    }      
    else
    {      
        setPixmap(*_trayNormal);
    }      
}

void C6TrayIcon::mouseDoubleClickEvent(QMouseEvent *e)
{
    if ((e->button() == QMouseEvent::LeftButton) && flashing)
    {
        e->accept();
        emit msgIncomingDoubleClicked->activate();
    }
}
void C6TrayIcon::mousePressEvent(QMouseEvent *e)
{
    if (e->button() == QMouseEvent::RightButton)
    {
        if (flashing)
        {
            e->accept();
            msgIncomingClicked->activate();
        }
        else
            KSystemTray::mousePressEvent(e);
    }
    else
        if (!flashing)
            KSystemTray::mousePressEvent(e);
}

bool C6TrayIcon::isFlashing()
{
    return(flashing);
}

void C6TrayIcon::connectIncomingClicked( QObject *receiver, const char *member )
{
    msgIncomingClicked->connect(receiver,member);
}

void C6TrayIcon::connectDoubleClicked( QObject *receiver, const char *member )
{
    msgIncomingDoubleClicked->connect(receiver,member);
}

#endif



