/***************************************************************************
                          c6trayicon.h  -  description
                             -------------------
    begin                : Thu Jan 29 2004
    copyright            : (C) 2004 by Giorgio A.
    email                : openc6@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef C6TRAYICON_H
#define C6TRAYICON_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwidget.h>

#ifdef USE_KDE
#include <ksystemtray.h>

class QSignal;
class QToolTip;
class QPopupMenu;
class QPixmap;
class QWidget;
class QObject;

/**
  *@author Giorgio A.
  */

class C6TrayIcon : public KSystemTray
{
public:
    C6TrayIcon(QPopupMenu *a,QWidget *parent=0, const char *name=0);
    ~C6TrayIcon();
    
    void flashTrayIconStart();
    void flashTrayIconStop();
    bool isFlashing();
    void connectIncomingClicked(QObject *receiver, const char *member );
    void connectDoubleClicked(QObject *receiver, const char *member );
    void trayTimerDone();
private:
    QPixmap* _trayNormal;
    QPixmap* _trayFlash;
    bool trayIconStatus;
    bool flashing;
    QToolTip *w;
    QSignal *msgIncomingClicked,*msgIncomingDoubleClicked;
protected:
    virtual void mouseDoubleClickEvent(QMouseEvent *e);
    virtual void mousePressEvent(QMouseEvent *e);
};


#endif
#endif
