/***************************************************************************
                          c6users.h  -  description
                             -------------------
    begin                : Mon Apr 14 2003
    copyright            : (C) 2003 by Giorgio A.
    email                : openc6@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef C6USERS_H
#define C6USERS_H

#include <qstring.h>
#include <qptrlist.h>
#include <vector>

/**
  *@author Giorgio A.
  */

class C6Users
{
public:

    typedef std::vector<C6Users> C6UsersVector;
    typedef QPtrList<C6Users> C6UsersList;

    enum  C6USER_STATUS
    {
        U_OFFLINE=0,
        U_NOTPRESENT,
        U_BUSY,
        U_AWAY,
        U_NETFRIENDONLY,
        U_AVAILABLE
    };

   private:
    QString _nick;
    QString _user;    
    C6USER_STATUS _status;
    bool _isMessaged;
    QString _dailyMessage;

public:
    C6Users(QString const &user, QString const & nick,C6USER_STATUS stat = U_OFFLINE):
            _user(user),
            _nick(nick),
            _status(stat),
            _isMessaged(false),
            _dailyMessage()                
    {}

    C6Users(QString const &user,QString const & nick,QString const & message,C6USER_STATUS stat = U_OFFLINE):
            _user(user),
            _nick(nick),
            _status(stat),
            _isMessaged(false),
            _dailyMessage(message)                
            {}            
            
    C6Users():
            _nick(),
            _user(),    
            _status(U_OFFLINE),
            _isMessaged(false),
            _dailyMessage()           
    {}

    C6Users operator=(C6Users &right);            
            
    void setMessaged(bool set)
    {
        _isMessaged = set;
    }

    bool isMessaged() const
    {
        return(_isMessaged);
    }

    const QString & getNick () const
    {
        return _nick;
    }

    C6USER_STATUS getStatus() const
    {
        return _status;
    }

    void setStatus(C6USER_STATUS stat)
    {
        _status = stat;
    }

    void setNick(QString const & nick)
    {
        _nick = nick;
    }
    
    void setUser(QString & user)
    {
        _user = user;
    }   

    QString const & getUser() const
    {
        return _user;
    }       
    
    bool isOnline()
    {
        return(isStatusOnline(_status));
    }

    void setDailyMessage(QString const & message)
    {
        _dailyMessage = message;
    }             
    
    const QString & getDailyMessage() const
    {
        return(_dailyMessage);     
    }             
    
    static bool isStatusOnline(C6USER_STATUS status);
 };

class C6Msg
{
private:
    QString time;
    QString nick;
    void *ptr;
    int counter;

public:
    C6Msg(QString t,QString n,void *p,long int count) : time(t), nick(n), ptr(p), counter(count)
    {}

    void update(QString const & t)
    {
        time = t;
        counter++;
    }

    const QString & getNick() const
    {
        return (nick);
    }

    void* getPtr() const
    {
        return(ptr);
    }

    int getCounter() const
    {
        return(counter);
    }

    const QString & getTime() const
    {
        return (time);
    }
};

#endif
