//
// C++ Interface: c6usersmanager
//
// Description:
//
//
// Author: Giorgio A. <openc6@hotmail.com>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef C6USERSMANAGER_H
#define C6USERSMANAGER_H

#include "c6users.h"
#include <qptrlist.h>
#include <qstringlist.h>
#include <qmap.h>

/**
@author Giorgio A.
*/


typedef QMap<QString,C6Users::C6UsersList> C6ListHash;
 
class C6UsersManager
{
    enum GROUP_TYPE
    {
        AMICI = 0,
        LISTA_NERA,
        LISTA_AUTORIZZATI,    
        GROUP_END        
    };             
       
public:
    C6UsersManager();
    ~C6UsersManager();

    void saveNetfriendList(QTextStream & stream);
    void addUser(QString const & group,QString const & user,QString const & nick);
    void addUser(QString const & group,QString const & nick);   
    void removeUser(QString const & nick);
    QStringList getGroupUsers(QString const &group);
    C6Users::C6UsersList& getC6UsersFromGroup(QString const &group);   
    void setAllUsersOffline();
    C6Users* getC6UserPtr(const QString &nick);
    QStringList getAllUsers();
    bool groupIsPresent(QString const &group);
    C6ListHash::Iterator addGroup(QString const &group);
    bool removeGroup(QString const &group);
    QStringList getAllGroups();
    /** check if nick is in black list  */
    bool isBlackListed(QString const & nick);
    bool renameGroup(const QString &oldname,const QString &newname);
   
    const QStringList getBlackListUsers();
    const QString getBlackListGroupName();   
    const QString getFriendListGroupName();
    const QString getWhiteListGroupName();   
    C6ListHash& getNetfriendList(); 
    const QString getUserGroupName(QString const &user);    
    void clear();   
    bool isTheBlackList(QString const &group); 
    void update(C6UsersManager& list);     
    void setWhiteList(QStringList const & list);
    void addToWhiteList(QString const &user,QString const &nick);
    void addToWhiteList(QString const &nick);   
    const QStringList getWhiteListUsers();
    void removeFromWhiteList(QString const & nick);
    bool isWhiteListed(QString const & nick);   
    
private:
    QStringList _netfriendType;
    C6ListHash _c6list;
    C6Users::C6UsersList _whiteList;    // need a different list from _c6list cause users can be in both
              
    
    const char* getDefaultInitialGroupString(GROUP_TYPE type);   
  
};

#endif
