//
// C++ Implementation: c6utils
//
// Description:
//
//
// Author: Giorgio A. <openc6@hotmail.com>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "c6utils.h"
#include "c6logger.h"
#include "c6settings.h"
#include <stdio.h>

#define C6DEBUG
#define PROTO_SIG "C6Utils"

/** Dump a packet  */
void C6Utils::dumpPacket(const char *origin,unsigned char *data,int len)
{
  C6Logger &logger = C6Logger::getInstance();

  logger.debugPrint(origin,"\n Packet Dump begin len = [%d] bytes\n",len);

  if (C6Settings::getInstance().getProtoLog())
    {
      for (int i=0; i < len; i++)
        {
          printf("%02x ",data[i]);
        }

      printf("\n\n");

      for (int i=0; i < len; i++)
        {
          if ((data[i] >= 0x20) && (data[i] < 0x7f))
            {
              printf("%c",data[i]);
            }
          else
            {
              printf(".");
            }
        }
       printf("\n");  

    }

  logger.debugPrint(origin,"\n\n Packet Dump end\n");
}

bool C6Utils::safeByteRead(unsigned char* ptr,unsigned char *value,const unsigned char* maxPtr)
{
    bool canRead = false;
    *value = 0;
    if (maxPtr)
    {
        if (ptr <= maxPtr)
        {
            canRead = true;
            *value = *ptr;
        }
        else
        {
#ifdef C6DEBUG
            C6Logger::getInstance().debugPrint(PROTO_SIG,"byteRead: packet data out of bounds");
#endif

        }
    }
    else
    {
        C6Logger::getInstance().debugPrint(PROTO_SIG,"byteRead: maxPtr must be not zero");
    }
    return(canRead);
}

bool C6Utils::safeByteRead(unsigned char* ptr,int *value,const unsigned char* maxPtr)
{
    unsigned char tmp=0;
    bool canRead = safeByteRead(ptr,&tmp,maxPtr);
    *value = tmp;
    return(canRead);
}

bool C6Utils::safeShortRead(unsigned char* ptr,int *value,const unsigned char* maxPtr)
{
    bool canRead = false;
    *value = 0;

    if (maxPtr)
    {
        if (ptr+1 <= maxPtr)
        {
            canRead = true;
            *value = (((int)*(ptr)) << 8) | (int)(*(ptr+1));
        }
        else
        {
#ifdef C6DEBUG
            C6Logger::getInstance().debugPrint(PROTO_SIG,"wordRead: packet data of of bounds");
#endif
        }
    }
    else
    {
#ifdef C6DEBUG      
        C6Logger::getInstance().debugPrint(PROTO_SIG,"wordRead: maxPtr must be not zero");
#endif       
    }

    return(canRead);
}

bool C6Utils::safeIntRead(unsigned char* ptr,int *value,const unsigned char* maxPtr)
{
    bool canRead = false;
    *value = 0;

    if (maxPtr)
    {
        if (ptr+3 <= maxPtr)
        {
            canRead = true;
            int lo;
            int hi;
                    
            safeShortRead(ptr,&hi,maxPtr);    
            safeShortRead(ptr+2,&lo,maxPtr); 
            *value = (hi << 16) | lo;            
        }
        else
        {
#ifdef C6DEBUG
            C6Logger::getInstance().debugPrint(PROTO_SIG,"safeIntRead: packet data of of bounds");
#endif
        }
    }
    else
    {
#ifdef C6DEBUG      
        C6Logger::getInstance().debugPrint(PROTO_SIG,"safeIntRead: maxPtr must be not zero");
#endif       
    }

    return(canRead);
}


bool C6Utils::safeStringCopy(unsigned char* dest,unsigned char* source,int len,const unsigned char* maxPtr)
{
    bool canRead = false;

    memset(dest,0,len);

    if (maxPtr)
    {
        if (source+len-1 <= maxPtr)
        {
            canRead = true;
            memcpy(dest,source,len);
        }
        else
        {
#ifdef C6DEBUG
            C6Logger::getInstance().debugPrint(PROTO_SIG,"stringCopy: packet data of of bounds");
#endif

        }
    }
    else
    {
#ifdef C6DEBUG      
        C6Logger::getInstance().debugPrint(PROTO_SIG,"stringCopy: maxPtr must not be zero");
#endif
    }

    return(canRead);
}

