//
// C++ Interface: c6xcapclient
//
// Description:
//
//
// Author: Giorgio A. <openc6@hotmail.com>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef C6XCAPCLIENT_H
#define C6XCAPCLIENT_H

#include <qobject.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qcstring.h>
#include <qhttp.h>
#include <qmap.h>

class C6HttpConnection;
typedef QMap<QString,QStringList> XCAPListType;

/**
@author Giorgio A.
*/
class C6XCAPClient : public QObject
{
    Q_OBJECT
public:
    
    enum AUTH_MODE
    {
        UNDEFINED_AUTH = -1,    
        ALL,
        WHITE    
    };   
       
    enum CONFIG_MODE
    {
        UNDEFINED_CONFIG = -1,    
        NOWARN,
        WARN,
        PERMISSION                 
    };              
    
    enum OFFLINE_MODE
    {
        UNDEFINED_OFFLINE = -1,    
        EMAIL,
        REPORT        
    };             
    
    enum XCAP_STATE
    {
        XCAP_REQUEST_LIST_STATE = 0,
        XCAP_AUTH_STATE,
        XCAP_CONFIG_STATE,
        XCAP_ADD_BUDDY_STATE,
        XCAP_ADD_BUDDY_WHITE_LIST_STATE,
        XCAP_ADD_BUDDY_BLACK_LIST_STATE,    
        XCAP_ADD_GROUP_LIST_STATE,      
        XCAP_REMOVE_BUDDY_STATE,  
        XCAP_REMOVE_GROUP_STATE,        
        XCAP_AUTH_CONFIG_STATE,    
        XCAP_STEADY_STATE,
        XCAP_BUDDY_INIT,
        XCAP_AUTH_INIT, 
        XCAP_CONFIG_INIT,                    
        XCAP_UNDEFINED_STATE    
    };

         
    
    C6XCAPClient();
    ~C6XCAPClient();
    
    void setUserPassword(QString const &user,QString const &password);   
    void requestBuddyList();
    void addBuddy(QString const &group,QString const &nick);
    void addBuddyToBlackList(QString const &nick);   
    void removeBuddy(QString const &group,QString const &nick);
    void removeBuddyFromBlackList(QString const &nick);   
    void setUserPassword(QString const nick);
    void setXCAPState(XCAP_STATE state);
    QString getEntryString(QString const & user);
    QString getListString(QString const &group,QString const & entry);
    void addBuddyList(QString const &group,QStringList const &nick);
    void addGroup(QString const & group);
    void removeGroup(QString const & group);
    void renameGroup(QString const &oldGroup,QString const &newGroup);
    void setConfiguration(CONFIG_MODE mode);
    void setOfflineMessage(OFFLINE_MODE mode);      
    QString getConfigurationMode(CONFIG_MODE mode);
    QString getOfflineMode(OFFLINE_MODE mode);   
    int getConfigurationModeValue(QString mode);
    int getOfflineModeValue(QString mode);
    void initBuddyList();   
    void initAuthorization();
    void initConfiguration();
    void setBuddyLists(XCAPListType list,QStringList const& blacklist,QStringList const& whitelist,CONFIG_MODE mode);   
    void addBuddyToWhiteList(QString const &);
    void removeBuddyFromWhiteList(QString const & nick);   
    
private:
    
    enum LIST_TYPE 
    {
       WHITE_LIST,
       BLACK_LIST         
    };             
    
    C6HttpConnection* _buddyRequest;
    XCAP_STATE _xcapState;
    QString _currentUser;
    QString _base64user;
    
    void checkForXCAPError(QByteArray &data);
    void requestBuddyAuth();
    void requestBuddyClientConfig();
    void setCommonHeader(QHttpRequestHeader &header);   
    void setBuddyList(QString const &xmlPayload);   
   
private slots:
    void buddyRequestReady(const QString& filename,C6HttpConnection*);

signals:
    void buddyListReady(QByteArray &data);
    void buddyAuthReady(QByteArray &data);
    void buddyConfigReady(QByteArray &data);   
    void xcapResponseOK(C6XCAPClient::XCAP_STATE status);
private:
    void initAuthorization(QStringList const &black,QStringList const &white,CONFIG_MODE mode);
    QString getConfigurationModeString(CONFIG_MODE mode);
    void addBuddyToList(LIST_TYPE type,QString const & nick);
    void removeBuddyFromList(LIST_TYPE type,QString const & nick);
};

#endif
