/***************************************************************************
                          chatview.h  -  description
                             -------------------
    begin                : Tue Mar 25 2003
    copyright            : (C) 2003 by Giorgio A.
    email                : openc6@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CHATVIEW_H
#define CHATVIEW_H

class C6TextEdit;
class QPopupMenu;
class C6Button;
class QString;
class C6XferProto;
class C6XferServer;
class QWidget;
class QHostAddress;
class C6HttpConnection;
class QColor;
class C6MessageStyle;

#include "chat.h"
#include "c6users.h"
#include "c6proto.h"

/**
  *@author Giorgio A.
  */

class ChatView : public Chat
{
    Q_OBJECT
public:
    ChatView();
    ~ChatView();
    /** update the chat area */

    void updateOtherText(QString & nick,QString & text,C6Proto::C6MessageStyle* inStyle=0);
    void ResetChat();
   
    void setMyNick(QString const & nick);

    void startTransfer(QHostAddress ip,int port,QString const & filename);
    bool isReceiveOn();
    int getServerPort();
    void setReceive(bool state);
    void activateFileServer(QString const &ip=QString::null,int port=0);
    void serviceMessage(QString mess);
    void takeFocus();
    virtual void show();
    bool getFocus();   
    QString getOtherNick() const;
    bool canRaise() const; 
    bool isOnline() const;
    void setOnlineStatus(bool status);
    QColor& getCurrentWritingColor(); 
    void setMessaged(bool set);
    bool isMessaged() const;
    void setFriendNick(QString const &nick);
    void setFileTransferReceivePort(int port);
    void setOtherClientInfo(unsigned char* data,int len);
    bool isBoldToggled();
    bool isItalicToggled();
    bool isUnderlineToggled();
    int getCurrentFontNo() const;
    int getCurrentFontSizePt() const;
    void rebuildFontAndColor();
    void setCustomFont();      
    
private: // Private methods
    void updateMyText(QString const & nick,QString const & text);
    bool Switch(bool state);
    void closeEvent(QCloseEvent *e);
    void windowActivationChange(bool prev);
    void closeTransferSocket(C6XferProto **socket);
    void requestPictureFromWeb();
    void setMyChatFontAndColor();
    QString setLocalTextAttribute(QString const & text);
    QString setRemoteTextAttribute(QString const & text,C6Proto::C6MessageStyle* inStyle);    
    
    C6TextEdit *otherChat;
    C6Button *exitButton;
    C6Button *sendButton;
    QString otherNick;
    QString myNick;
    QString transmitFileName;
    QString receiveFileName;
    C6XferProto *xferSocket;
    C6XferProto* _receiveSocket;    
    int transmitLocalProgress;
    int serverPort;
    int _receiveLocalProgress;
    int curIndex;
    long int receiveFileSize;
    bool xferOnSwitch;
    C6XferServer *xferServer;
    int localX;
    int localY;
    bool _canRaise;
    bool _isOnline;
    bool _firstShow;
    bool _isMessaged;    
    bool _scheduledClose;    
    C6HttpConnection *_httpData; 
    int _clientVersion;    
    bool _receiveFileStarted;    
    bool _transmitFileStarted;   
    bool _boldToggled;
    bool _italicToggled;
    bool _underlineToggled;      
    QColor _currentWritingColor;    
    int _currentFontNo;
    int _currentFontSizePt;        
    
private slots: // Private slots
    void IsReturnPressed();
    /** Close chat win */
    void closeChat();
    /** handle the send button */
    void SendChat();
    void specialChatNotify(QString nick,C6Users::C6USER_STATUS status);
    void xferSocket_Error(int);
    void receiveSocketError(int);   
    void xferSocket_connectionClosed();
    void receiveSocketConnectionClosed();   
    void xferAborted();
    void receiveAborted();   
    void xferProgress(int progress);
    void receiveProgress(int progress);
    void receiveFileSpec(QString &name,long int size);
    void getLastCursorPos(int para,int index);
    void execUrlProc(QString &);
    void fileButtonClicked();
    void profileClicked();
    void addToListClicked();
    void autoRaiseClicked();
    void smileyButtonClicked();
    void logButtonClicked();
    void soundButtonClicked();
    void stopTransmitButtonClicked();
    void stopReceiveButtonClicked();
    void requestPictureDone(const QString& filename,C6HttpConnection*);
    void receiveSwitchSlot(bool);   
    void aboutClicked();
    void slotGateway(const QString& ip,int port);    
        
signals: // Signals
    /** add nick to list signal */
    void AddThisNick(QString);
    void AddNickFromChat(QString & ,QString & );
    void SaveConversation();
    void Append2Log(QString &,QString &,QString &);
    void showUserProfile(const QString& nick,bool full);
    void SignalMenuCommand(int);
    void ShowUserLog(QString);
    void xferOn(void *obj);
    void messageSent();
    void sendFile(QString,QString,int);
    void chatIsActive(ChatView *);
    void removeChatFromList(const QString &nick);
    void sendChatMessage(QString& nick,bool isOnline,QString &);
    void execUrl(QString&);
    void showAbout();   
    void signalGateway(const QString& ip,int port,const QString &nickToGrant);      
    void acceptReception(bool accept,const QString & from);   
    void acceptAuthorization(bool accept,const QString & from);      
private slots:
    void boldButtonClicked();
    void italicButtonClicked();
    void underlineButtonClicked();
    void colorButtonClicked();
    void fontButtonClicked();
};

#endif
