/***************************************************************************
                          progressindicator.cpp  -  description
                             -------------------
    begin                : Wed Apr 2 2003
    copyright            : (C) 2003 by Giorgio A.
    email                : openc6@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "progressindicator.h"
#include <qprogressbar.h>
#include <qfont.h>
#include "c6global.h"

ProgressIndicator::ProgressIndicator(QWidget *parent, const char *name ) :
        ConnectDlg(parent,name)
{
    progressBar->setProgress(0);
    setCustomFont();   
}
ProgressIndicator::~ProgressIndicator()
{}

void ProgressIndicator::closeEvent(QCloseEvent *e)
{
    e->accept();
    emit forceClose();
    deleteLater();
}

void ProgressIndicator::setProgress(int value)
{
    progressBar->setProgress(value);

    if (value >=100)
    {
        deleteLater();
    }
}

void ProgressIndicator::setCustomFont()
{
    C6Global &global = C6Global::getInstance();
    QFont lfont(global.getBaseFont());
    int size = lfont.pointSize()-1;
    if (size > 2)
    {        
        lfont.setPointSize(size);
        setFont(lfont);
    }   
}
