#!/bin/sh

config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

PRIVOXY_USER=privoxy
PRIVOXY_GROUP=privoxy

# crea nuovi utenti e gruppi
userdel $PRIVOXY_USER
groupdel $PRIVOXY_GROUP
groupadd -g 7777 $PRIVOXY_GROUP
useradd -g $PRIVOXY_GROUP  -u 7777 -d /no/home -s /bin/false -c "Privoxy User" $PRIVOXY_USER
#groupadd $PRIVOXY_GROUP
#useradd -g $PRIVOXY_GROUP -d /no/home -s /bin/false -c "Privoxy User" $PRIVOXY_USER

config etc/privoxy/config.new
config etc/privoxy/user.action.new
config etc/privoxy/user.filter.new
config etc/rc.d/rc.privoxy.new

###
# Use rc.local to start privoxy at boot.
###

# if rc.privoxy is executable, run it on startup
run=`grep ". /etc/rc.d/rc.privoxy" etc/rc.d/rc.local`
if [[ "${run}" == "" ]]; then
cat << EOF >> etc/rc.d/rc.local

#privoxy
# To disable privoxy, chmod rc.privoxy to 644
if [ -x /etc/rc.d/rc.privoxy ]; then
	sh /etc/rc.d/rc.privoxy start
fi
EOF
fi
