/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.blowfishj;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import net.sourceforge.blowfishj.BlowfishCBC;
import net.sourceforge.blowfishj.SHA1;

public class BlowfishInputStream
extends InputStream {
    PushbackInputStream m_is;
    BlowfishCBC m_bfc;
    byte[] m_buf;
    int m_nBufPos;
    int m_nBufCount;

    void init(byte[] key, int nOfs, int nLen, InputStream is) throws IOException {
        this.m_nBufCount = 0;
        this.m_nBufPos = 0;
        this.m_is = new PushbackInputStream(new BufferedInputStream(is));
        SHA1 sh = new SHA1();
        sh.update(key, nOfs, nLen);
        sh.finalize();
        byte[] ckey = sh.getDigest();
        this.m_bfc = new BlowfishCBC(ckey, 0, ckey.length, 0L);
        this.m_buf = new byte[8];
        int nC = this.m_buf.length;
        for (int nI = 0; nI < nC; ++nI) {
            int nVal = this.m_is.read();
            if (-1 == nVal) {
                throw new IOException("truncated stream, IV is missing");
            }
            this.m_buf[nI] = (byte)nVal;
        }
        this.m_bfc.setCBCIV(this.m_buf, 0);
    }

    void fillBuffer() throws IOException {
        int nVal;
        int nI;
        int nC = this.m_buf.length;
        for (nI = 0; nI < nC; ++nI) {
            nVal = this.m_is.read();
            if (-1 == nVal) {
                throw new IOException("truncated stream, unexpected end");
            }
            this.m_buf[nI] = (byte)nVal;
        }
        this.m_bfc.decrypt(this.m_buf, 0, this.m_buf, 0, this.m_buf.length);
        nVal = this.m_is.read();
        if (-1 == nVal) {
            nC = this.m_buf[this.m_buf.length - 1];
            if (nC > this.m_buf.length || 0 > nC) {
                throw new IOException("unknown padding value detected");
            }
            for (nI = this.m_nBufCount = this.m_buf.length - nC; nI < this.m_buf.length; ++nI) {
                if (this.m_buf[nI] == (byte)nC) continue;
                throw new IOException("invalid padding data detected");
            }
            this.m_bfc.cleanUp();
            this.m_bfc = null;
        } else {
            this.m_is.unread(nVal);
            this.m_nBufCount = this.m_buf.length;
        }
        this.m_nBufPos = 0;
    }

    public BlowfishInputStream(byte[] key, int nOfs, int nLen, InputStream is) throws IOException {
        this.init(key, nOfs, nLen, is);
    }

    public BlowfishInputStream(String sPassPhrase, InputStream is) throws IOException {
        int nC = sPassPhrase.length();
        byte[] key = new byte[nC];
        for (int nI = 0; nI < nC; ++nI) {
            key[nI] = (byte)(sPassPhrase.charAt(nI) & 0xFF);
        }
        this.init(key, 0, nC, is);
    }

    public int read() throws IOException {
        while (this.m_nBufCount <= this.m_nBufPos) {
            if (null == this.m_bfc) {
                return -1;
            }
            this.fillBuffer();
        }
        return this.m_buf[this.m_nBufPos++] & 0xFF;
    }

    public void close() throws IOException {
        this.m_is.close();
    }
}

