/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.blowfishj;

public class SHA1 {
    public static final int DIGEST_SIZE = 20;
    private int[] m_state = new int[5];
    private long m_lCount;
    private byte[] m_digestBits;
    private int[] m_block = new int[16];
    private int m_nBlockIndex;
    private static final String HEXTAB = "0123456789abcdef";
    private static final String SELFTEST_MESSAGE = "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq";
    private static final byte[] SELFTEST_DIGEST = new byte[]{-124, -104, 62, 68, 28, 59, -46, 110, -70, -82, 74, -95, -7, 81, 41, -27, -27, 70, 112, -15};

    public SHA1() {
        this.m_digestBits = new byte[20];
        this.reset();
    }

    public void clear() {
        int nI;
        for (nI = 0; nI < this.m_state.length; ++nI) {
            this.m_state[nI] = 0;
        }
        for (nI = 0; nI < this.m_digestBits.length; ++nI) {
            this.m_digestBits[nI] = 0;
        }
        for (nI = 0; nI < this.m_block.length; ++nI) {
            this.m_block[nI] = 0;
        }
        this.m_lCount = 0L;
        this.m_nBlockIndex = 0;
    }

    static final int rol(int nValue, int nBits) {
        return nValue << nBits | nValue >>> 32 - nBits;
    }

    final int blk0(int nI) {
        this.m_block[nI] = SHA1.rol(this.m_block[nI], 24) & 0xFF00FF00 | SHA1.rol(this.m_block[nI], 8) & 0xFF00FF;
        return this.m_block[nI];
    }

    final int blk(int nI) {
        int n = SHA1.rol(this.m_block[nI + 13 & 0xF] ^ this.m_block[nI + 8 & 0xF] ^ this.m_block[nI + 2 & 0xF] ^ this.m_block[nI & 0xF], 1);
        this.m_block[nI & 0xF] = n;
        return n;
    }

    final void r0(int[] data, int nV, int nW, int nX, int nY, int nZ, int nI) {
        int n = nZ;
        data[n] = data[n] + ((data[nW] & (data[nX] ^ data[nY]) ^ data[nY]) + this.blk0(nI) + 1518500249 + SHA1.rol(data[nV], 5));
        data[nW] = SHA1.rol(data[nW], 30);
    }

    final void r1(int[] data, int nV, int nW, int nX, int nY, int nZ, int nI) {
        int n = nZ;
        data[n] = data[n] + ((data[nW] & (data[nX] ^ data[nY]) ^ data[nY]) + this.blk(nI) + 1518500249 + SHA1.rol(data[nV], 5));
        data[nW] = SHA1.rol(data[nW], 30);
    }

    final void r2(int[] data, int nV, int nW, int nX, int nY, int nZ, int nI) {
        int n = nZ;
        data[n] = data[n] + ((data[nW] ^ data[nX] ^ data[nY]) + this.blk(nI) + 1859775393 + SHA1.rol(data[nV], 5));
        data[nW] = SHA1.rol(data[nW], 30);
    }

    final void r3(int[] data, int nV, int nW, int nX, int nY, int nZ, int nI) {
        int n = nZ;
        data[n] = data[n] + (((data[nW] | data[nX]) & data[nY] | data[nW] & data[nX]) + this.blk(nI) + -1894007588 + SHA1.rol(data[nV], 5));
        data[nW] = SHA1.rol(data[nW], 30);
    }

    final void r4(int[] data, int nV, int nW, int nX, int nY, int nZ, int nI) {
        int n = nZ;
        data[n] = data[n] + ((data[nW] ^ data[nX] ^ data[nY]) + this.blk(nI) + -899497514 + SHA1.rol(data[nV], 5));
        data[nW] = SHA1.rol(data[nW], 30);
    }

    void transform() {
        int[] dd = new int[]{this.m_state[0], this.m_state[1], this.m_state[2], this.m_state[3], this.m_state[4]};
        this.r0(dd, 0, 1, 2, 3, 4, 0);
        this.r0(dd, 4, 0, 1, 2, 3, 1);
        this.r0(dd, 3, 4, 0, 1, 2, 2);
        this.r0(dd, 2, 3, 4, 0, 1, 3);
        this.r0(dd, 1, 2, 3, 4, 0, 4);
        this.r0(dd, 0, 1, 2, 3, 4, 5);
        this.r0(dd, 4, 0, 1, 2, 3, 6);
        this.r0(dd, 3, 4, 0, 1, 2, 7);
        this.r0(dd, 2, 3, 4, 0, 1, 8);
        this.r0(dd, 1, 2, 3, 4, 0, 9);
        this.r0(dd, 0, 1, 2, 3, 4, 10);
        this.r0(dd, 4, 0, 1, 2, 3, 11);
        this.r0(dd, 3, 4, 0, 1, 2, 12);
        this.r0(dd, 2, 3, 4, 0, 1, 13);
        this.r0(dd, 1, 2, 3, 4, 0, 14);
        this.r0(dd, 0, 1, 2, 3, 4, 15);
        this.r1(dd, 4, 0, 1, 2, 3, 16);
        this.r1(dd, 3, 4, 0, 1, 2, 17);
        this.r1(dd, 2, 3, 4, 0, 1, 18);
        this.r1(dd, 1, 2, 3, 4, 0, 19);
        this.r2(dd, 0, 1, 2, 3, 4, 20);
        this.r2(dd, 4, 0, 1, 2, 3, 21);
        this.r2(dd, 3, 4, 0, 1, 2, 22);
        this.r2(dd, 2, 3, 4, 0, 1, 23);
        this.r2(dd, 1, 2, 3, 4, 0, 24);
        this.r2(dd, 0, 1, 2, 3, 4, 25);
        this.r2(dd, 4, 0, 1, 2, 3, 26);
        this.r2(dd, 3, 4, 0, 1, 2, 27);
        this.r2(dd, 2, 3, 4, 0, 1, 28);
        this.r2(dd, 1, 2, 3, 4, 0, 29);
        this.r2(dd, 0, 1, 2, 3, 4, 30);
        this.r2(dd, 4, 0, 1, 2, 3, 31);
        this.r2(dd, 3, 4, 0, 1, 2, 32);
        this.r2(dd, 2, 3, 4, 0, 1, 33);
        this.r2(dd, 1, 2, 3, 4, 0, 34);
        this.r2(dd, 0, 1, 2, 3, 4, 35);
        this.r2(dd, 4, 0, 1, 2, 3, 36);
        this.r2(dd, 3, 4, 0, 1, 2, 37);
        this.r2(dd, 2, 3, 4, 0, 1, 38);
        this.r2(dd, 1, 2, 3, 4, 0, 39);
        this.r3(dd, 0, 1, 2, 3, 4, 40);
        this.r3(dd, 4, 0, 1, 2, 3, 41);
        this.r3(dd, 3, 4, 0, 1, 2, 42);
        this.r3(dd, 2, 3, 4, 0, 1, 43);
        this.r3(dd, 1, 2, 3, 4, 0, 44);
        this.r3(dd, 0, 1, 2, 3, 4, 45);
        this.r3(dd, 4, 0, 1, 2, 3, 46);
        this.r3(dd, 3, 4, 0, 1, 2, 47);
        this.r3(dd, 2, 3, 4, 0, 1, 48);
        this.r3(dd, 1, 2, 3, 4, 0, 49);
        this.r3(dd, 0, 1, 2, 3, 4, 50);
        this.r3(dd, 4, 0, 1, 2, 3, 51);
        this.r3(dd, 3, 4, 0, 1, 2, 52);
        this.r3(dd, 2, 3, 4, 0, 1, 53);
        this.r3(dd, 1, 2, 3, 4, 0, 54);
        this.r3(dd, 0, 1, 2, 3, 4, 55);
        this.r3(dd, 4, 0, 1, 2, 3, 56);
        this.r3(dd, 3, 4, 0, 1, 2, 57);
        this.r3(dd, 2, 3, 4, 0, 1, 58);
        this.r3(dd, 1, 2, 3, 4, 0, 59);
        this.r4(dd, 0, 1, 2, 3, 4, 60);
        this.r4(dd, 4, 0, 1, 2, 3, 61);
        this.r4(dd, 3, 4, 0, 1, 2, 62);
        this.r4(dd, 2, 3, 4, 0, 1, 63);
        this.r4(dd, 1, 2, 3, 4, 0, 64);
        this.r4(dd, 0, 1, 2, 3, 4, 65);
        this.r4(dd, 4, 0, 1, 2, 3, 66);
        this.r4(dd, 3, 4, 0, 1, 2, 67);
        this.r4(dd, 2, 3, 4, 0, 1, 68);
        this.r4(dd, 1, 2, 3, 4, 0, 69);
        this.r4(dd, 0, 1, 2, 3, 4, 70);
        this.r4(dd, 4, 0, 1, 2, 3, 71);
        this.r4(dd, 3, 4, 0, 1, 2, 72);
        this.r4(dd, 2, 3, 4, 0, 1, 73);
        this.r4(dd, 1, 2, 3, 4, 0, 74);
        this.r4(dd, 0, 1, 2, 3, 4, 75);
        this.r4(dd, 4, 0, 1, 2, 3, 76);
        this.r4(dd, 3, 4, 0, 1, 2, 77);
        this.r4(dd, 2, 3, 4, 0, 1, 78);
        this.r4(dd, 1, 2, 3, 4, 0, 79);
        this.m_state[0] = this.m_state[0] + dd[0];
        this.m_state[1] = this.m_state[1] + dd[1];
        this.m_state[2] = this.m_state[2] + dd[2];
        this.m_state[3] = this.m_state[3] + dd[3];
        this.m_state[4] = this.m_state[4] + dd[4];
    }

    public void reset() {
        this.m_state[0] = 1732584193;
        this.m_state[1] = -271733879;
        this.m_state[2] = -1732584194;
        this.m_state[3] = 271733878;
        this.m_state[4] = -1009589776;
        this.m_lCount = 0L;
        this.m_nBlockIndex = 0;
    }

    public void update(byte bB) {
        int nMask = (this.m_nBlockIndex & 3) << 3;
        this.m_lCount += 8L;
        int n = this.m_nBlockIndex >> 2;
        this.m_block[n] = this.m_block[n] & ~(255 << nMask);
        int n2 = this.m_nBlockIndex >> 2;
        this.m_block[n2] = this.m_block[n2] | (bB & 0xFF) << nMask;
        ++this.m_nBlockIndex;
        if (this.m_nBlockIndex == 64) {
            this.transform();
            this.m_nBlockIndex = 0;
        }
    }

    public void update(byte[] data) {
        this.update(data, 0, data.length);
    }

    public void update(byte[] data, int nOfs, int nLen) {
        int nEnd = nOfs + nLen;
        while (nOfs < nEnd) {
            this.update(data[nOfs]);
            ++nOfs;
        }
    }

    public void update(String sData) {
        int nC = sData.length();
        for (int nI = 0; nI < nC; ++nI) {
            this.update((byte)(sData.charAt(nI) & 0xFF));
        }
    }

    public void finalize() {
        int nI;
        byte[] bits = new byte[8];
        for (nI = 0; nI < 8; ++nI) {
            bits[nI] = (byte)(this.m_lCount >>> (7 - nI << 3) & 0xFFL);
        }
        this.update((byte)-128);
        while (this.m_nBlockIndex != 56) {
            this.update((byte)0);
        }
        for (nI = 0; nI < bits.length; ++nI) {
            this.update(bits[nI]);
        }
        for (nI = 0; nI < 20; ++nI) {
            this.m_digestBits[nI] = (byte)(this.m_state[nI >> 2] >> (3 - (nI & 3) << 3) & 0xFF);
        }
    }

    public byte[] getDigest() {
        byte[] result = new byte[20];
        System.arraycopy(this.m_digestBits, 0, result, 0, 20);
        return result;
    }

    public int getDigest(byte[] buf, int nOfs) {
        System.arraycopy(this.m_digestBits, 0, buf, nOfs, 20);
        return 20;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer(40);
        for (int nI = 0; nI < 20; ++nI) {
            sbuf.append(HEXTAB.charAt(this.m_digestBits[nI] >>> 4 & 0xF));
            sbuf.append(HEXTAB.charAt(this.m_digestBits[nI] & 0xF));
        }
        return sbuf.toString();
    }

    public boolean selfTest() {
        SHA1 tester = new SHA1();
        tester.update(SELFTEST_MESSAGE);
        tester.finalize();
        byte[] digest = tester.getDigest();
        for (int nI = 0; nI < 20; ++nI) {
            if (digest[nI] == SELFTEST_DIGEST[nI]) continue;
            return false;
        }
        return true;
    }
}

