/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller;

import java.util.Locale;
import java.util.Vector;
import net.sourceforge.rssowl.controller.EventManager;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.MenuManager;
import net.sourceforge.rssowl.controller.ViewForm;
import net.sourceforge.rssowl.controller.thread.ImageLoader;
import net.sourceforge.rssowl.model.Channel;
import net.sourceforge.rssowl.model.ChannelImage;
import net.sourceforge.rssowl.util.DateParser;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.i18n.Dictionary;
import net.sourceforge.rssowl.util.shop.BrowserShop;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.StringShop;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ChannelInfo {
    private boolean additionalFeedInfos;
    private MenuItem copyItem;
    private Menu linkMenu;
    private Composite newsChannelInfo;
    private Label newsFeedTitle;
    private Composite newsFeedTitleHolder;
    private Composite newsHeaderHolderAll;
    Display display;
    EventManager eventManager;
    ViewForm newsChannelHeader;
    Channel rssChannel;

    public ChannelInfo(Display display, Composite composite, Channel channel, EventManager eventManager) {
        this.display = display;
        this.newsHeaderHolderAll = composite;
        this.rssChannel = channel;
        this.eventManager = eventManager;
        this.additionalFeedInfos = false;
        this.initComponents();
    }

    private void initComponents() {
        this.newsChannelHeader = new ViewForm(this.newsHeaderHolderAll, 0x800800);
        this.newsChannelHeader.setBackground(this.display.getSystemColor(1));
        this.newsChannelHeader.setLayoutData(new GridData(4, 1, true, false));
        this.newsFeedTitleHolder = new Composite(this.newsChannelHeader, 0);
        this.newsFeedTitleHolder.setBackground(PaintShop.grayViewFormColor);
        this.newsFeedTitleHolder.setLayout(LayoutShop.createGridLayout(1, 0, 3));
        this.newsFeedTitleHolder.setLayoutData(new GridData(768));
        this.newsFeedTitleHolder.setCursor(this.display.getSystemCursor(21));
        this.newsFeedTitleHolder.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDown(MouseEvent mouseEvent) {
                ChannelInfo.this.setShowChannelInfos(ChannelInfo.this.newsChannelHeader.getContent() == null);
            }
        });
        this.newsChannelHeader.setTopLeft(this.newsFeedTitleHolder, true);
        this.newsFeedTitle = new Label(this.newsFeedTitleHolder, 0x1000000);
        this.newsFeedTitle.setLayoutData(new GridData(0x1000000, 0x1000000, true, false));
        this.newsFeedTitle.setBackground(PaintShop.grayViewFormColor);
        this.newsFeedTitle.setFont(FontShop.textBoldFont);
        this.newsFeedTitle.setCursor(this.display.getSystemCursor(21));
        if (StringShop.isset(this.rssChannel.getTitle())) {
            this.newsFeedTitle.setText(StringShop.escapeAmpersands(this.rssChannel.getTitle()));
        }
        this.newsChannelInfo = new Composite(this.newsChannelHeader, 0);
        this.newsChannelInfo.setLayout(LayoutShop.createGridLayout(2, 5, 5, false));
        this.newsChannelInfo.setLayoutData(new GridData(768));
        this.newsChannelInfo.setBackground(this.display.getSystemColor(1));
        this.newsChannelInfo.setVisible(false);
        this.newsFeedTitle.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDown(MouseEvent mouseEvent) {
                ChannelInfo.this.setShowChannelInfos(ChannelInfo.this.newsChannelHeader.getContent() == null);
            }
        });
        this.setChannelInfos();
        if (!this.additionalFeedInfos) {
            Label label = new Label(this.newsChannelInfo, 0);
            label.setBackground(this.display.getSystemColor(1));
            label.setFont(FontShop.textFont);
            label.setLayoutData(new GridData(4, 1, true, false, 2, 1));
            label.setText(GUI.i18n.getTranslation("LABEL_NO_INFOS"));
        }
    }

    private void setChannelInfos() {
        Widget widget;
        Control control;
        Object object;
        if (this.rssChannel.getImage() != null) {
            object = this.rssChannel.getImage();
            this.additionalFeedInfos = true;
            control = new Label(this.newsChannelInfo, 0x1000000);
            control.setBackground(this.display.getSystemColor(1));
            control.setLayoutData(new GridData(0x1000000, 1, true, false, 2, 1));
            new ImageLoader((ChannelImage)object, (Label)control, this.newsHeaderHolderAll).start();
        }
        if (StringShop.isset(this.rssChannel.getDescription())) {
            this.additionalFeedInfos = true;
            object = new Label(this.newsChannelInfo, 0);
            ((Control)object).setBackground(this.display.getSystemColor(1));
            ((Control)object).setFont(FontShop.textFont);
            ((Control)object).setLayoutData(new GridData(1, 0x1000000, false, false));
            ((Label)object).setText(GUI.i18n.getTranslation("LABEL_DESCRIPTION") + ": ");
            control = new Text(this.newsChannelInfo, 2056);
            control.setBackground(this.display.getSystemColor(1));
            control.setFont(FontShop.textFont);
            control.setLayoutData(new GridData(4, 1, true, false));
            ((Text)control).setText(this.rssChannel.getDescription());
            control.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    ((Text)focusEvent.getSource()).setSelection(0);
                }
            });
        }
        if (StringShop.isset(this.rssChannel.getHomepage())) {
            this.additionalFeedInfos = true;
            object = new Label(this.newsChannelInfo, 0);
            ((Control)object).setBackground(this.display.getSystemColor(1));
            ((Control)object).setFont(FontShop.textFont);
            ((Control)object).setLayoutData(new GridData(1, 0x1000000, false, false));
            ((Label)object).setText(GUI.i18n.getTranslation("CHANNEL_INFO_HOMEPAGE") + ": ");
            control = new Text(this.newsChannelInfo, 2056);
            control.setBackground(this.display.getSystemColor(1));
            control.setForeground(PaintShop.linkColor);
            control.setFont(FontShop.textFont);
            control.setLayoutData(new GridData(4, 1, true, false));
            ((Text)control).setText(this.rssChannel.getHomepage());
            control.setCursor(this.display.getSystemCursor(21));
            control.setToolTipText(GUI.i18n.getTranslation("TOOLTIP_URLOPEN"));
            control.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    ((Text)focusEvent.getSource()).setSelection(0);
                }
            });
            this.linkMenu = new Menu(control);
            this.copyItem = new MenuItem(this.linkMenu, 0);
            this.copyItem.setText(GUI.i18n.getTranslation("POP_COPY"));
            if (!GlobalSettings.isMac()) {
                this.copyItem.setImage(PaintShop.iconCopy);
            }
            this.copyItem.addSelectionListener(new SelectionAdapter((Text)control){
                final /* synthetic */ Text val$newsFeedHomepage;
                {
                    this.val$newsFeedHomepage = text;
                }

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    String string = this.val$newsFeedHomepage.getSelectionCount() > 0 ? this.val$newsFeedHomepage.getSelectionText() : ChannelInfo.this.rssChannel.getHomepage();
                    ChannelInfo.this.eventManager.getClipBoard().setContents(new Object[]{string}, new Transfer[]{TextTransfer.getInstance()});
                }
            });
            if (GlobalSettings.useInternalBrowser() && !GlobalSettings.openBrowserExtern) {
                new MenuItem(this.linkMenu, 2);
                widget = new MenuItem(this.linkMenu, 0);
                ((MenuItem)widget).setText(GUI.i18n.getTranslation("POP_OPEN_EXTERN"));
                ((MenuItem)widget).addSelectionListener(new SelectionAdapter(){

                    @Override
                    public void widgetSelected(SelectionEvent selectionEvent) {
                        if (StringShop.isset(ChannelInfo.this.rssChannel.getHomepage())) {
                            BrowserShop.openLink(ChannelInfo.this.rssChannel.getHomepage());
                        }
                    }
                });
            }
            MenuManager.initMnemonics(this.linkMenu);
            control.setMenu(this.linkMenu);
            control.addMouseListener(new MouseAdapter((Text)control){
                final /* synthetic */ Text val$newsFeedHomepage;
                {
                    this.val$newsFeedHomepage = text;
                }

                @Override
                public void mouseUp(MouseEvent mouseEvent) {
                    if (mouseEvent.button == 1 && this.val$newsFeedHomepage.getSelectionCount() == 0 && StringShop.isset(this.val$newsFeedHomepage.getText())) {
                        ChannelInfo.this.eventManager.actionOpenURL(ChannelInfo.this.rssChannel.getHomepage());
                    }
                }
            });
        }
        object = this.rssChannel.getAvailableNewsChannelInfos();
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            this.additionalFeedInfos = true;
            widget = new Label(this.newsChannelInfo, 0);
            ((Control)widget).setBackground(this.display.getSystemColor(1));
            ((Control)widget).setFont(FontShop.textFont);
            ((Control)widget).setLayoutData(new GridData(1, 0x1000000, false, false));
            ((Label)widget).setText(GUI.i18n.getTranslation((String)((Vector)object).get(i)) + ": ");
            Text text = new Text(this.newsChannelInfo, 2056);
            text.setBackground(this.display.getSystemColor(1));
            text.setFont(FontShop.textFont);
            text.setLayoutData(new GridData(4, 1, true, false));
            if (((Vector)object).get(i).equals("CHANNEL_INFO_PUBDATE")) {
                if (this.rssChannel.getPubDateParsed() == null) {
                    text.setText(this.rssChannel.getPubDate());
                } else {
                    text.setText(DateParser.formatDate(this.rssChannel.getPubDateParsed(), true, true));
                }
            }
            if (((Vector)object).get(i).equals("CHANNEL_INFO_LASTBUILDDATE")) {
                if (this.rssChannel.getLastBuildDateParsed() == null) {
                    text.setText(this.rssChannel.getLastBuildDate());
                } else {
                    text.setText(DateParser.formatDate(this.rssChannel.getLastBuildDateParsed(), true, true));
                }
            }
            if (((Vector)object).get(i).equals("CHANNEL_INFO_MANAGINGEDITOR")) {
                text.setText(this.rssChannel.getManagingEditor());
            }
            if (((Vector)object).get(i).equals("CHANNEL_INFO_WEBMASTER")) {
                text.setText(this.rssChannel.getWebmaster());
            }
            if (((Vector)object).get(i).equals("CHANNEL_INFO_CATEGORY")) {
                text.setText(this.rssChannel.getCategory());
            }
            if (((Vector)object).get(i).equals("CHANNEL_INFO_DOCS")) {
                text.setText(this.rssChannel.getDocs());
            }
            if (((Vector)object).get(i).equals("CHANNEL_INFO_TTL")) {
                text.setText(this.rssChannel.getTtl());
            }
            if (((Vector)object).get(i).equals("CHANNEL_INFO_RSSVERSION")) {
                text.setText(this.rssChannel.getFormat());
            }
            if (((Vector)object).get(i).equals("CHANNEL_INFO_PUBLISHER")) {
                text.setText(this.rssChannel.getPublisher());
            }
            if (((Vector)object).get(i).equals("CHANNEL_INFO_LANGUAGE")) {
                if (this.rssChannel.getLanguage().split("-").length == 2) {
                    text.setText(new Locale(this.rssChannel.getLanguage().split("-")[0]).getDisplayLanguage(Dictionary.selectedLocale));
                } else {
                    text.setText(new Locale(this.rssChannel.getLanguage()).getDisplayLanguage(Dictionary.selectedLocale));
                }
            }
            if (((Vector)object).get(i).equals("CHANNEL_INFO_CREATOR")) {
                text.setText(this.rssChannel.getCreator());
            }
            if (((Vector)object).get(i).equals("CHANNEL_INFO_GENERATOR")) {
                text.setText(this.rssChannel.getGenerator());
            }
            if (!((Vector)object).get(i).equals("CHANNEL_INFO_UPDATE_PERIOD")) continue;
            if (this.rssChannel.getUpdateFrequency() != null) {
                text.setText(this.rssChannel.getUpdateFrequency() + " " + GUI.i18n.getTranslation("CHANNEL_INFO_UPDATE_FREQUENCY") + " (" + this.rssChannel.getUpdatePeriod() + ")");
                continue;
            }
            text.setText(this.rssChannel.getUpdatePeriod());
        }
        if (this.rssChannel.getCopyright() != null) {
            this.additionalFeedInfos = true;
            Label label = new Label(this.newsChannelInfo, 0);
            label.setBackground(this.display.getSystemColor(1));
            label.setFont(FontShop.textFont);
            label.setLayoutData(new GridData(1, 0x1000000, false, false));
            label.setText("Copyright: ");
            widget = new Text(this.newsChannelInfo, 2056);
            ((Control)widget).setBackground(this.display.getSystemColor(1));
            ((Control)widget).setFont(FontShop.textFont);
            ((Control)widget).setLayoutData(new GridData(4, 1, true, false));
            ((Text)widget).setText(this.rssChannel.getCopyright());
            ((Control)widget).addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    ((Text)focusEvent.getSource()).setSelection(0);
                }
            });
        }
    }

    void setShowChannelInfos(boolean bl) {
        this.newsChannelHeader.setContent(bl ? this.newsChannelInfo : null, true);
        this.newsChannelInfo.setVisible(bl);
        this.newsChannelHeader.redraw();
        this.newsChannelHeader.update();
        this.newsChannelInfo.layout();
        this.newsHeaderHolderAll.layout();
    }
}

