/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TreeSet;
import net.sourceforge.rssowl.controller.FavoritesTree;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.MessageBoxFactory;
import net.sourceforge.rssowl.controller.NewsTabFolder;
import net.sourceforge.rssowl.controller.NewsTable;
import net.sourceforge.rssowl.controller.NewsText;
import net.sourceforge.rssowl.controller.Quickview;
import net.sourceforge.rssowl.controller.TutorialBrowser;
import net.sourceforge.rssowl.controller.dialog.AboutDialog;
import net.sourceforge.rssowl.controller.dialog.BlogrollDialog;
import net.sourceforge.rssowl.controller.dialog.CategoryDialog;
import net.sourceforge.rssowl.controller.dialog.ConfirmDeleteDialog;
import net.sourceforge.rssowl.controller.dialog.FavoriteDialog;
import net.sourceforge.rssowl.controller.dialog.FeedDiscoveryDialog;
import net.sourceforge.rssowl.controller.dialog.FeedSearchDialog;
import net.sourceforge.rssowl.controller.dialog.ImportOPMLDialog;
import net.sourceforge.rssowl.controller.dialog.OpenFeedDialog;
import net.sourceforge.rssowl.controller.dialog.PreferencesDialog;
import net.sourceforge.rssowl.controller.dialog.SearchDialog;
import net.sourceforge.rssowl.controller.dialog.ToolBarDialog;
import net.sourceforge.rssowl.controller.dialog.ValidateFeedDialog;
import net.sourceforge.rssowl.controller.forms.Hyperlink;
import net.sourceforge.rssowl.controller.thread.AggregationLoader;
import net.sourceforge.rssowl.controller.thread.SettingsManager;
import net.sourceforge.rssowl.controller.thread.UpdateManager;
import net.sourceforge.rssowl.dao.Exporter;
import net.sourceforge.rssowl.dao.Importer;
import net.sourceforge.rssowl.dao.SettingsLoader;
import net.sourceforge.rssowl.dao.SettingsSaver;
import net.sourceforge.rssowl.model.Category;
import net.sourceforge.rssowl.model.Channel;
import net.sourceforge.rssowl.model.Favorite;
import net.sourceforge.rssowl.model.NewsItem;
import net.sourceforge.rssowl.model.TabItemData;
import net.sourceforge.rssowl.model.TableItemData;
import net.sourceforge.rssowl.model.TreeItemData;
import net.sourceforge.rssowl.util.CryptoManager;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.search.SearchDefinition;
import net.sourceforge.rssowl.util.shop.BlogShop;
import net.sourceforge.rssowl.util.shop.BrowserShop;
import net.sourceforge.rssowl.util.shop.FileShop;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.PrintShop;
import net.sourceforge.rssowl.util.shop.ProxyShop;
import net.sourceforge.rssowl.util.shop.RegExShop;
import net.sourceforge.rssowl.util.shop.StringShop;
import net.sourceforge.rssowl.util.shop.URLShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.jdom.JDOMException;

public class EventManager {
    static final int EDIT_ACTION_COPY = 1;
    static final int EDIT_ACTION_CUT = 0;
    static final int EDIT_ACTION_DELETE = 3;
    static final int EDIT_ACTION_PASTE = 2;
    static final int EDIT_ACTION_PROPERTIES = 5;
    static final int EDIT_ACTION_SELECTALL = 4;
    private Clipboard cb;
    private Display display;
    private FavoritesTree rssOwlFavoritesTree;
    private GUI rssOwlGui;
    private NewsTabFolder rssOwlNewsTabFolder;
    private NewsText rssOwlNewsText;
    private Quickview rssOwlQuickView;
    private Shell shell;
    ToolBarDialog toolBarDialog;

    public EventManager(Display display, Shell shell, GUI gUI) {
        this.display = display;
        this.shell = shell;
        this.rssOwlGui = gUI;
        this.cb = new Clipboard(display);
        this.syncControls();
    }

    public void actionAddToFavorites() {
        String string = "";
        String string2 = "";
        TabItemData tabItemData = (TabItemData)this.rssOwlNewsTabFolder.getNewsHeaderTabFolder().getSelection().getData();
        if (tabItemData.getUrl() != null) {
            string = tabItemData.getUrl();
        } else if (Category.getLinkForTitle(tabItemData.getTitle()) != null) {
            string = Category.getLinkForTitle(tabItemData.getTitle());
        }
        if (tabItemData.getTitle() != null) {
            string2 = tabItemData.getTitle();
        }
        if (tabItemData.isAggregatedCat()) {
            string = "";
            string2 = "";
        }
        this.actionAddToFavorites(string2, string);
    }

    public void actionAddToFavorites(String string, String string2) {
        this.actionNewFavorite(string2, string, this.rssOwlFavoritesTree.getSelectedCat());
    }

    public void actionAggregateAllCategories() {
        this.actionAggregateCategory(Category.getRootCategory(), SearchDefinition.NO_SEARCH, false);
    }

    public void actionAggregateCategory(boolean bl) {
        this.actionAggregateCategory(this.rssOwlFavoritesTree.getSelectedCat(), SearchDefinition.NO_SEARCH, bl);
    }

    public void actionCategoryToOPML() {
        this.actionCategoryToOPML(this.rssOwlFavoritesTree.getSelectedCat(this.rssOwlFavoritesTree.getTreePath(true)));
    }

    public void actionCategoryToOPML(Category category) {
        this.actionCategoryToOPML(category, category.getName() + ".opml");
    }

    public void actionCategoryToOPML(Category category, String string) {
        try {
            new Exporter().exportCategoryToOPML(category);
            FileShop.exportCategory(this.shell, string, new String[]{"*.opml", "*.xml", "*.*"});
        }
        catch (IOException iOException) {
            MessageBoxFactory.showError(this.shell, iOException);
        }
    }

    public void actionCloseCurrent() {
        this.rssOwlNewsTabFolder.closeCurrent();
    }

    public void actionCopyBlogrollXmlLocation() {
        Category category;
        for (category = this.rssOwlFavoritesTree.getSelectedCat(this.rssOwlFavoritesTree.getTreePath(true)); category != null && category.getParent().isBlogroll(); category = category.getParent()) {
        }
        if (category != null && StringShop.isset(category.getPathToBlogroll())) {
            this.cb.setContents(new Object[]{category.getPathToBlogroll()}, new Transfer[]{TextTransfer.getInstance()});
        }
    }

    public void actionCopyFavoritesXmlLocation() {
        TreeItemData treeItemData = (TreeItemData)this.rssOwlFavoritesTree.getFavoritesTree().getSelection()[0].getData();
        String string = treeItemData.getName();
        String string2 = Category.getLinkForTitle(string);
        if (string2 == null) {
            string2 = ((Favorite)this.rssOwlFavoritesTree.getSelectedCat(this.rssOwlFavoritesTree.getTreePath(true)).getFavorites().get(string)).getUrl();
        }
        this.cb.setContents(new Object[]{string2}, new Transfer[]{TextTransfer.getInstance()});
    }

    public void actionCustomizeToolBar() {
        if (this.toolBarDialog != null && WidgetShop.isset(this.toolBarDialog.getShell())) {
            this.toolBarDialog.getShell().forceActive();
            return;
        }
        if (!GlobalSettings.isToolBarShown) {
            this.rssOwlQuickView.setShowToolBar(true, false);
        }
        this.toolBarDialog = new ToolBarDialog(this.rssOwlQuickView, this.shell, GUI.i18n.getTranslation("POP_CUSTOMIZE_TOOLBAR"));
        if (this.toolBarDialog.open() == 0 && GUI.isAlive()) {
            boolean bl = false;
            String string = this.toolBarDialog.getToolBarItems();
            int n = this.toolBarDialog.getToolBarMode();
            boolean bl2 = this.toolBarDialog.isUseSmallIcons();
            if (!string.equals(GlobalSettings.toolBarItems) || n != GlobalSettings.toolBarMode || bl2 != GlobalSettings.useSmallIcons) {
                bl = true;
            }
            GlobalSettings.isToolBarShown = true;
            GlobalSettings.toolBarItems = string;
            GlobalSettings.toolBarMode = n;
            GlobalSettings.useSmallIcons = bl2;
            if (bl) {
                this.rssOwlQuickView.createToolBar();
                SettingsManager.getInstance().requestSave();
            }
        } else if (GUI.isAlive() && !GlobalSettings.isToolBarShown) {
            this.rssOwlQuickView.setShowToolBar(false, false);
        }
        this.toolBarDialog = null;
    }

    public void actionDeleteBlogroll() {
        int n = 0;
        if (GlobalSettings.confirmBlogrollDeletion) {
            n = new ConfirmDeleteDialog(this.shell, GUI.i18n.getTranslation("MESSAGEBOX_TITLE_CONFIRM_DELETE"), GUI.i18n.getTranslation("LABEL_DELETE_SUBSCRIPTION"), GUI.i18n.getTranslation("QUESTION_DEL_SUB"), 2).open();
        }
        if (n == 0) {
            Category category;
            for (category = this.rssOwlFavoritesTree.getSelectedCat(this.rssOwlFavoritesTree.getTreePath(true)); category != null && category.getParent().isBlogroll(); category = category.getParent()) {
                category.getParent().removeCategory(category.getName(), category.getParent());
            }
            if (category != null) {
                Category.getBlogrolls().remove(category.getPathToBlogroll());
                category.getParent().removeCategory(category.getName(), category.getParent());
            }
            TreeItem treeItem = this.rssOwlFavoritesTree.getFavoritesTree().getSelection()[0];
            while (treeItem.getParentItem() != null && ((TreeItemData)treeItem.getParentItem().getData()).isBlogroll()) {
                treeItem = treeItem.getParentItem();
            }
            treeItem.dispose();
            SettingsManager.getInstance().requestSave();
        }
    }

    public void actionDeleteCategory() {
        Object object;
        TreeItemData treeItemData = this.rssOwlFavoritesTree.getSelectedTreeItemData();
        int n = 0;
        if (treeItemData == null) {
            return;
        }
        if (GlobalSettings.confirmCategoryDeletion) {
            object = StringShop.printf(GUI.i18n.getTranslation("QUESTION_DEL_CAT"), new String[]{"%NAME%"}, new String[]{treeItemData.getName()});
            n = new ConfirmDeleteDialog(this.shell, GUI.i18n.getTranslation("MESSAGEBOX_TITLE_CONFIRM_DELETE"), GUI.i18n.getTranslation("LABEL_DELETE_CATEGORY"), (String)object, 1).open();
        }
        if (n == 0) {
            object = this.rssOwlFavoritesTree.getSelectedCat(this.rssOwlFavoritesTree.getTreePath(true));
            Category category = ((Category)object).getParent();
            category.removeCategory(((Category)object).getName(), category);
            if (WidgetShop.isset(((Category)object).getTreeItem())) {
                ((Category)object).getTreeItem().dispose();
            }
            if (GlobalSettings.useSystemTray() && GlobalSettings.showSystrayIcon) {
                boolean bl = this.rssOwlFavoritesTree.getTreeHasUnreadFavs();
                this.rssOwlGui.getRSSOwlSystray().setTrayItemState(bl);
            }
            SettingsManager.getInstance().requestSave();
        }
    }

    public void actionDeleteFavorite() {
        Object object;
        TreeItemData treeItemData = this.rssOwlFavoritesTree.getSelectedTreeItemData();
        int n = 0;
        if (treeItemData == null) {
            return;
        }
        if (GlobalSettings.confirmFavoriteDeletion) {
            object = StringShop.printf(GUI.i18n.getTranslation("QUESTION_DEL_FAV"), new String[]{"%NAME%"}, new String[]{treeItemData.getName()});
            n = new ConfirmDeleteDialog(this.shell, GUI.i18n.getTranslation("MESSAGEBOX_TITLE_CONFIRM_DELETE"), GUI.i18n.getTranslation("LABEL_DELETE_FAVORITE"), (String)object, 0).open();
        }
        if (n == 0) {
            object = this.rssOwlFavoritesTree.getSelectedCat(this.rssOwlFavoritesTree.getTreePath(true));
            ((Category)object).removeFavorite(treeItemData.getName(), true, true);
            if (treeItemData.getFavorite() != null) {
                CryptoManager.getInstance().removeItem(treeItemData.getFavorite().getUrl());
            }
            if (GlobalSettings.useSystemTray() && GlobalSettings.showSystrayIcon) {
                boolean bl = this.rssOwlFavoritesTree.getTreeHasUnreadFavs();
                this.rssOwlGui.getRSSOwlSystray().setTrayItemState(bl);
            }
            SettingsManager.getInstance().requestSave();
        }
    }

    public void actionDiscoverFeeds(String string) {
        new FeedDiscoveryDialog(string, GUI.i18n.getTranslation("MENU_FEED_DISCOVERY"), GUI.i18n.getTranslation("DIALOG_MESSAGE_ENTER_URL"), this.rssOwlGui).open();
    }

    public void actionEditBlogroll() {
        Category category;
        for (category = this.rssOwlFavoritesTree.getSelectedCat(this.rssOwlFavoritesTree.getTreePath(true)); category != null && category.getParent().isBlogroll(); category = category.getParent()) {
        }
        new BlogrollDialog(this.rssOwlGui, this.shell, GUI.i18n.getTranslation("DIALOG_EDIT_BLOGROLL_TITLE"), GUI.i18n.getTranslation("DIALOG_ADD_SUBSCRIPTION_MESSAGE"), category).open();
    }

    public void actionEditCategory() {
        Category category = this.rssOwlFavoritesTree.getSelectedCat(this.rssOwlFavoritesTree.getTreePath(true));
        CategoryDialog categoryDialog = new CategoryDialog(this.shell, GUI.i18n.getTranslation("DIALOG_EDIT_CATEGORY_TITLE"), GUI.i18n.getTranslation("DIALOG_ADD_CATEGORY_MESSAGE"), category.getName(), category.getParent());
        if (categoryDialog.open() == 0) {
            String string = categoryDialog.getCatName();
            if (category.getParent().editCategory(category.getName(), string)) {
                GlobalSettings.selectedTreeItem = category.toCatPath();
                this.rssOwlFavoritesTree.buildFavoritesTree();
                SettingsManager.getInstance().requestSave();
            } else {
                MessageBoxFactory.showMessage(this.shell, 40, GUI.i18n.getTranslation("MESSAGEBOX_TITLE_ATTENTION"), GUI.i18n.getTranslation("MESSAGEBOX_CAT_EXISTS") + "!");
            }
        }
    }

    public void actionEditFavorite() {
        Favorite favorite = this.rssOwlFavoritesTree.getSelectedFav();
        FavoriteDialog.isEditFavorite = true;
        FavoriteDialog favoriteDialog = new FavoriteDialog(favorite, this.shell, GUI.i18n.getTranslation("DIALOG_EDIT_FAVORITE_TITLE") + ": " + favorite.getTitle());
        if (favoriteDialog.open() == 0) {
            Favorite favorite2 = favoriteDialog.getUpdatedFavorite();
            String string = favorite.getTitle();
            String string2 = favorite.getUrl();
            String string3 = favorite2.getTitle();
            String string4 = favorite2.getUrl();
            if (!favorite.getRSSOwlCategory().toCatPath().equals(favorite2.getCatPath())) {
                favorite.getRSSOwlCategory().removeFavorite(string, false, true);
                this.rssOwlFavoritesTree.addFavorite(favorite2.getCatPath(), string4, string3, favorite2);
                this.rssOwlFavoritesTree.buildFavoritesTree();
            } else if (!string2.equals(string4) || !string.equals(string3)) {
                favorite.getRSSOwlCategory().editFavorite(favorite, favorite2);
                GlobalSettings.selectedTreeItem = favorite.getRSSOwlCategory().toCatPath() + "=;=" + favorite.getTitle();
                this.rssOwlFavoritesTree.buildFavoritesTree();
            } else {
                favorite2.clone(this.rssOwlFavoritesTree.getSelectedFav());
            }
            if (!string2.equals(string4)) {
                CryptoManager.getInstance().removeItem(string2);
            }
            if (ProxyShop.isUseProxy()) {
                this.actionSetProxyOnTreeItem(favorite2.isUseProxy());
            }
            SettingsManager.getInstance().requestSave();
        }
    }

    public void actionExportSettings(Shell shell) {
        try {
            new SettingsSaver(this.rssOwlGui).saveUserSettings(false);
            FileShop.exportUserSettings(shell);
        }
        catch (IOException iOException) {
            MessageBoxFactory.showError(this.shell, iOException);
        }
    }

    public void actionFavoriteToOPML() {
        Favorite favorite = this.rssOwlFavoritesTree.getSelectedFav();
        Category category = this.rssOwlFavoritesTree.getSelectedCat(this.rssOwlFavoritesTree.getTreePath(true));
        try {
            new Exporter().exportFavoriteToOPML(favorite, category);
            FileShop.exportCategory(this.shell, favorite.getTitle() + ".opml", new String[]{"*.opml", "*.xml", "*.*"});
        }
        catch (IOException iOException) {
            MessageBoxFactory.showError(this.shell, iOException);
        }
    }

    public void actionHandleTreeItemSelect() {
        this.rssOwlFavoritesTree.handleTreeItemSelect(true);
    }

    public void actionImportBlogroll() {
        new BlogrollDialog(this.rssOwlGui, this.shell, GUI.i18n.getTranslation("DIALOG_ADD_SUBSCRIPTION_TITLE"), GUI.i18n.getTranslation("DIALOG_ADD_SUBSCRIPTION_MESSAGE")).open();
    }

    public void actionImportOPML() {
        new ImportOPMLDialog(this.rssOwlGui, this.shell, GUI.i18n.getTranslation("MENU_IMPORT_OPML"), GUI.i18n.getTranslation("MESSAGEBOX_FILL_URL")).open();
    }

    public boolean actionImportSettings(Shell shell) {
        int n = -1;
        try {
            n = FileShop.importUserSettings(shell);
        }
        catch (IOException iOException) {
            MessageBoxFactory.showError(this.shell, iOException);
        }
        if (n == 1) {
            MessageBoxFactory.showMessage(this.shell, 8, GUI.i18n.getTranslation("MENU_IMPORT"), GUI.i18n.getTranslation("MESSAGEBOX_WRONG_IMPORT"));
        } else if (n == 0) {
            SettingsLoader settingsLoader = new SettingsLoader(this.rssOwlGui);
            this.rssOwlGui.updateCoreSettings(settingsLoader, true);
            this.rssOwlGui.updateUserSettings(settingsLoader, true);
            this.rssOwlGui.updateI18N();
            this.rssOwlGui.changeWindowLayout();
            FontShop.setFontForAll(this.rssOwlGui);
            MessageBoxFactory.showMessage(this.shell, 2, GUI.i18n.getTranslation("MESSAGEBOX_TITLE_ATTENTION"), GUI.i18n.getTranslation("MESSAGEBOX_IMPORT_SUCCESS"));
        }
        return n == 0;
    }

    public void actionMarkAllCategoriesRead() {
        Object object;
        Object object2;
        Category category = Category.getRootCategory();
        CTabItem cTabItem = this.rssOwlNewsTabFolder.getTabItem(category);
        if (cTabItem != null) {
            object2 = ((TabItemData)cTabItem.getData()).getNewsHeaderTable();
            if (WidgetShop.isset((Widget)object2)) {
                NewsTable.markAllRead((Table)object2);
            }
            object = ((TabItemData)cTabItem.getData()).getChannel();
            Enumeration enumeration = ((Channel)object).getItems().elements();
            while (enumeration.hasMoreElements()) {
                NewsItem newsItem = (NewsItem)enumeration.nextElement();
                newsItem.setRead(true);
            }
            this.rssOwlNewsTabFolder.updateTabItemStatus(cTabItem);
        }
        object2 = category.getSubCategories();
        object = ((Hashtable)object2).elements();
        while (object.hasMoreElements()) {
            this.actionMarkCategoryRead((Category)object.nextElement(), false);
        }
        if (GlobalSettings.useSystemTray() && GlobalSettings.showSystrayIcon) {
            this.rssOwlGui.getRSSOwlSystray().setTrayItemState(false);
        }
    }

    public void actionMarkAllNewsRead() {
        this.actionMarkAllNewsRead(this.rssOwlNewsTabFolder.getSelectedChannel());
    }

    public void actionMarkCategoryRead() {
        this.actionMarkCategoryRead(this.rssOwlFavoritesTree.getSelectedCat(), true);
    }

    public void actionMarkFavoriteRead() {
        this.actionMarkFavoriteRead(this.rssOwlFavoritesTree.getSelectedFav());
    }

    public void actionNewCategory() {
        TreeItemData treeItemData = null;
        if (this.rssOwlFavoritesTree.getFavoritesTree().getSelection().length > 0) {
            treeItemData = (TreeItemData)this.rssOwlFavoritesTree.getFavoritesTree().getSelection()[0].getData();
        }
        if (treeItemData != null && (treeItemData.isBlogroll() || treeItemData.isCategory())) {
            this.actionNewCategory(false);
        } else {
            this.actionNewCategory(true);
        }
    }

    public void actionNewCategory(boolean bl) {
        Category category = Category.getRootCategory();
        TreeItemData treeItemData = null;
        if (this.rssOwlFavoritesTree.getFavoritesTree().getSelection().length > 0) {
            treeItemData = (TreeItemData)this.rssOwlFavoritesTree.getFavoritesTree().getSelection()[0].getData();
        }
        if (treeItemData != null && !treeItemData.isBlogroll() && !treeItemData.isBlogrollFavorite()) {
            category = this.rssOwlFavoritesTree.getSelectedCat(this.rssOwlFavoritesTree.getTreePath(true));
        }
        if (!bl && !category.isRoot()) {
            category = category.getParent();
        } else {
            category.setExpanded(true);
        }
        this.actionNewCategory(this.shell, category);
    }

    public String actionNewCategory(Shell shell, Category category) {
        CategoryDialog categoryDialog = new CategoryDialog(shell, GUI.i18n.getTranslation("DIALOG_ADD_CATEGORY_TITLE"), GUI.i18n.getTranslation("DIALOG_ADD_CATEGORY_MESSAGE"), category);
        if (categoryDialog.open() == 0) {
            String string = categoryDialog.getCatName();
            this.rssOwlFavoritesTree.addCategory(string, category);
            this.rssOwlFavoritesTree.buildFavoritesTree();
            return string;
        }
        return null;
    }

    public void actionNewFavorite() {
        boolean bl = false;
        if (this.rssOwlFavoritesTree.getFavoritesTree().getSelectionCount() > 0 && !this.rssOwlFavoritesTree.getSelectedCat().isBlogroll()) {
            bl = true;
        }
        this.actionNewFavorite("", "", bl ? this.rssOwlFavoritesTree.getSelectedCat() : null);
    }

    public void actionNewFavorite(String string, String string2, Category category) {
        Favorite favorite = new Favorite(string, string2, null);
        favorite.setCatPath(category != null ? category.toCatPath() : "");
        favorite.setUseProxy(ProxyShop.isUseProxy());
        FavoriteDialog.isEditFavorite = false;
        FavoriteDialog favoriteDialog = new FavoriteDialog(favorite, this.shell, GUI.i18n.getTranslation("DIALOG_ADD_FAVORITE_TITLE"));
        if (favoriteDialog.open() != 0) {
            return;
        }
        favorite = favoriteDialog.getUpdatedFavorite();
        favorite.setCreationDate(new Date().getTime());
        this.rssOwlFavoritesTree.addFavorite(favorite.getCatPath(), favorite.getUrl(), favorite.getTitle(), favorite);
        this.rssOwlFavoritesTree.buildFavoritesTree();
        if (!GlobalSettings.workOffline) {
            this.rssOwlGui.reloadNewsFeed(favorite.getUrl());
        }
    }

    public void actionOpenFAQOnBrowser() {
        SearchDefinition searchDefinition = new SearchDefinition("Internal Browser on Linux", 1);
        if (new File("doc/faq.xml").exists()) {
            this.rssOwlGui.loadNewsFeed("doc/faq.xml", searchDefinition, true, true, 3);
        } else {
            this.rssOwlGui.loadNewsFeed(URLShop.RSSOWL_FAQ, searchDefinition, true, true, 3);
        }
    }

    public void actionOpenFAQ() {
        if (new File("doc/faq.xml").exists()) {
            this.rssOwlGui.loadNewsFeed("doc/faq.xml", SearchDefinition.NO_SEARCH, true, true, 0);
        } else {
            this.rssOwlGui.loadNewsFeed(URLShop.RSSOWL_FAQ, SearchDefinition.NO_SEARCH, true, true, 0);
        }
    }

    public void actionOpenFeed(String string) {
        this.rssOwlGui.loadNewsFeed(string, SearchDefinition.NO_SEARCH, true, true, 0);
    }

    public void actionOpenSelectedCategory() {
        Tree tree = this.rssOwlFavoritesTree.getFavoritesTree();
        if (tree.getSelectionCount() > 0) {
            TreeItem treeItem = tree.getSelection()[0];
            if (treeItem.getData() != null && ((TreeItemData)treeItem.getData()).isBlogroll()) {
                this.actionDeepSynchronizeBlogroll(this.rssOwlFavoritesTree.getSelectedCat());
            }
            TreeItem[] treeItemArray = tree.getSelection()[0].getItems();
            for (int i = 0; i < treeItemArray.length; ++i) {
                TreeItemData treeItemData;
                TreeItem treeItem2 = treeItemArray[i];
                if (treeItem2.getData() == null || (treeItemData = (TreeItemData)treeItem2.getData()).getFavorite() == null) continue;
                String string = treeItemData.getFavorite().getUrl();
                this.rssOwlGui.loadNewsFeed(string, SearchDefinition.NO_SEARCH, true, true, 2);
                treeItemData.getFavorite().setLastVisitDate(System.currentTimeMillis());
            }
        }
    }

    public void actionHandleSuppliedLink(String string) {
        if (Category.linkExists(string)) {
            this.rssOwlGui.loadNewsFeed(string, SearchDefinition.NO_SEARCH, true, true, 0);
        } else {
            this.rssOwlGui.eventManager.actionAddToFavorites("", string);
        }
    }

    public void actionOpenTutorial() {
        new TutorialBrowser(this.display, this.shell, this.rssOwlGui).show();
    }

    public void actionOpenURL(String string) {
        BrowserShop.openLinkInTab(string);
    }

    public void actionOpenURLExternal(String string) {
        BrowserShop.openLink(string);
    }

    public void actionReload() {
        this.rssOwlNewsTabFolder.reloadFeed();
    }

    public void actionReloadAllCategories() {
        this.actionAggregateCategory(Category.getRootCategory(), SearchDefinition.NO_SEARCH, true);
    }

    public void actionReloadFeed() {
        this.rssOwlGui.reloadNewsFeed(this.rssOwlFavoritesTree.getSelectedFav().getUrl());
    }

    public void actionRenameSelectedItem() {
        this.rssOwlFavoritesTree.renameSelectedItem();
    }

    public void actionSearchInAllCategories() {
        this.actionSearchInCategory(Category.getRootCategory());
    }

    public void actionSearchInCategory() {
        this.actionSearchInCategory(this.rssOwlFavoritesTree.getSelectedCat());
    }

    public void actionSearchInFeed() {
        SearchDialog searchDialog = new SearchDialog(this.shell, GUI.i18n.getTranslation("SEARCH_DIALOG_TITLE"), GUI.i18n.getTranslation("SEARCH_DIALOG_MESSAGE"));
        if (searchDialog.open() == 0) {
            SearchDefinition searchDefinition = searchDialog.getValue();
            if (!StringShop.isset(searchDefinition.getPattern())) {
                return;
            }
            TreeItemData treeItemData = (TreeItemData)this.rssOwlFavoritesTree.getFavoritesTree().getSelection()[0].getData();
            String string = Category.getLinkForTitle(treeItemData.getName());
            this.rssOwlGui.loadNewsFeed(string, searchDefinition, true, true, 0);
        }
    }

    public void actionSetBrowserView(boolean bl) {
        GlobalSettings.useBrowserForNewsText = bl;
        this.rssOwlGui.getRSSOwlMenu().setUseBrowserForNewsText(bl);
        this.rssOwlNewsText.updateNewsTextComposite();
        SettingsManager.getInstance().requestSave();
    }

    public void actionSetProxyOnTreeItem(boolean bl) {
        Category category = null;
        TreeItemData treeItemData = (TreeItemData)this.rssOwlFavoritesTree.getFavoritesTree().getSelection()[0].getData();
        if (treeItemData.isFavorite()) {
            treeItemData.getFavorite().setUseProxy(bl);
            category = this.rssOwlFavoritesTree.getSelectedCat();
        } else if (treeItemData.isBlogroll()) {
            Category category2;
            for (category2 = this.rssOwlFavoritesTree.getSelectedCat(this.rssOwlFavoritesTree.getTreePath(true)); category2 != null && category2.getParent().isBlogroll(); category2 = category2.getParent()) {
            }
            if (category2 != null) {
                category2.setUseProxy(bl);
                category = category2.getParent();
            }
        } else {
            this.rssOwlFavoritesTree.getSelectedCat().setUseProxy(bl);
            category = this.rssOwlFavoritesTree.getSelectedCat().getParent();
        }
        if (category != null) {
            category.checkUseProxy(category);
        }
    }

    public void actionSynchronizeBlogroll() {
        Category category;
        for (category = this.rssOwlFavoritesTree.getSelectedCat(this.rssOwlFavoritesTree.getTreePath(true)); category != null && category.getParent().isBlogroll(); category = category.getParent()) {
        }
        this.actionSynchronizeBlogroll(category);
    }

    public void actionSynchronizeBlogroll(Category category) {
        Importer importer = new Importer(category.getPathToBlogroll(), category.getName(), category);
        this.shell.setCursor(GUI.display.getSystemCursor(1));
        try {
            importer.importNewsfeeds(true);
            category.setUnSynchronized(false);
        }
        catch (IOException iOException) {
            MessageBoxFactory.showError(this.shell, GUI.i18n.getTranslation("ERROR_FILE_NOT_FOUND") + ":\n" + category.getPathToBlogroll());
            category.setExpanded(false);
        }
        catch (JDOMException jDOMException) {
            MessageBoxFactory.showError(this.shell, jDOMException.getLocalizedMessage() + ":\n" + category.getPathToBlogroll());
            category.setExpanded(false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MessageBoxFactory.showError(this.shell, illegalArgumentException.getLocalizedMessage() + ":\n" + category.getPathToBlogroll());
            category.setExpanded(false);
        }
        this.rssOwlGui.getRSSOwlFavoritesTree().buildFavoritesTree(true);
        this.shell.setCursor(null);
    }

    public void actionValidateFeeds(boolean bl) {
        Object object;
        CTabItem cTabItem = this.rssOwlNewsTabFolder.getNewsHeaderTabFolder().getSelection();
        String string = null;
        if (cTabItem != null && !((TabItemData)(object = (TabItemData)cTabItem.getData())).isMessage()) {
            string = ((TabItemData)cTabItem.getData()).getUrl();
        }
        if (!bl) {
            if (!StringShop.isset(string)) {
                TextTransfer textTransfer;
                object = GUI.rssOwlGui.getEventManager().getClipBoard();
                String string2 = (String)((Clipboard)object).getContents(textTransfer = TextTransfer.getInstance());
                String string3 = string2 = string2 != null ? string2.trim() : null;
                if (StringShop.isset(string2) && RegExShop.isValidURL(string2)) {
                    string = string2;
                }
            }
            if (((Window)(object = new ValidateFeedDialog(this.shell, GUI.i18n.getTranslation("MENU_VALIDATE"), GUI.i18n.getTranslation("MESSAGEBOX_FILL_URL"), string))).open() == 0) {
                string = ((ValidateFeedDialog)object).getFeedUrl();
            } else {
                return;
            }
        }
        if (StringShop.isset(string)) {
            this.actionOpenURL("http://validator.w3.org/feed/check.cgi?url=" + URLShop.urlEncode(string));
        }
    }

    public Clipboard getClipBoard() {
        return this.cb;
    }

    public void syncControls() {
        this.rssOwlFavoritesTree = this.rssOwlGui.getRSSOwlFavoritesTree();
        this.rssOwlNewsTabFolder = this.rssOwlGui.getRSSOwlNewsTabFolder();
        this.rssOwlQuickView = this.rssOwlGui.getRSSOwlQuickview();
        this.rssOwlNewsText = this.rssOwlGui.getRSSOwlNewsText();
    }

    void actionAggregateCategory(Category category, SearchDefinition searchDefinition, boolean bl) {
        if (category == null) {
            return;
        }
        if (bl) {
            this.rssOwlGui.getFeedCacheManager().unCacheNewsfeed(category.toCatPath(true), false);
        }
        this.actionDeepSynchronizeBlogroll(category);
        TreeSet treeSet = new TreeSet(new Comparator(){

            public int compare(Object object, Object object2) {
                return -1;
            }
        });
        category.getAllFavoriteTitles(treeSet, category);
        if (treeSet.size() > 0) {
            AggregationLoader aggregationLoader = new AggregationLoader(treeSet, category, this.rssOwlGui, category.toCatPath(true), searchDefinition);
            aggregationLoader.setReload(bl);
            aggregationLoader.loadFavorites(!bl);
        } else {
            MessageBoxFactory.showMessage(this.shell, 2, GUI.i18n.getTranslation("MESSAGEBOX_TITLE_INFORMATION"), GUI.i18n.getTranslation("DIALOG_MESSAGE_CAT_EMPTY"));
        }
    }

    void actionBlogNews() {
        NewsItem newsItem = this.rssOwlNewsTabFolder.getSelectedNewsItem();
        if (newsItem != null) {
            BlogShop.blogNews(newsItem);
        }
    }

    void actionCheckUpdate() {
        UpdateManager updateManager = new UpdateManager(this.rssOwlGui);
        updateManager.setDisplayNoNewVersionInfo(true);
        updateManager.start();
    }

    void actionCloseAll() {
        this.rssOwlNewsTabFolder.closeAll();
    }

    void actionCloseOthers() {
        this.rssOwlNewsTabFolder.closeAll(true, false);
    }

    void actionCopyNewsUrl() {
        NewsItem newsItem = this.rssOwlNewsTabFolder.getSelectedNewsItem();
        if (newsItem != null && StringShop.isset(newsItem.getLink())) {
            this.cb.setContents(new Object[]{newsItem.getLink()}, new Transfer[]{TextTransfer.getInstance()});
        }
    }

    void actionCopyText(Control control) {
        if (control instanceof StyledText) {
            if (((StyledText)control).getText() != null) {
                if (((StyledText)control).getSelectionCount() > 0) {
                    this.cb.setContents(new Object[]{((StyledText)control).getSelectionText()}, new Transfer[]{TextTransfer.getInstance()});
                } else {
                    this.cb.setContents(new Object[]{((StyledText)control).getText()}, new Transfer[]{TextTransfer.getInstance()});
                }
            }
        } else if (control instanceof Hyperlink && ((Hyperlink)control).getText() != null) {
            this.cb.setContents(new Object[]{((Hyperlink)control).getText()}, new Transfer[]{TextTransfer.getInstance()});
        }
    }

    void actionDeepSynchronizeBlogroll(Category category) {
        if (category.isBlogroll() && category.isUnSynchronized()) {
            this.actionSynchronizeBlogroll(category);
        } else if (!category.isBlogroll()) {
            Enumeration enumeration = category.getSubCategories().elements();
            while (enumeration.hasMoreElements()) {
                this.actionDeepSynchronizeBlogroll((Category)enumeration.nextElement());
            }
        }
    }

    void actionDiscoverFeeds() {
        new FeedDiscoveryDialog(GUI.i18n.getTranslation("MENU_FEED_DISCOVERY"), GUI.i18n.getTranslation("DIALOG_MESSAGE_ENTER_URL"), this.rssOwlGui).open();
    }

    void actionExit() {
        this.rssOwlGui.onClose(new Event(), true);
        if (GUI.isClosing) {
            this.display.dispose();
        }
    }

    void actionExportFeed(int n) {
        this.actionExportFeed(n, true);
    }

    void actionExportFeed(int n, boolean bl) {
        if (bl) {
            this.rssOwlNewsTabFolder.exportToDocument(n, null);
        } else {
            NewsItem newsItem = this.rssOwlNewsTabFolder.getSelectedNewsItem();
            if (newsItem != null) {
                this.rssOwlNewsTabFolder.exportToDocument(n, newsItem.getTitle());
            }
        }
    }

    void actionGotoNextNews() {
        NewsTable.actionDisplayNextNews(false);
    }

    void actionGotoNextTab() {
        this.rssOwlNewsTabFolder.gotoNextTab();
    }

    void actionGotoNextUnreadNews() {
        NewsTable.actionDisplayNextNews(true);
    }

    void actionGotoPreviousTab() {
        this.rssOwlNewsTabFolder.gotoPreviousTab();
    }

    void actionMailNewsTip() {
        NewsItem newsItem = this.rssOwlNewsTabFolder.getSelectedNewsItem();
        if (newsItem != null) {
            BrowserShop.openLink(newsItem.toNewsTip());
        }
    }

    void actionMarkAllNewsRead(Channel channel) {
        this.actionMarkAllNewsRead(channel, true);
    }

    void actionMarkAllNewsRead(Channel channel, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        if (channel == null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration enumeration = channel.getItems().elements();
        while (enumeration.hasMoreElements()) {
            object3 = (NewsItem)enumeration.nextElement();
            ((NewsItem)object3).setRead(true);
            if (((NewsItem)object3).getNewsfeedXmlUrl() != null && !arrayList.contains(((NewsItem)object3).getNewsfeedXmlUrl())) {
                arrayList.add(((NewsItem)object3).getNewsfeedXmlUrl());
            }
            this.rssOwlGui.getArchiveManager().getArchive().addEntry((NewsItem)object3);
        }
        if (channel.getLink() != null && Category.getFavPool().containsKey(channel.getLink())) {
            object3 = (Favorite)Category.getFavPool().get(channel.getLink());
            ((Favorite)object3).updateReadStatus(0);
        }
        if (channel.isAggregatedCat()) {
            for (int i = 0; i < arrayList.size(); ++i) {
                object2 = (String)arrayList.get(i);
                if (!Category.getFavPool().containsKey(object2)) continue;
                object = (Favorite)Category.getFavPool().get(object2);
                ((Favorite)object).updateReadStatus(0);
            }
        }
        if (!bl) {
            return;
        }
        CTabItem cTabItem = this.rssOwlNewsTabFolder.getNewsHeaderTabFolder().getSelection();
        object2 = (TabItemData)cTabItem.getData();
        Object object4 = object = object2 != null ? ((TabItemData)object2).getNewsHeaderTable() : null;
        if (WidgetShop.isset((Widget)object)) {
            NewsTable.markAllRead((Table)object);
        }
        this.rssOwlNewsTabFolder.updateTabItemStatus(cTabItem);
    }

    void actionMarkCategoryRead(Category category, boolean bl) {
        Object object;
        if (category == null) {
            return;
        }
        Enumeration enumeration = category.getSubCategories().elements();
        while (enumeration.hasMoreElements()) {
            this.actionMarkCategoryRead((Category)enumeration.nextElement(), false);
        }
        Enumeration enumeration2 = category.getFavorites().elements();
        while (enumeration2.hasMoreElements()) {
            object = (Favorite)enumeration2.nextElement();
            this.actionMarkFavoriteRead((Favorite)object, false);
        }
        object = this.rssOwlNewsTabFolder.getTabItem(category);
        if (object != null) {
            Table table = ((TabItemData)((Widget)object).getData()).getNewsHeaderTable();
            if (WidgetShop.isset(table)) {
                NewsTable.markAllRead(table);
            }
            Channel channel = ((TabItemData)((Widget)object).getData()).getChannel();
            Enumeration enumeration3 = channel.getItems().elements();
            while (enumeration3.hasMoreElements()) {
                NewsItem newsItem = (NewsItem)enumeration3.nextElement();
                newsItem.setRead(true);
            }
            this.rssOwlNewsTabFolder.updateTabItemStatus((CTabItem)object);
        }
        if (GlobalSettings.useSystemTray() && GlobalSettings.showSystrayIcon && bl) {
            boolean bl2 = this.rssOwlFavoritesTree.getTreeHasUnreadFavs();
            this.rssOwlGui.getRSSOwlSystray().setTrayItemState(bl2);
        }
    }

    void actionMarkFavoriteRead(Favorite favorite) {
        this.actionMarkFavoriteRead(favorite, true);
    }

    void actionMarkFavoriteRead(Favorite favorite, boolean bl) {
        Object object;
        Object object2;
        if (favorite == null) {
            return;
        }
        String string = favorite.getUrl();
        if (this.rssOwlGui.getFeedCacheManager().isNewsfeedCached(string, favorite.unreadNewsAvailable()) && (object2 = this.rssOwlGui.getFeedCacheManager().getCachedNewsfeed(string)) != null) {
            object = ((Channel)object2).getItems().elements();
            while (object.hasMoreElements()) {
                NewsItem newsItem = (NewsItem)object.nextElement();
                newsItem.setRead(true);
                this.rssOwlGui.getArchiveManager().getArchive().addEntry(newsItem);
            }
        }
        if ((object2 = this.rssOwlNewsTabFolder.getFeedTabItem(string)) == null) {
            object2 = this.rssOwlNewsTabFolder.getFeedTabItem(favorite.getTitle());
        }
        if (object2 != null) {
            object = ((TabItemData)((Widget)object2).getData()).getNewsHeaderTable();
            if (WidgetShop.isset((Widget)object)) {
                NewsTable.markAllRead((Table)object);
            }
            this.rssOwlNewsTabFolder.updateTabItemStatus((CTabItem)object2);
        }
        favorite.updateReadStatus(0, bl);
    }

    void actionMarkNewsUnread() {
        this.actionMarkNewsUnread(this.rssOwlNewsTabFolder.getSelectedNewsItem());
    }

    void actionMarkNewsUnread(NewsItem newsItem) {
        Favorite favorite;
        this.rssOwlGui.getArchiveManager().getArchive().removeEntry(newsItem);
        CTabItem cTabItem = this.rssOwlNewsTabFolder.getNewsHeaderTabFolder().getSelection();
        TabItemData tabItemData = (TabItemData)cTabItem.getData();
        Table table = tabItemData.getNewsHeaderTable();
        if (WidgetShop.isset(table)) {
            if (table.getSelectionCount() <= 0) {
                return;
            }
            table.getItem(table.getSelectionIndex()).setData(TableItemData.createNewsheaderData(false));
            NewsTable.updateTableItemStyle(table.getItem(table.getSelectionIndex()));
        }
        newsItem.setRead(false);
        Channel channel = this.rssOwlNewsTabFolder.getSelectedChannel();
        String string = null;
        if (channel != null && channel.getLink() != null && Category.getFavPool().containsKey(channel.getLink())) {
            string = channel.getLink();
        } else if (newsItem.getNewsfeedXmlUrl() != null && Category.getFavPool().containsKey(newsItem.getNewsfeedXmlUrl())) {
            string = newsItem.getNewsfeedXmlUrl();
        }
        if (string != null && !(favorite = (Favorite)Category.getFavPool().get(string)).isErrorLoading() && channel != null) {
            if (channel.isAggregatedCat()) {
                favorite.updateReadStatus(channel.getUnreadNewsCount(newsItem.getNewsfeedXmlUrl()));
            } else {
                favorite.updateReadStatus(channel.getUnreadNewsCount());
            }
        }
        this.rssOwlNewsTabFolder.updateTabItemStatus(cTabItem);
    }

    void actionMinimizeWindow() {
        this.shell.setMinimized(true);
    }

    void actionOpenAbout() {
        new AboutDialog(this.shell, GUI.i18n.getTranslation("MENU_ABOUT")).open();
    }

    void actionOpenFeed() {
        String string;
        OpenFeedDialog openFeedDialog = new OpenFeedDialog(this.shell, GUI.i18n.getTranslation("BUTTON_OPEN"), GUI.i18n.getTranslation("MESSAGEBOX_FILL_URL"));
        if (openFeedDialog.open() == 0 && StringShop.isset(string = openFeedDialog.getFeedPath())) {
            this.actionOpenFeed(string);
        }
    }

    void actionOpenNewsURL(String string, boolean bl) {
        Channel channel = this.rssOwlNewsTabFolder.getSelectedChannel();
        if (channel == null) {
            return;
        }
        NewsItem newsItem = (NewsItem)channel.getItems().get(string);
        if (newsItem == null) {
            return;
        }
        String string2 = newsItem.getLink();
        if (!StringShop.isset(string2) && StringShop.isset(newsItem.getGuid())) {
            string2 = newsItem.getGuid();
        }
        if (!StringShop.isset(string2)) {
            return;
        }
        if (bl) {
            this.actionOpenURLExternal(string2);
        } else {
            this.actionOpenURL(string2);
        }
    }

    void actionOpenPreferences() {
        new PreferencesDialog(this.shell, GUI.i18n.getTranslation("MENU_PREFERENCES"), this.rssOwlGui).open();
    }

    void actionOpenURL(String string, boolean bl) {
        if (bl) {
            this.actionNewFavorite(string, "", null);
        } else {
            this.actionOpenURL(string);
        }
    }

    void actionPrintNews() {
        boolean bl = GlobalSettings.useBrowserForNewsText ? PrintShop.printNewsFromBrowser() : PrintShop.printNewsFromText();
        if (!bl) {
            MessageBoxFactory.showMessage(this.shell, 8, GUI.i18n.getTranslation("TOOLTIP_PRINT"), GUI.i18n.getTranslation("MESSAGEBOX_PRINT_EMPTYTEXT"));
        }
    }

    void actionRateNews(NewsItem newsItem, int n) {
        this.rssOwlNewsText.rateNews(newsItem, n);
    }

    void actionSaveFeed() {
        if (!FileShop.saveSelectedNewsFeed()) {
            MessageBoxFactory.showMessage(this.shell, 8, GUI.i18n.getTranslation("MENU_SAVE"), GUI.i18n.getTranslation("MESSAGEBOX_ERROR_SAVE_RSS"));
        }
    }

    void actionSearch() {
        this.rssOwlNewsTabFolder.searchInSelectedFeed();
    }

    void actionSearchFeeds() {
        new FeedSearchDialog(GUI.i18n.getTranslation("MENU_FEEDSEARCH"), GUI.i18n.getTranslation("LABEL_SEARCH_TOPIC"), this.rssOwlGui).open();
    }

    void actionSearchInCategory(Category category) {
        String string = category.isRoot() ? GUI.i18n.getTranslation("BUTTON_SEARCH_ALL") : GUI.i18n.getTranslation("SEARCH_DIALOG_TITLE");
        SearchDialog searchDialog = new SearchDialog(this.shell, category, string, GUI.i18n.getTranslation("SEARCH_DIALOG_MESSAGE"));
        if (searchDialog.open() == 0) {
            SearchDefinition searchDefinition = searchDialog.getValue();
            if (!StringShop.isset(searchDefinition.getPattern())) {
                return;
            }
            Category category2 = category;
            if (searchDialog.getCategory() != null && !searchDialog.getCategory().isRoot()) {
                category2 = searchDialog.getCategory();
            }
            this.actionAggregateCategory(category2, searchDefinition, false);
        }
    }

    void actionShowLicense() {
        this.rssOwlNewsTabFolder.showLicenseTab(this.getClass().getResourceAsStream("/usr/EPL.txt"), PaintShop.iconInfo);
    }

    void actionShowQuickview(boolean bl) {
        this.rssOwlQuickView.setShowQuickview(bl, true);
    }

    void actionShowToolBar(boolean bl) {
        this.rssOwlQuickView.setShowToolBar(bl, true);
    }

    void actionShowWelcome() {
        this.rssOwlNewsTabFolder.showWelcomeTab();
    }

    void actionTellFriends() {
        BrowserShop.openLink(URLShop.createTellMyFriends());
    }

    void actionViewFeedInDocument(int n) {
        this.rssOwlNewsTabFolder.viewNewsInDocument(n);
    }

    void handleEditAction(int n) {
        Control control = this.display.getFocusControl();
        if (!WidgetShop.isset(control)) {
            return;
        }
        switch (n) {
            case 0: {
                if (control instanceof Text) {
                    ((Text)control).cut();
                    break;
                }
                if (control instanceof StyledText) {
                    ((StyledText)control).cut();
                    break;
                }
                if (!(control instanceof Combo)) break;
                ((Combo)control).cut();
                break;
            }
            case 1: {
                if (control instanceof Text) {
                    ((Text)control).copy();
                    break;
                }
                if (control instanceof StyledText) {
                    ((StyledText)control).copy();
                    break;
                }
                if (!(control instanceof Combo)) break;
                ((Combo)control).copy();
                break;
            }
            case 2: {
                if (control instanceof Text) {
                    ((Text)control).paste();
                    break;
                }
                if (control instanceof StyledText) {
                    ((StyledText)control).paste();
                    break;
                }
                if (!(control instanceof Combo)) break;
                ((Combo)control).paste();
                break;
            }
            case 3: {
                Object object;
                Tree tree;
                if (!(control instanceof Tree) || (tree = (Tree)control).getSelectionCount() <= 0 || tree.getSelection()[0].getData() == null || !((object = tree.getSelection()[0].getData()) instanceof TreeItemData)) break;
                this.rssOwlGui.getRSSOwlFavoritesTree().performDeletion();
                break;
            }
            case 4: {
                if (control instanceof Text) {
                    ((Text)control).selectAll();
                    break;
                }
                if (control instanceof StyledText) {
                    ((StyledText)control).selectAll();
                    break;
                }
                if (!(control instanceof Combo)) break;
                ((Combo)control).setSelection(new Point(0, ((Combo)control).getText().length()));
                break;
            }
            case 5: {
                Tree tree;
                if (!(control instanceof Tree) || (tree = (Tree)control).getSelectionCount() <= 0 || tree.getSelection()[0].getData() == null) break;
                Object object = tree.getSelection()[0].getData();
                if (object instanceof TreeItemData && ((TreeItemData)object).isFavorite()) {
                    this.actionEditFavorite();
                    break;
                }
                if (object instanceof TreeItemData && ((TreeItemData)object).isCategory()) {
                    this.actionEditCategory();
                    break;
                }
                if (!(object instanceof TreeItemData) || !((TreeItemData)object).isBlogroll()) break;
                this.actionEditBlogroll();
            }
        }
    }
}

